/*
 * Decompiled with CFR 0.152.
 */
package pl.execon.fsp.relational;

import java.util.List;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import pl.execon.fsp.core.FspRequest;
import pl.execon.fsp.core.FspResponse;
import pl.execon.fsp.relational.FilteringAndSortingSpecification;
import pl.execon.fsp.relational.FilteringSpecification;

public interface RelationalFsp<T>
extends JpaSpecificationExecutor<T> {
    default public FspResponse<T> findFsp(FspRequest fspRequest) {
        FilteringSpecification specification = new FilteringSpecification(fspRequest);
        FilteringAndSortingSpecification filteringAndSortingSpecification = new FilteringAndSortingSpecification(fspRequest);
        if (!fspRequest.hasPageInfo()) {
            List list = this.findAll(specification, filteringAndSortingSpecification.getSort());
            return new FspResponse(list);
        }
        Page listWithPagination = this.findAll(specification, (Pageable)filteringAndSortingSpecification.getPageRequest());
        long count = this.count(specification);
        return new FspResponse(fspRequest, listWithPagination.getContent(), count);
    }
}

