/*
 * Decompiled with CFR 0.152.
 */
package pl.execon.fsp.relational.predicate;

import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Optional;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import pl.execon.fsp.core.FilterInfo;
import pl.execon.fsp.relational.exception.FilteringException;

abstract class AbstractPredicate<T> {
    private static final String EXCEPTION_MESSAGE = "Unsupported field/operator combination: %s(%s) with operator %s";
    static final DateTimeFormatter LOCAL_DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");

    AbstractPredicate() {
    }

    public Predicate of(Root<T> root, CriteriaBuilder criteriaBuilder, FilterInfo filter) {
        Path field;
        ArrayList<String> filterFields = new ArrayList<String>();
        if (filter.getBy().contains(".")) {
            filterFields.addAll(Arrays.asList(filter.getBy().split("\\.")));
        }
        if (!filterFields.isEmpty()) {
            field = root.get((String)filterFields.get(0));
            filterFields.remove(filterFields.get(0));
            for (String filterField : filterFields) {
                field = field.get(filterField);
            }
        } else {
            field = root.get(filter.getBy());
        }
        Class fieldClass = field.getJavaType();
        Object target = filter.getValue();
        return Optional.ofNullable(this.createPredicate(field, fieldClass, target, criteriaBuilder)).orElseThrow(() -> new FilteringException(String.format(EXCEPTION_MESSAGE, filter.getBy(), fieldClass, filter.getOperator())));
    }

    protected abstract Predicate createPredicate(Path var1, Class var2, Object var3, CriteriaBuilder var4);
}

