/*
 * Decompiled with CFR 0.152.
 */
package pl.execon.fsp.relational.predicate;

import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;
import org.apache.commons.lang3.EnumUtils;
import pl.execon.fsp.relational.predicate.AbstractPredicate;

class EqualsPredicate<T>
extends AbstractPredicate<T> {
    EqualsPredicate() {
    }

    @Override
    protected Predicate createPredicate(Path field, Class fieldClass, Object target, CriteriaBuilder criteriaBuilder) {
        if (fieldClass.equals(String.class)) {
            return criteriaBuilder.equal((Expression)field, (Object)target.toString());
        }
        if (fieldClass.equals(Long.class) || fieldClass.equals(Long.TYPE)) {
            return criteriaBuilder.equal((Expression)field, (Object)Long.valueOf(target.toString()));
        }
        if (fieldClass.equals(Integer.class) || fieldClass.equals(Integer.TYPE)) {
            return criteriaBuilder.equal((Expression)field, (Object)Integer.valueOf(target.toString()));
        }
        if (fieldClass.equals(Double.class) || fieldClass.equals(Double.TYPE)) {
            return criteriaBuilder.equal((Expression)field, (Object)Double.valueOf(target.toString()));
        }
        if (fieldClass.equals(Float.class) || fieldClass.equals(Float.TYPE)) {
            return criteriaBuilder.equal((Expression)field, (Object)Float.valueOf(target.toString()));
        }
        if (fieldClass.isEnum()) {
            return criteriaBuilder.equal((Expression)field, (Object)EnumUtils.getEnum((Class)fieldClass, (String)target.toString()));
        }
        if (fieldClass.equals(Boolean.class) || fieldClass.equals(Boolean.TYPE)) {
            return criteriaBuilder.equal((Expression)field, (Object)Boolean.parseBoolean(target.toString()));
        }
        if (fieldClass.equals(LocalDateTime.class)) {
            return criteriaBuilder.equal((Expression)field, (Object)LocalDateTime.parse(target.toString(), DateTimeFormatter.ISO_LOCAL_DATE_TIME));
        }
        if (fieldClass.equals(LocalDate.class)) {
            return criteriaBuilder.equal((Expression)field, (Object)LocalDate.parse(target.toString(), DateTimeFormatter.ISO_LOCAL_DATE));
        }
        if (fieldClass.equals(Timestamp.class)) {
            return criteriaBuilder.equal((Expression)field, (Object)Timestamp.valueOf(LocalDateTime.parse(target.toString(), LOCAL_DATE_TIME_FORMATTER)));
        }
        return null;
    }
}

