/*
 * Decompiled with CFR 0.152.
 */
package pl.execon.fsp.relational.predicate;

import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import pl.execon.fsp.core.FilterInfo;
import pl.execon.fsp.core.Operation;
import pl.execon.fsp.relational.predicate.EqualsPredicate;
import pl.execon.fsp.relational.predicate.GreaterThanPredicate;
import pl.execon.fsp.relational.predicate.IncludePredicate;
import pl.execon.fsp.relational.predicate.SeriesPredicate;

public class PredicateCreator<T> {
    private Root<T> root;
    private CriteriaBuilder criteriaBuilder;

    public Predicate toPredicate(FilterInfo filter) {
        Operation operation = filter.getOperation();
        Predicate predicate = null;
        switch (operation) {
            case EQUALS: {
                predicate = new EqualsPredicate<T>().of(this.root, this.criteriaBuilder, filter);
                break;
            }
            case NOT_EQUALS: {
                predicate = new EqualsPredicate<T>().of(this.root, this.criteriaBuilder, filter).not();
                break;
            }
            case CONTAINS: {
                predicate = new IncludePredicate<T>().of(this.root, this.criteriaBuilder, filter);
                break;
            }
            case IN: {
                predicate = new SeriesPredicate<T>().of(this.root, this.criteriaBuilder, filter);
                break;
            }
            case NOT_IN: {
                predicate = new SeriesPredicate<T>().of(this.root, this.criteriaBuilder, filter).not();
                break;
            }
            case GREATER_THAN: {
                predicate = new GreaterThanPredicate<T>().of(this.root, this.criteriaBuilder, filter);
                break;
            }
            case LESS_THAN: {
                predicate = this.criteriaBuilder.and((Expression)new GreaterThanPredicate<T>().of(this.root, this.criteriaBuilder, filter).not(), (Expression)new EqualsPredicate<T>().of(this.root, this.criteriaBuilder, filter).not());
                break;
            }
            case GREATER_OR_EQUALS: {
                predicate = this.criteriaBuilder.or((Expression)new GreaterThanPredicate<T>().of(this.root, this.criteriaBuilder, filter), (Expression)new EqualsPredicate<T>().of(this.root, this.criteriaBuilder, filter));
                break;
            }
            case LESS_OR_EQUALS: {
                predicate = this.criteriaBuilder.or(new Predicate[]{new GreaterThanPredicate<T>().of(this.root, this.criteriaBuilder, filter).not()});
            }
        }
        return predicate;
    }

    public PredicateCreator(Root<T> root, CriteriaBuilder criteriaBuilder) {
        this.root = root;
        this.criteriaBuilder = criteriaBuilder;
    }
}

