/*
 * Decompiled with CFR 0.152.
 */
package pl.execon.fsp.relational.predicate;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;
import org.apache.commons.lang3.EnumUtils;
import pl.execon.fsp.relational.predicate.AbstractPredicate;

class SeriesPredicate<T>
extends AbstractPredicate<T> {
    SeriesPredicate() {
    }

    @Override
    protected Predicate createPredicate(Path field, Class fieldClass, Object target, CriteriaBuilder criteriaBuilder) {
        if (fieldClass.isEnum()) {
            return field.in(new Object[]{((List)target).stream().map(e -> EnumUtils.getEnum((Class)fieldClass, (String)e.toString())).collect(Collectors.toList())});
        }
        if (fieldClass.isAssignableFrom(Boolean.class) || fieldClass.isAssignableFrom(Boolean.TYPE)) {
            return field.in((Collection)((List)target).stream().map(e -> Boolean.parseBoolean(e.toString())).collect(Collectors.toList()));
        }
        if (fieldClass.isAssignableFrom(LocalDateTime.class)) {
            return field.in((Collection)((List)target).stream().map(Object::toString).map(obj -> LocalDateTime.parse(obj, DateTimeFormatter.ISO_LOCAL_DATE_TIME)).collect(Collectors.toList()));
        }
        if (fieldClass.isAssignableFrom(LocalDate.class)) {
            return field.in((Collection)((List)target).stream().map(Object::toString).map(obj -> LocalDate.parse(obj, DateTimeFormatter.ISO_LOCAL_DATE)).collect(Collectors.toList()));
        }
        if (fieldClass.equals(Long.class) || fieldClass.equals(Long.TYPE)) {
            return field.in((Collection)((List)target).stream().map(Object::toString).map(Long::valueOf).collect(Collectors.toList()));
        }
        if (fieldClass.equals(Integer.class) || fieldClass.equals(Integer.TYPE)) {
            return field.in((Collection)((List)target).stream().map(Object::toString).map(Integer::valueOf).collect(Collectors.toList()));
        }
        if (fieldClass.equals(Double.class) || fieldClass.equals(Double.TYPE)) {
            return field.in((Collection)((List)target).stream().map(Object::toString).map(Double::valueOf).collect(Collectors.toList()));
        }
        if (fieldClass.equals(Float.class) || fieldClass.equals(Float.TYPE)) {
            return field.in((Collection)((List)target).stream().map(Object::toString).map(Float::valueOf).collect(Collectors.toList()));
        }
        return field.in((Collection)((List)target));
    }
}

