/*
 * Decompiled with CFR 0.152.
 */
package pl.gdela.socomo.bytecode;

import org.apache.commons.lang3.Validate;
import org.objectweb.asm.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.gdela.socomo.bytecode.DependencyCollectorAdapter;
import pl.gdela.socomo.codemap.DepType;

class SignatureVisitor
extends org.objectweb.asm.signature.SignatureVisitor {
    private static final Logger log = LoggerFactory.getLogger(SignatureVisitor.class);
    private final DependencyCollectorAdapter collector;
    private final DepType currentType;
    private final String indent;
    private Type resolvedClassType;
    private Type visitedInnerClassType;

    private SignatureVisitor(DependencyCollectorAdapter collector, DepType initialType, String indent) {
        super(327680);
        this.collector = collector;
        this.currentType = initialType;
        this.indent = indent;
    }

    SignatureVisitor(DependencyCollectorAdapter collector, DepType initialType) {
        this(collector, initialType, "");
    }

    SignatureVisitor(DependencyCollectorAdapter collector) {
        this(collector, null);
    }

    private SignatureVisitor dive(DepType newScope) {
        return new SignatureVisitor(this.collector, newScope, this.indent + "  ");
    }

    public SignatureVisitor visitSuperclass() {
        log.trace("{} superclass", (Object)this.indent);
        return this.dive(DepType.EXTENDS);
    }

    public SignatureVisitor visitInterface() {
        log.trace("{} interface", (Object)this.indent);
        return this.dive(DepType.IMPLEMENTS);
    }

    public SignatureVisitor visitParameterType() {
        log.trace("{} parameter type", (Object)this.indent);
        return this.dive(DepType.HAS_PARAM);
    }

    public SignatureVisitor visitReturnType() {
        log.trace("{} return type", (Object)this.indent);
        return this.dive(DepType.RETURNS);
    }

    public SignatureVisitor visitExceptionType() {
        log.trace("{} exception type", (Object)this.indent);
        return this.dive(DepType.THROWS);
    }

    public void visitTypeArgument() {
        log.trace("{} type argument", (Object)this.indent);
    }

    public SignatureVisitor visitTypeArgument(char wildcard) {
        log.trace("{} type argument {}", (Object)this.indent, (Object)Character.valueOf(wildcard));
        return this.dive(DepType.TYPE_PARAM);
    }

    public void visitFormalTypeParameter(String name) {
        log.trace("{} format type parameter {}", (Object)this.indent, (Object)name);
    }

    public SignatureVisitor visitClassBound() {
        log.trace("{} class bound", (Object)this.indent);
        return this.dive(DepType.TYPE_PARAM);
    }

    public SignatureVisitor visitInterfaceBound() {
        log.trace("{} interface bound", (Object)this.indent);
        return this.dive(DepType.TYPE_PARAM);
    }

    public void visitBaseType(char descriptor) {
        log.trace("{} base type {}", (Object)this.indent, (Object)Character.valueOf(descriptor));
    }

    public void visitTypeVariable(String name) {
        log.trace("{} type variable {}", (Object)this.indent, (Object)name);
    }

    public SignatureVisitor visitArrayType() {
        log.trace("{} array type", (Object)this.indent);
        return this.dive(this.currentType);
    }

    public void visitClassType(String name) {
        log.trace("{} class type {}", (Object)this.indent, (Object)name);
        this.resolvedClassType = Type.getObjectType((String)name);
    }

    public void visitInnerClassType(String name) {
        log.trace("{} inner class type {}", (Object)this.indent, (Object)name);
        Validate.notNull((Object)this.resolvedClassType, (String)"this method should be called only after class type has been visited", (Object[])new Object[0]);
        this.visitedInnerClassType = Type.getObjectType((String)(this.resolvedClassType.getInternalName() + "$" + name));
    }

    public void visitEnd() {
        if (this.visitedInnerClassType != null) {
            this.collector.markDependency(this.currentType, this.visitedInnerClassType);
            this.visitedInnerClassType = null;
        } else if (this.resolvedClassType != null) {
            this.collector.markDependency(this.currentType, this.resolvedClassType);
            this.resolvedClassType = null;
        }
        log.trace("{} end", (Object)this.indent);
    }
}

