/*
 * Decompiled with CFR 0.152.
 */
package pl.gdela.socomo.codemap;

import org.apache.commons.lang3.builder.CompareToBuilder;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import pl.gdela.socomo.codemap.CodePackage;
import pl.gdela.socomo.codemap.Origin;

public class CodeMember
implements Comparable<CodeMember> {
    public final CodePackage packet;
    public final String className;
    public final String memberName;
    Origin origin = Origin.EXTERNAL;

    CodeMember(CodePackage packet, String className, String memberName) {
        this.packet = packet;
        this.className = className;
        this.memberName = memberName;
    }

    String relativeName() {
        return this.memberName != null ? this.className + "." + this.memberName : this.className;
    }

    void markOrigin(Origin newOrigin) {
        if (newOrigin.ordinal() < this.origin.ordinal()) {
            this.origin = newOrigin;
        }
    }

    public String toString() {
        return this.packet + "." + this.relativeName();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CodeMember that = (CodeMember)o;
        return new EqualsBuilder().append((Object)this.packet, (Object)that.packet).append((Object)this.className, (Object)that.className).append((Object)this.memberName, (Object)that.memberName).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.packet).append((Object)this.className).append((Object)this.memberName).toHashCode();
    }

    @Override
    public int compareTo(CodeMember that) {
        return new CompareToBuilder().append((Object)this.packet, (Object)that.packet).append((Object)this.className, (Object)that.className).append((Object)this.memberName, (Object)that.memberName).toComparison();
    }
}

