/*
 * Decompiled with CFR 0.152.
 */
package pl.gdela.socomo.composition;

import org.apache.commons.lang3.StringUtils;
import pl.gdela.socomo.codemap.CodePackage;
import pl.gdela.socomo.codemap.Codemap;
import pl.gdela.socomo.codemap.PackageDep;
import pl.gdela.socomo.composition.Component;
import pl.gdela.socomo.composition.ComponentDep;
import pl.gdela.socomo.composition.Level;

public class CodemapToLevel {
    public static Level transform(Codemap codemap, String levelName) {
        Level level = new Level(levelName);
        for (CodePackage packet : codemap.packages()) {
            Component component = CodemapToLevel.componentFor(packet, level);
            if (component == null) continue;
            component.incrementSizeBy(packet.size());
        }
        for (PackageDep packageDep : codemap.packageDeps()) {
            Component toComponent;
            Component fromComponent = CodemapToLevel.componentFor(packageDep.from, level);
            if (fromComponent == null || (toComponent = CodemapToLevel.componentFor(packageDep.to, level)) == null || fromComponent == toComponent) continue;
            ComponentDep componentDep = level.dependency(fromComponent, toComponent);
            componentDep.incrementStrengthBy(packageDep.strength());
        }
        return level;
    }

    private static Component componentFor(CodePackage packet, Level level) {
        String levelPrefix;
        if (packet.fqn.equals(level.name)) {
            return level.component("[root]");
        }
        String string = levelPrefix = level.name.equals("") ? "" : level.name + ".";
        if (packet.fqn.startsWith(levelPrefix)) {
            String suffix = StringUtils.substringAfter((String)packet.fqn, (String)levelPrefix);
            String componentName = StringUtils.substringBefore((String)suffix, (String)".");
            return level.component(componentName);
        }
        return null;
    }
}

