/*
 * Decompiled with CFR 0.152.
 */
package pl.gdela.socomo.visualizer;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.gdela.socomo.composition.Level;
import pl.gdela.socomo.composition.Module;
import pl.gdela.socomo.visualizer.Asset;
import pl.gdela.socomo.visualizer.VisualizerHtml;

public class VisualizerBuilder {
    private static final Logger log = LoggerFactory.getLogger(VisualizerBuilder.class);
    private Module module;
    private Level level;

    public void setModule(Module module) {
        this.module = module;
    }

    public void setLevel(Level level) {
        this.level = level;
    }

    public void buildInto(File file) {
        log.info("visualizing into {}", (Object)file);
        try {
            VisualizerHtml template = new VisualizerHtml(this.module);
            template.addLevel(this.level);
            template.addAsset(Asset.style("https://fonts.googleapis.com/css?family=Lato:400,700"));
            template.addAsset(Asset.script("https://cdn.jsdelivr.net/npm/lodash@4.17.11/lodash.min.js"));
            template.addAsset(Asset.script("https://cdn.jsdelivr.net/npm/cytoscape@3.2.22/dist/cytoscape.min.js"));
            template.addAsset(Asset.script("https://cdn.jsdelivr.net/npm/klayjs@0.4.1/klay.min.js"));
            template.addAsset(Asset.script("https://cdn.jsdelivr.net/npm/cytoscape-klay@3.1.2/cytoscape-klay.min.js"));
            for (Asset asset : this.ownAssets(file)) {
                template.addAsset(asset);
            }
            String visualizer = template.render();
            FileUtils.writeStringToFile((File)file, (String)visualizer, (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new RuntimeException("cannot build visualizer", e);
        }
    }

    private List<Asset> ownAssets(File visualizerFile) throws IOException {
        BuilderProperties props = BuilderProperties.read();
        if (props.socomoVersion.contains("SNAPSHOT")) {
            log.info("snapshot build of socomo discovered");
            return this.localOwnAssets(props.assetsLocation, visualizerFile);
        }
        log.debug("packed release of socomo discovered");
        return this.remoteOwnAssets(props.socomoVersion);
    }

    private List<Asset> remoteOwnAssets(String socomoVersion) {
        ArrayList<Asset> assets = new ArrayList<Asset>();
        String baseUrl = "https://cdn.jsdelivr.net/gh/gdela/socomo@" + socomoVersion;
        assets.add(Asset.script(baseUrl + "/dist/bundle.min.js"));
        assets.add(Asset.style(baseUrl + "/dist/bundle.min.css"));
        return assets;
    }

    private List<Asset> localOwnAssets(File assetsLocation, File visualizerFile) {
        log.info("using assets from {}", (Object)assetsLocation);
        if (!assetsLocation.isDirectory()) {
            String message = "snapshot assets directory not found: ";
            message = message + "either use released version of socomo, or build snapshot version of socomo yourself";
            throw new IllegalStateException(message);
        }
        Collection assetFiles = FileUtils.listFiles((File)assetsLocation, (String[])new String[]{"js", "css"}, (boolean)false);
        ArrayList<Asset> assets = new ArrayList<Asset>();
        for (File assetFile : assetFiles) {
            String extension = FilenameUtils.getExtension((String)assetFile.getName());
            if (extension.equals("js")) {
                assets.add(Asset.script(VisualizerBuilder.shortPath(visualizerFile, assetFile)));
            }
            if (!extension.equals("css")) continue;
            assets.add(Asset.style(VisualizerBuilder.shortPath(visualizerFile, assetFile)));
        }
        return assets;
    }

    private static String shortPath(File from, File to) {
        Path fromPath = from.toPath().toAbsolutePath().getParent();
        Path toPath = to.toPath().toAbsolutePath();
        return fromPath.relativize(toPath).toString();
    }

    private static class BuilderProperties {
        private String socomoVersion;
        private File assetsLocation;

        private BuilderProperties() {
        }

        static BuilderProperties read() throws IOException {
            URL propsFileUrl = BuilderProperties.class.getResource("builder.properties");
            Properties propsInFile = new Properties();
            try (InputStream propertiesStream = propsFileUrl.openStream();){
                propsInFile.load(propertiesStream);
            }
            BuilderProperties props = new BuilderProperties();
            props.socomoVersion = propsInFile.getProperty("socomo-version");
            File snapshotAssetsRoot = new File(propsInFile.getProperty("snapshot-assets-root"));
            props.assetsLocation = new File(snapshotAssetsRoot, BuilderProperties.class.getPackage().getName().replace('.', '/'));
            return props;
        }
    }
}

