/*
 * Decompiled with CFR 0.152.
 */
package pl.gdela.socomo;

import java.io.File;
import org.apache.commons.lang3.Validate;
import pl.gdela.socomo.SocomoFacade;

public final class Socomo {
    private Socomo() {
    }

    public static void main(String[] args) {
        if (args.length < 2) {
            System.err.println("Usage: socomo <input-directory> <output-directory>");
            System.err.println("- bytecode from <input-directory> will be analyzed");
            System.err.println("- results will be written to files in <output-directory>");
            System.exit(-1);
        }
        File input = new File(args[0]);
        File output = new File(args[1]);
        Validate.isTrue((boolean)input.isDirectory(), (String)"invalid <input-directory> %s, it is not a directory", (Object[])new Object[]{input});
        Validate.isTrue((boolean)output.isDirectory(), (String)"invalid <output-directory> %s, it is not a directory", (Object[])new Object[]{output});
        SocomoFacade socomo = new SocomoFacade(input.toString().replace('\\', '/'));
        socomo.analyzeBytecode(input);
        socomo.guessLevel();
        socomo.visualizeInto(new File(output, "socomo.html"));
    }
}

