/*
 * Decompiled with CFR 0.152.
 */
package pl.gdela.socomo;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.gdela.socomo.bytecode.BytecodeAnalyzer;
import pl.gdela.socomo.codemap.Codemap;
import pl.gdela.socomo.codemap.CodemappingCollector;
import pl.gdela.socomo.codemap.Origin;
import pl.gdela.socomo.composition.CodemapToLevel;
import pl.gdela.socomo.composition.Level;
import pl.gdela.socomo.composition.LevelGuesser;
import pl.gdela.socomo.composition.Module;
import pl.gdela.socomo.visualizer.VisualizerBuilder;

public class SocomoFacade {
    private static final Logger log = LoggerFactory.getLogger(SocomoFacade.class);
    private final Module module;
    private Codemap codemap;
    private Level level;

    public SocomoFacade(String moduleName) {
        this.module = new Module(moduleName);
    }

    public void analyzeBytecode(File directory) {
        CodemappingCollector collector = new CodemappingCollector();
        new BytecodeAnalyzer(collector).analyzeDir(SocomoFacade.shorten(directory));
        this.codemap = collector.getCodemap().select(Origin.MAIN);
        log.trace("codemap:\n{}", (Object)this.codemap.formatted());
    }

    public void guessLevel() {
        String levelName = LevelGuesser.guessLevel(this.codemap);
        this.level = CodemapToLevel.transform(this.codemap, levelName);
        log.debug("level {}:\n{}", (Object)this.level.name, (Object)this.level.formatted());
    }

    public void visualizeInto(File file) {
        VisualizerBuilder builder = new VisualizerBuilder();
        builder.setModule(this.module);
        builder.setLevel(this.level);
        builder.buildInto(SocomoFacade.shorten(file));
    }

    private static File shorten(File location) {
        Path currentWorkingDirectory = Paths.get("", new String[0]).toAbsolutePath();
        Path target = location.toPath().toAbsolutePath();
        return currentWorkingDirectory.relativize(target).toFile();
    }
}

