/*
 * Decompiled with CFR 0.152.
 */
package pl.gdela.socomo.bytecode;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.AndFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.NameFileFilter;
import org.apache.commons.io.filefilter.NotFileFilter;
import org.apache.commons.io.filefilter.SuffixFileFilter;
import org.apache.commons.io.filefilter.WildcardFileFilter;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.time.StopWatch;
import org.objectweb.asm.ClassReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.gdela.socomo.bytecode.ClassVisitor;
import pl.gdela.socomo.bytecode.DependencyCollector;
import pl.gdela.socomo.bytecode.DependencyCollectorAdapter;

public class BytecodeAnalyzer {
    private static final Logger log = LoggerFactory.getLogger(BytecodeAnalyzer.class);
    private final DependencyCollectorAdapter collector;

    public BytecodeAnalyzer(DependencyCollector collector) {
        this.collector = new DependencyCollectorAdapter(collector);
    }

    public void analyze(File bytecodeFile) {
        log.trace("analyzing {}", (Object)bytecodeFile);
        try (FileInputStream input = new FileInputStream(bytecodeFile);){
            new ClassReader((InputStream)input).accept((org.objectweb.asm.ClassVisitor)new ClassVisitor(this.collector), 0);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("cannot read file " + bytecodeFile, e);
        }
    }

    public void analyze(Collection<File> bytecodeFiles) {
        log.info("analyzing {} bytecode files", (Object)bytecodeFiles.size());
        StopWatch stopWatch = StopWatch.createStarted();
        for (File file : bytecodeFiles) {
            this.analyze(file);
        }
        log.info("analysis took {} ms", (Object)stopWatch.getTime(TimeUnit.MILLISECONDS));
    }

    public void analyzeDir(File dir) {
        log.info("analyzing {}", (Object)dir);
        Validate.isTrue((boolean)dir.exists(), (String)"directory %s does not exists", (Object[])new Object[]{dir});
        Validate.isTrue((boolean)dir.isDirectory(), (String)"%s is a file not a directory", (Object[])new Object[]{dir});
        this.analyze(BytecodeAnalyzer.bytecodeFiles(dir));
    }

    private static Collection<File> bytecodeFiles(File dir) {
        AndFileFilter fileFilter = new AndFileFilter((IOFileFilter)new SuffixFileFilter(".class"), (IOFileFilter)new NotFileFilter((IOFileFilter)new NameFileFilter("package-info.class")));
        NotFileFilter dirFilter = new NotFileFilter((IOFileFilter)new WildcardFileFilter("*-INF"));
        return FileUtils.listFiles((File)dir, (IOFileFilter)fileFilter, (IOFileFilter)dirFilter);
    }
}

