/*
 * Decompiled with CFR 0.152.
 */
package pl.gdela.socomo.bytecode;

import org.objectweb.asm.Type;
import pl.gdela.socomo.bytecode.DependencyCollector;
import pl.gdela.socomo.codemap.DepType;

class DependencyCollectorAdapter {
    private final DependencyCollector adaptee;

    DependencyCollectorAdapter(DependencyCollector adaptee) {
        this.adaptee = adaptee;
    }

    void enterClass(Type sourceClass) {
        this.adaptee.enterClass(sourceClass.getClassName());
    }

    void enterMember(String sourceMemberName) {
        this.adaptee.enterMember(sourceMemberName);
    }

    void markDependency(DepType type, Type targetClass, String targetMemberName) {
        if (DependencyCollectorAdapter.isArray(targetClass) && targetMemberName != null) {
            return;
        }
        Type flatTargetClass = DependencyCollectorAdapter.flatten(targetClass);
        if (DependencyCollectorAdapter.isPrimitive(flatTargetClass)) {
            return;
        }
        this.adaptee.markDependency(type, flatTargetClass.getClassName(), targetMemberName);
    }

    void markDependency(DepType type, Type targetClass) {
        this.markDependency(type, targetClass, null);
    }

    void exitMember(int size) {
        this.adaptee.exitMember(size);
    }

    void exitClass() {
        this.adaptee.exitClass();
    }

    private static boolean isPrimitive(Type type) {
        switch (type.getSort()) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return true;
            }
        }
        return false;
    }

    private static boolean isArray(Type type) {
        return type.getSort() == 9;
    }

    private static Type flatten(Type type) {
        if (DependencyCollectorAdapter.isArray(type)) {
            return DependencyCollectorAdapter.flatten(type.getElementType());
        }
        return type;
    }
}

