/*
 * Decompiled with CFR 0.152.
 */
package pl.gdela.socomo.bytecode;

import org.objectweb.asm.Attribute;
import org.objectweb.asm.Handle;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;
import org.objectweb.asm.TypePath;
import org.objectweb.asm.signature.SignatureReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.gdela.socomo.bytecode.AnnotationVisitor;
import pl.gdela.socomo.bytecode.DependencyCollectorAdapter;
import pl.gdela.socomo.bytecode.SignatureVisitor;
import pl.gdela.socomo.codemap.DepType;

class MethodVisitor
extends org.objectweb.asm.MethodVisitor {
    private static final Logger log = LoggerFactory.getLogger(MethodVisitor.class);
    private final DependencyCollectorAdapter collector;
    private int instructionCount = 1;

    MethodVisitor(DependencyCollectorAdapter collector) {
        super(327680);
        this.collector = collector;
    }

    public void visitEnd() {
        this.collector.exitMember(this.instructionCount);
    }

    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        log.trace("annotated with {}", (Object)desc);
        this.collector.markDependency(DepType.ANNOTATED, Type.getType((String)desc));
        return new AnnotationVisitor(this.collector);
    }

    public AnnotationVisitor visitTypeAnnotation(int typeRef, TypePath typePath, String desc, boolean visible) {
        log.trace("annotated type {} with {}", (Object)typePath, (Object)desc);
        this.collector.markDependency(DepType.ANNOTATED, Type.getType((String)desc));
        return new AnnotationVisitor(this.collector);
    }

    public AnnotationVisitor visitParameterAnnotation(int parameter, String desc, boolean visible) {
        log.trace("annotated parameter {} with {}", (Object)parameter, (Object)desc);
        this.collector.markDependency(DepType.ANNOTATED, Type.getType((String)desc));
        return new AnnotationVisitor(this.collector);
    }

    public AnnotationVisitor visitAnnotationDefault() {
        log.trace("annotated default");
        return new AnnotationVisitor(this.collector);
    }

    public void visitParameter(String name, int access) {
    }

    public void visitCode() {
    }

    public void visitMaxs(int maxStack, int maxLocals) {
    }

    public void visitLineNumber(int line, Label start) {
    }

    public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
        ++this.instructionCount;
        if (name.equals("this") || name.startsWith("this$")) {
            return;
        }
        if (signature == null) {
            this.collector.markDependency(DepType.REFERENCES, Type.getType((String)desc));
        } else {
            new SignatureReader(signature).acceptType((org.objectweb.asm.signature.SignatureVisitor)new SignatureVisitor(this.collector, DepType.REFERENCES));
        }
    }

    public void visitTypeInsn(int opcode, String type) {
        ++this.instructionCount;
        DepType dep = DepType.REFERENCES;
        if (opcode == 187) {
            dep = DepType.CREATES;
        }
        if (opcode == 189) {
            dep = DepType.CREATES_ARRAY;
        }
        if (opcode == 192) {
            dep = DepType.CASTS_TO;
        }
        this.collector.markDependency(dep, Type.getObjectType((String)type));
    }

    public void visitMultiANewArrayInsn(String desc, int dims) {
        ++this.instructionCount;
        this.collector.markDependency(DepType.CREATES_ARRAY, Type.getType((String)desc));
    }

    public void visitFieldInsn(int opcode, String owner, String name, String desc) {
        ++this.instructionCount;
        if (name.equals("this") || name.startsWith("this$")) {
            return;
        }
        this.collector.markDependency(DepType.READS_WRITES, Type.getObjectType((String)owner), name);
    }

    public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
        ++this.instructionCount;
        this.collector.markDependency(DepType.CALLS, Type.getObjectType((String)owner), name + "()");
    }

    public void visitLdcInsn(Object cst) {
        ++this.instructionCount;
        if (!(cst instanceof Number) && !(cst instanceof String)) {
            if (cst instanceof Type) {
                this.collector.markDependency(DepType.REFERENCES, (Type)cst);
            } else if (cst instanceof Handle) {
                log.warn("ignoring dependencies in handle {}: not yet supported", cst);
            } else {
                throw new IllegalArgumentException("unsupported constant type " + cst.getClass() + " (" + cst + ")");
            }
        }
    }

    public void visitTryCatchBlock(Label start, Label end, Label handler, String type) {
        ++this.instructionCount;
        if (type != null) {
            this.collector.markDependency(DepType.CATCHES, Type.getObjectType((String)type));
        }
    }

    public void visitInsn(int opcode) {
        ++this.instructionCount;
    }

    public void visitIntInsn(int opcode, int operand) {
        ++this.instructionCount;
    }

    public void visitVarInsn(int opcode, int var) {
        ++this.instructionCount;
    }

    public void visitIincInsn(int var, int increment) {
        ++this.instructionCount;
    }

    public void visitLabel(Label label) {
    }

    public void visitJumpInsn(int opcode, Label label) {
        ++this.instructionCount;
    }

    public void visitFrame(int type, int nLocal, Object[] local, int nStack, Object[] stack) {
        ++this.instructionCount;
    }

    public void visitTableSwitchInsn(int min, int max, Label dflt, Label[] labels) {
        ++this.instructionCount;
    }

    public void visitLookupSwitchInsn(Label dflt, int[] keys, Label[] labels) {
        ++this.instructionCount;
    }

    public void visitInvokeDynamicInsn(String name, String desc, Handle bsm, Object ... bsmArgs) {
        ++this.instructionCount;
        log.trace("ignoring dependencies in invoke dynamic {}, {}, {}, {}: not yet supported", new Object[]{name, desc, bsm, bsmArgs});
    }

    public AnnotationVisitor visitLocalVariableAnnotation(int typeRef, TypePath typePath, Label[] start, Label[] end, int[] index, String desc, boolean visible) {
        ++this.instructionCount;
        log.warn("ignoring dependencies in local variable annotation {}, {}: not yet supported", (Object)typePath, (Object)desc);
        return null;
    }

    public AnnotationVisitor visitInsnAnnotation(int typeRef, TypePath typePath, String desc, boolean visible) {
        ++this.instructionCount;
        log.warn("ignoring dependencies in instruction annotation {}, {}: not yet supported", (Object)typePath, (Object)desc);
        return null;
    }

    public AnnotationVisitor visitTryCatchAnnotation(int typeRef, TypePath typePath, String desc, boolean visible) {
        ++this.instructionCount;
        log.warn("ignoring dependencies in try catch annotation {}, {}: not yet supported", (Object)typePath, (Object)desc);
        return null;
    }

    public void visitAttribute(Attribute attribute) {
        log.warn("ignoring non-standard attribute {} of class {}", (Object)attribute.type, attribute.getClass());
    }
}

