/*
 * Decompiled with CFR 0.152.
 */
package pl.gdela.socomo.codemap;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.builder.CompareToBuilder;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import pl.gdela.socomo.codemap.CodeMember;

public class CodePackage
implements Comparable<CodePackage> {
    public final String fqn;
    private final Map<String, CodeMember> members = new TreeMap<String, CodeMember>();

    CodePackage(String fqn) {
        this.fqn = fqn;
    }

    public Collection<CodeMember> members() {
        return this.members.values();
    }

    CodeMember member(String className, String classMemberName) {
        Validate.notNull((Object)className, (String)"class name cannot be null", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)className), (String)"class name cannot be blank", (Object[])new Object[0]);
        Validate.isTrue((classMemberName == null || StringUtils.isNotBlank((CharSequence)classMemberName) ? 1 : 0) != 0, (String)"class member name cannot be blank (but can be null)", (Object[])new Object[0]);
        String key = classMemberName != null ? className + "." + classMemberName : className;
        CodeMember member = this.members.get(key);
        if (member == null) {
            member = new CodeMember(this, className, classMemberName);
            this.members.put(key, member);
        }
        return member;
    }

    CodeMember member(String className) {
        return this.member(className, null);
    }

    public int size() {
        HashSet<String> classes = new HashSet<String>();
        for (CodeMember member : this.members.values()) {
            classes.add(member.className);
        }
        int numberOfClasses = classes.size();
        int sizeOfMembers = 0;
        for (CodeMember member : this.members.values()) {
            sizeOfMembers += member.size;
        }
        return 500 * numberOfClasses + sizeOfMembers;
    }

    public String toString() {
        return this.fqn;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CodePackage that = (CodePackage)o;
        return new EqualsBuilder().append((Object)this.fqn, (Object)that.fqn).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.fqn).toHashCode();
    }

    @Override
    public int compareTo(CodePackage that) {
        return new CompareToBuilder().append((Object)this.fqn, (Object)that.fqn).toComparison();
    }
}

