/*
 * Decompiled with CFR 0.152.
 */
package pl.gdela.socomo.codemap;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang3.Validate;
import pl.gdela.socomo.codemap.CodeMember;
import pl.gdela.socomo.codemap.CodePackage;
import pl.gdela.socomo.codemap.DepKey;
import pl.gdela.socomo.codemap.MemberDep;
import pl.gdela.socomo.codemap.Origin;
import pl.gdela.socomo.codemap.PackageDep;

public class Codemap {
    private final Map<String, CodePackage> packages = new TreeMap<String, CodePackage>();
    private final Map<DepKey, PackageDep> packageDeps = new TreeMap<DepKey, PackageDep>();

    public Collection<CodePackage> packages() {
        return this.packages.values();
    }

    public Collection<PackageDep> packageDeps() {
        return this.packageDeps.values();
    }

    CodePackage packet(String fqn) {
        Validate.notNull((Object)fqn, (String)"fqn cannot be null", (Object[])new Object[0]);
        CodePackage packet = this.packages.get(fqn);
        if (packet == null) {
            packet = new CodePackage(fqn);
            this.packages.put(fqn, packet);
        }
        return packet;
    }

    PackageDep packageDep(CodePackage from, CodePackage to) {
        Validate.notNull((Object)from, (String)"from cannot be null", (Object[])new Object[0]);
        Validate.notNull((Object)to, (String)"to cannot be null", (Object[])new Object[0]);
        DepKey key = DepKey.depKey(from, to);
        PackageDep packageDep = this.packageDeps.get(key);
        if (packageDep == null) {
            packageDep = new PackageDep(from, to);
            this.packageDeps.put(key, packageDep);
        }
        return packageDep;
    }

    public Codemap select(Origin origin) {
        Codemap selected = new Codemap();
        for (CodePackage packet : this.packages()) {
            for (CodeMember member : packet.members()) {
                if (member.origin != origin) continue;
                selected.packet((String)packet.fqn).member((String)member.className, (String)member.memberName).size = member.size;
            }
        }
        for (PackageDep packageDep : this.packageDeps()) {
            for (MemberDep memberDep : packageDep.memberDeps()) {
                if (memberDep.from.origin != origin || memberDep.to.origin != origin) continue;
                selected.packageDep(packageDep.from, packageDep.to).memberDep(memberDep.from, memberDep.to);
            }
        }
        return selected;
    }

    public String formatted() {
        StringBuilder out = new StringBuilder();
        HashSet<CodePackage> shown = new HashSet<CodePackage>();
        for (PackageDep packageDep : this.packageDeps()) {
            out.append(packageDep.from);
            out.append(" => ");
            out.append(packageDep.to);
            out.append("\n");
            shown.add(packageDep.from);
            shown.add(packageDep.to);
            for (MemberDep memberDep : packageDep.memberDeps()) {
                out.append("  ");
                out.append(memberDep.from.relativeName());
                out.append(" -> ");
                out.append(memberDep.to.relativeName());
                out.append("\n");
            }
        }
        for (CodePackage packet : this.packages()) {
            if (shown.contains(packet)) continue;
            out.append(packet);
            out.append("\n");
        }
        return out.toString();
    }
}

