/*
 * Decompiled with CFR 0.152.
 */
package pl.gdela.socomo.codemap;

import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.builder.CompareToBuilder;
import pl.gdela.socomo.codemap.CodeMember;
import pl.gdela.socomo.codemap.CodePackage;
import pl.gdela.socomo.codemap.DepKey;
import pl.gdela.socomo.codemap.MemberDep;

public class PackageDep
implements Comparable<PackageDep> {
    public final CodePackage from;
    public final CodePackage to;
    private final Map<DepKey, MemberDep> memberDeps = new TreeMap<DepKey, MemberDep>();

    PackageDep(CodePackage from, CodePackage to) {
        this.from = from;
        this.to = to;
    }

    public Collection<MemberDep> memberDeps() {
        return this.memberDeps.values();
    }

    MemberDep memberDep(CodeMember from, CodeMember to) {
        Validate.notNull((Object)from, (String)"from cannot be null", (Object[])new Object[0]);
        Validate.notNull((Object)to, (String)"to cannot be null", (Object[])new Object[0]);
        Validate.isTrue((boolean)from.packet.equals(this.from), (String)"'from' member %s must belong to the 'from' package %s", (Object[])new Object[]{from, this.from});
        Validate.isTrue((boolean)to.packet.equals(this.to), (String)"'to' member %s must belong to the 'to' package %s", (Object[])new Object[]{to, this.to});
        DepKey key = DepKey.depKey(from, to);
        MemberDep memberDep = this.memberDeps.get(key);
        if (memberDep == null) {
            memberDep = new MemberDep(from, to);
            this.memberDeps.put(key, memberDep);
        }
        return memberDep;
    }

    public int strength() {
        return this.memberDeps.size();
    }

    public String toString() {
        return this.from + " -> " + this.to;
    }

    @Override
    public int compareTo(PackageDep that) {
        return new CompareToBuilder().append((Object)this.from, (Object)that.from).append((Object)this.to, (Object)that.to).toComparison();
    }
}

