/*
 * Decompiled with CFR 0.152.
 */
package pl.gdela.socomo.composition;

import java.util.Collection;
import java.util.HashSet;
import java.util.TreeSet;
import pl.gdela.socomo.composition.Component;
import pl.gdela.socomo.composition.ComponentDep;

public class Level {
    public final String name;
    public Collection<Component> components = new TreeSet<Component>();
    public Collection<ComponentDep> dependencies = new TreeSet<ComponentDep>();

    Level(String name) {
        this.name = name;
    }

    Component component(String name) {
        for (Component component : this.components) {
            if (!component.name.equals(name)) continue;
            return component;
        }
        Component component = new Component(name);
        this.components.add(component);
        return component;
    }

    ComponentDep dependency(Component from, Component to) {
        for (ComponentDep dependency : this.dependencies) {
            if (!dependency.from.equals(from) || !dependency.to.equals(to)) continue;
            return dependency;
        }
        ComponentDep dependency = new ComponentDep(from, to);
        this.dependencies.add(dependency);
        return dependency;
    }

    public int maxComponentSize() {
        int maxSize = 0;
        for (Component component : this.components) {
            maxSize = Math.max(maxSize, component.size);
        }
        return maxSize;
    }

    public int maxDependencyStrength() {
        int maxStrength = 0;
        for (ComponentDep dependency : this.dependencies) {
            maxStrength = Math.max(maxStrength, dependency.strength);
        }
        return maxStrength;
    }

    public String formatted() {
        StringBuilder out = new StringBuilder();
        HashSet<Component> shown = new HashSet<Component>();
        for (ComponentDep dependency : this.dependencies) {
            out.append(dependency.from);
            out.append(" => ");
            out.append(dependency.to);
            out.append("\n");
            shown.add(dependency.from);
            shown.add(dependency.to);
        }
        for (Component component : this.components) {
            if (shown.contains(component)) continue;
            out.append(component);
            out.append("\n");
        }
        return out.toString();
    }
}

