/*
 * Decompiled with CFR 0.152.
 */
package pl.gdela.socomo.composition;

import java.util.HashMap;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.gdela.socomo.codemap.CodePackage;
import pl.gdela.socomo.codemap.Codemap;

public final class LevelGuesser {
    private static final Logger log = LoggerFactory.getLogger(LevelGuesser.class);
    private static final double THRESHOLD = 0.9;

    private LevelGuesser() {
    }

    public static String guessLevel(Codemap codemap) {
        String levelName = LevelGuesser.guessLevel(codemap, "");
        log.info("guessed level {}", (Object)levelName);
        return levelName;
    }

    static String guessLevel(Codemap codemap, String prefix) {
        log.debug("guessing level under prefix '{}'", (Object)prefix);
        int totalSize = 0;
        HashMap<String, Integer> components = new HashMap<String, Integer>();
        for (CodePackage packet : codemap.packages()) {
            if (!packet.fqn.startsWith(prefix)) continue;
            String suffix = StringUtils.substringAfter((String)packet.fqn, (String)prefix);
            String componentName = StringUtils.substringBefore((String)suffix, (String)".");
            int componentSize = (Integer)ObjectUtils.defaultIfNull(components.get(componentName), (Object)0);
            totalSize += packet.size();
            components.put(componentName, componentSize += packet.size());
        }
        for (String componentName : components.keySet()) {
            int componentSize = (Integer)components.get(componentName);
            float componentShare = (float)componentSize / (float)totalSize;
            log.trace("component '{}' share is {}", (Object)componentName, (Object)Float.valueOf(componentShare));
            if (!((double)componentShare > 0.9)) continue;
            String newPrefix = prefix + componentName + ".";
            return LevelGuesser.guessLevel(codemap, newPrefix);
        }
        String levelName = StringUtils.removeEnd((String)prefix, (String)".");
        if (components.isEmpty()) {
            log.debug("taking step back, code is not divided into components here");
            return StringUtils.substringBeforeLast((String)levelName, (String)".");
        }
        log.debug("level '{}' is balanced, none of its components has more than {} share", (Object)levelName, (Object)0.9);
        return levelName;
    }
}

