/*
 * Decompiled with CFR 0.152.
 */
package pl.gdela.socomo.bytecode;

import org.apache.commons.lang3.ObjectUtils;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.Type;
import org.objectweb.asm.TypePath;
import org.objectweb.asm.signature.SignatureReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.gdela.socomo.bytecode.AnnotationVisitor;
import pl.gdela.socomo.bytecode.DependencyCollectorAdapter;
import pl.gdela.socomo.bytecode.FieldVisitor;
import pl.gdela.socomo.bytecode.MethodVisitor;
import pl.gdela.socomo.bytecode.SignatureVisitor;
import pl.gdela.socomo.codemap.DepType;

class ClassVisitor
extends org.objectweb.asm.ClassVisitor {
    private static final Logger log = LoggerFactory.getLogger(ClassVisitor.class);
    private final DependencyCollectorAdapter collector;

    ClassVisitor(DependencyCollectorAdapter collector) {
        super(327680);
        this.collector = collector;
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        log.trace("in class {}", (Object)name);
        this.collector.enterClass(Type.getObjectType((String)name));
        if (signature == null) {
            this.collector.markDependency(DepType.EXTENDS, Type.getObjectType((String)superName));
            for (String interfaceName : (String[])ObjectUtils.defaultIfNull((Object)interfaces, (Object)new String[0])) {
                this.collector.markDependency(DepType.IMPLEMENTS, Type.getObjectType((String)interfaceName));
            }
        } else {
            new SignatureReader(signature).accept((org.objectweb.asm.signature.SignatureVisitor)new SignatureVisitor(this.collector));
        }
    }

    public void visitEnd() {
        this.collector.exitClass();
    }

    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        log.trace("annotated with {}", (Object)desc);
        this.collector.markDependency(DepType.ANNOTATED, Type.getType((String)desc));
        return new AnnotationVisitor(this.collector);
    }

    public AnnotationVisitor visitTypeAnnotation(int typeRef, TypePath typePath, String desc, boolean visible) {
        log.trace("annotated type {} with {}", (Object)typePath, (Object)desc);
        this.collector.markDependency(DepType.ANNOTATED, Type.getType((String)desc));
        return new AnnotationVisitor(this.collector);
    }

    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        log.trace("in field {}", (Object)name);
        this.collector.enterMember(name);
        if (signature == null) {
            this.collector.markDependency(DepType.IS_OF_TYPE, Type.getType((String)desc));
        } else {
            new SignatureReader(signature).acceptType((org.objectweb.asm.signature.SignatureVisitor)new SignatureVisitor(this.collector, DepType.IS_OF_TYPE));
        }
        return new FieldVisitor(this.collector);
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        log.trace("in method {}", (Object)name);
        this.collector.enterMember(name + "()");
        if (signature == null) {
            Type methodType = Type.getMethodType((String)desc);
            this.collector.markDependency(DepType.RETURNS, methodType.getReturnType());
            Type[] typeArray = methodType.getArgumentTypes();
            int n = typeArray.length;
            for (int i = 0; i < n; ++i) {
                Type argumentType = typeArray[i];
                this.collector.markDependency(DepType.HAS_PARAM, argumentType);
            }
        } else {
            new SignatureReader(signature).accept((org.objectweb.asm.signature.SignatureVisitor)new SignatureVisitor(this.collector));
        }
        for (String exception : (String[])ObjectUtils.defaultIfNull((Object)exceptions, (Object)new String[0])) {
            this.collector.markDependency(DepType.THROWS, Type.getObjectType((String)exception));
        }
        return new MethodVisitor(this.collector);
    }

    public void visitOuterClass(String owner, String name, String desc) {
        String encloser = owner + (name != null ? "." + name + "()" : "");
        log.trace("is enclosed within {}", (Object)encloser);
    }

    public void visitInnerClass(String name, String outerName, String innerName, int access) {
    }

    public void visitAttribute(Attribute attribute) {
        log.warn("ignoring non-standard attribute {} of class {}", (Object)attribute.type, attribute.getClass());
    }

    public void visitSource(String source, String debug) {
    }
}

