/*
 * Decompiled with CFR 0.152.
 */
package pl.gdela.socomo.bytecode;

import org.objectweb.asm.Attribute;
import org.objectweb.asm.Type;
import org.objectweb.asm.TypePath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.gdela.socomo.bytecode.AnnotationVisitor;
import pl.gdela.socomo.bytecode.DependencyCollectorAdapter;
import pl.gdela.socomo.codemap.DepType;

class FieldVisitor
extends org.objectweb.asm.FieldVisitor {
    private static final Logger log = LoggerFactory.getLogger(FieldVisitor.class);
    private final DependencyCollectorAdapter collector;

    FieldVisitor(DependencyCollectorAdapter collector) {
        super(327680);
        this.collector = collector;
    }

    public void visitEnd() {
        this.collector.exitMember(1);
    }

    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        log.trace("annotated with {}", (Object)desc);
        this.collector.markDependency(DepType.ANNOTATED, Type.getType((String)desc));
        return new AnnotationVisitor(this.collector);
    }

    public AnnotationVisitor visitTypeAnnotation(int typeRef, TypePath typePath, String desc, boolean visible) {
        log.trace("annotated type {} with {}", (Object)typePath, (Object)desc);
        this.collector.markDependency(DepType.ANNOTATED, Type.getType((String)desc));
        return new AnnotationVisitor(this.collector);
    }

    public void visitAttribute(Attribute attribute) {
        log.warn("ignoring non-standard attribute {} of class {}", (Object)attribute.type, attribute.getClass());
    }
}

