/*
 * Decompiled with CFR 0.152.
 */
package pl.gdela.socomo.codemap;

import org.apache.commons.lang3.StringUtils;
import pl.gdela.socomo.bytecode.DependencyCollector;
import pl.gdela.socomo.codemap.CodeMember;
import pl.gdela.socomo.codemap.CodePackage;
import pl.gdela.socomo.codemap.Codemap;
import pl.gdela.socomo.codemap.DepType;
import pl.gdela.socomo.codemap.Origin;
import pl.gdela.socomo.codemap.PackageDep;

public class CodemappingCollector
implements DependencyCollector {
    private final Codemap codemap = new Codemap();
    private CodePackage currentPackage;
    private String currentClassName;
    private CodeMember currentMember;

    @Override
    public void enterClass(String classFqn) {
        String packageFqn = StringUtils.substringBeforeLast((String)classFqn, (String)".");
        this.currentClassName = StringUtils.substringAfterLast((String)classFqn, (String)".");
        this.currentPackage = this.codemap.packet(packageFqn);
        this.currentMember = this.currentPackage.member(this.currentClassName);
        this.currentMember.markOrigin(Origin.MAIN);
    }

    @Override
    public void enterMember(String classMemberName) {
        this.currentMember = this.currentPackage.member(this.currentClassName, classMemberName);
        this.currentMember.markOrigin(Origin.MAIN);
    }

    @Override
    public void markDependency(DepType type, String classFqn, String classMemberName) {
        String packageFqn = StringUtils.substringBeforeLast((String)classFqn, (String)".");
        String className = StringUtils.substringAfterLast((String)classFqn, (String)".");
        CodePackage packet = this.codemap.packet(packageFqn);
        CodeMember member = packet.member(className, classMemberName);
        PackageDep packageDep = this.codemap.packageDep(this.currentPackage, packet);
        packageDep.memberDep(this.currentMember, member);
    }

    @Override
    public void exitMember(int size) {
        this.currentMember.size = size;
        this.currentMember = null;
    }

    @Override
    public void exitClass() {
        this.currentPackage = null;
        this.currentClassName = null;
    }

    public Codemap getCodemap() {
        return this.codemap;
    }
}

