/*
 * Decompiled with CFR 0.152.
 */
package pl.gdela.socomo.visualizer;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import pl.gdela.socomo.composition.Component;
import pl.gdela.socomo.composition.ComponentDep;
import pl.gdela.socomo.composition.Level;
import pl.gdela.socomo.composition.Module;
import pl.gdela.socomo.visualizer.Asset;

class VisualizerHtml {
    private final Module module;
    private final List<Level> levels = new ArrayList<Level>();
    private final List<Asset> assets = new ArrayList<Asset>();
    private StringBuilder out;
    private String indent = "";

    VisualizerHtml(Module module) {
        this.module = module;
    }

    void addLevel(Level level) {
        this.levels.add(level);
    }

    void addAsset(Asset asset) {
        this.assets.add(asset);
    }

    String render() {
        this.out = new StringBuilder();
        this.printHtml();
        return this.out.toString();
    }

    private void printHtml() {
        this.out("<!-- File autogenerated by SoCoMo (https://github.com/gdela/socomo): do not edit by hand, but do commit to repository -->", new Object[0]);
        this.out("<!doctype html>", new Object[0]);
        this.out("<!--suppress ALL-->", new Object[0]);
        this.out("<html lang='en'>", new Object[0]);
        this.printHead();
        this.printBody();
        this.out("</html>", new Object[0]);
    }

    private void printHead() {
        this.out("<head>", new Object[0]);
        this.indent(4);
        this.out("<title>SoCoMo: %s</title>", VisualizerHtml.escapeHtml(this.module.name));
        block4: for (Asset asset : this.assets) {
            switch (asset.type) {
                case STYLE: {
                    this.out("<link href='%s' rel='stylesheet'>", asset.url);
                    continue block4;
                }
                case SCRIPT: {
                    this.out("<script src='%s'></script>", asset.url);
                    continue block4;
                }
            }
            throw new IllegalArgumentException("unsupported asset type " + (Object)((Object)asset.type));
        }
        this.indent(-4);
        this.out("</head>", new Object[0]);
    }

    private void printBody() {
        this.out("<body>", new Object[0]);
        this.out("<script>", new Object[0]);
        this.out("socomo(%s, { // module", VisualizerHtml.ecmaString(this.module.name));
        for (Level level : this.levels) {
            this.out("", new Object[0]);
            this.printLevel(level);
        }
        this.out("", new Object[0]);
        this.out("});", new Object[0]);
        this.out("</script>", new Object[0]);
        this.out("</body>", new Object[0]);
    }

    private void printLevel(Level level) {
        this.out("[%s]: // level", VisualizerHtml.ecmaString(level.name));
        this.out("{", new Object[0]);
        this.indent(2);
        this.printComponents(level);
        this.printDependencies(level);
        this.indent(-2);
        this.out("},", new Object[0]);
    }

    private void printComponents(Level level) {
        float maxSize = level.maxComponentSize();
        this.out("components: {", new Object[0]);
        this.indent(2);
        for (Component component : level.components) {
            this.out("%-36s :{ size: %.1f },", VisualizerHtml.ecmaString(component.name), Float.valueOf((float)component.size / maxSize));
        }
        this.indent(-2);
        this.out("},", new Object[0]);
    }

    private void printDependencies(Level level) {
        float maxStrength = level.maxDependencyStrength();
        this.out("dependencies: {", new Object[0]);
        this.indent(2);
        for (ComponentDep dep : level.dependencies) {
            String depName = dep.from.name + " -> " + dep.to.name;
            this.out("%-36s :{ strength: %.1f },", VisualizerHtml.ecmaString(depName), Float.valueOf((float)dep.strength / maxStrength));
        }
        this.indent(-2);
        this.out("},", new Object[0]);
    }

    private void indent(int change) {
        int newSize = this.indent.length() + change;
        this.indent = StringUtils.repeat((char)' ', (int)newSize);
    }

    private void out(String line, Object ... args) {
        this.out.append(this.indent).append(String.format(Locale.ENGLISH, line, args)).append("\n");
    }

    private static String ecmaString(String contents) {
        return "'" + StringEscapeUtils.escapeEcmaScript((String)contents) + "'";
    }

    private static String escapeHtml(String contents) {
        return StringEscapeUtils.escapeHtml4((String)contents);
    }
}

