/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */

package pl.gsmservice.gateway;

import java.lang.String;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import pl.gsmservice.gateway.models.operations.SDKMethodInterfaces.*;
import pl.gsmservice.gateway.utils.HTTPClient;
import pl.gsmservice.gateway.utils.RetryConfig;
import pl.gsmservice.gateway.utils.SpeakeasyHTTPClient;
import pl.gsmservice.gateway.utils.Utils;

/**
 * Messaging Gateway GSMService.pl: 
 * # Introduction
 * 
 * This document was created to explain the process of integration any application or system with the **GSMService.pl** SMS Gateway via the *REST API*. Currently, there are several ways to send messages with the GSMService.pl platform:
 * 
 * * Directly from the [https://bramka.gsmservice.pl](https://bramka.gsmservice.pl) website [User Panel](https://panel.gsmservice.pl)
 * * Via this *REST API* and provided *SDKs*
 * * Via the legacy (deprecated) versions API: *Webservices (SOAP)* and *HTTP* 
 * * Via the *MAIL2SMS* service
 * 
 * This document describes the possibilities offered by **REST API**.
 * 
 * &gt; **We kindly ask you to read this documentation carefully before starting the integration. This will make the whole process easier and will help you avoid many problems.**
 * 
 * ## Documentation and Try Outs
 * 
 * This documentation is available in two formats: [**REDOC**](https://api.gsmservice.pl/rest/) and [**SWAGGER**](https://api.gsmservice.pl/rest/swagger). You can test any endpoint directly from documentation using **Try Out** feature of Swagger. Also you can [download a **YAML** file](https://api.gsmservice.pl/rest/swagger/messaging.yaml) with doc in OpenApi 3.0 format.
 * 
 * ## Account signup and setup
 * 
 * Firstly, it is necessary to create your personal account at the GSMService.pl SMS Gateway platform if you haven't one and activate access to the API. To register a new account please [signup the form](https://panel.gsmservice.pl/rejestracja). After signing up and fully activation of an account you have to activate an access to the API.
 * 
 * To do it please use [this site](https://panel.gsmservice.pl/api) - fill the *New API Access* form with your preferred API login, set your API password, select which API standard you want to activate for this account (select **REST API** there). Optionally you can add IP adresses (or IP pool with CIDR notation) from which access to your API account will be possible. You can also set a callback address there to collect any messages status updates automatically. When a status of a messaga changes, the callback address will be called with passing parameters with new message status.
 * 
 * After setup an API access you will get an unique **API Access Token** - please write it down as there won't be possible to display it again (you will have the possibility to regenerate it only). This token will be required to authenticate all the requests made with API on your account.
 * 
 * ## Authentication of API requests
 * 
 * All the endpoints of this REST API have to be authenticated using your API Access Token with one exception: * /rest/ping* endpoint which doesn't need an authentication. 
 * 
 * To make an authenticated request you should add to all requests an ***Authorization* header** which you have generated in previous step:
 * 
 * ```
 * Authorization: Bearer &amp;lt;YOUR_API_ACCESS_TOKEN&amp;gt;
 * ```
 * 
 * ## URLs to connect to API
 * 
 * Please use this SSL secured adresses to connect to REST API:
 * 
 * * ```https://api.gsmservice.pl/rest``` - for production system
 * 
 * * ```https://api.gsmservice.pl/rest-sandbox``` - for test system (Sandbox)
 * 
 * &gt; [!NOTE]
 * &gt; **When calling our API, make sure you are using TLS version 1.2 or higher. Older versions are no longer supported.**
 * 
 * # SDK Client Libraries
 * 
 * For developers integrating SMS functionality into their app, we provide a convenient SDK Libraries.
 * 
 * Our SDKs allow you to quickly start interacting with the Gateway using your favorite programming language. Currently we support the following languages:
 * 
 * ## PHP 8
 * 
 * To install PHP SDK issue the following command:
 * 
 * ```shell
 * composer require gsmservice-pl/messaging-sdk-php
 * ```
 * More information and documentation you can find at our [GitHub](https://github.com/gsmservice-pl/messaging-sdk-php) 
 * 
 * ## Typescript
 * 
 * To install Typescript SDK issue the following command:
 * 
 * ### NPM
 * 
 * ```shell
 * npm add @gsmservice-pl/messaging-sdk-typescript
 * ```
 * 
 * More information and documentation you can find at our [GitHub](https://github.com/gsmservice-pl/messaging-sdk-typescript) 
 * 
 * 
 */
public class Client {

  
    /**
     * AvailableServers contains identifiers for the servers available to the SDK.
     */
    public enum AvailableServers {
        /**
         * PROD - Production system
         */
      PROD("prod"),
        /**
         * SANDBOX - Test system (SANDBOX)
         */
      SANDBOX("sandbox");

        private final String server;

        private AvailableServers(String server) {
            this.server = server;
        }

        public String server() {
           return server;
        }
    }

    /**
     * SERVERS contains the list of server urls available to the SDK.
     */
    public static final Map<AvailableServers, String> SERVERS = new HashMap<>() { {
    put(AvailableServers.PROD, "https://api.gsmservice.pl/rest");
    put(AvailableServers.SANDBOX, "https://api.gsmservice.pl/rest-sandbox");
    }};

    private final Accounts accounts;

    private final Outgoing outgoing;

    private final Incoming incoming;

    /**
     * This section describes other usefull operations and tools
     */
    private final Common common;

    private final Senders senders;

    public Accounts accounts() {
        return accounts;
    }

    public Outgoing outgoing() {
        return outgoing;
    }

    public Incoming incoming() {
        return incoming;
    }

    /**
     * This section describes other usefull operations and tools
     */
    public Common common() {
        return common;
    }

    public Senders senders() {
        return senders;
    }

    private final SDKConfiguration sdkConfiguration;

    /**
     * The Builder class allows the configuration of a new instance of the SDK.
     */
    public static class Builder {

        private final SDKConfiguration sdkConfiguration = new SDKConfiguration();

        private Builder() {
        }

        /**
         * Allows the default HTTP client to be overridden with a custom implementation.
         *
         * @param client The HTTP client to use for all requests.
         * @return The builder instance.
         */
        public Builder client(HTTPClient client) {
            this.sdkConfiguration.defaultClient = client;
            return this;
        }
        /**
         * Configures the SDK security to use the provided secret.
         *
         * @param bearer The secret to use for all requests.
         * @return The builder instance.
         */
        public Builder bearer(String bearer) {
            this.sdkConfiguration.securitySource = SecuritySource.of(pl.gsmservice.gateway.models.components.Security.builder()
              .bearer(bearer)
              .build());
            return this;
        }

        /**
         * Configures the SDK to use a custom security source.
         * @param securitySource The security source to use for all requests.
         * @return The builder instance.
         */
        public Builder securitySource(SecuritySource securitySource) {
            this.sdkConfiguration.securitySource = securitySource;
            return this;
        }
        
        /**
         * Overrides the default server URL.
         *
         * @param serverUrl The server URL to use for all requests.
         * @return The builder instance.
         */
        public Builder serverURL(String serverUrl) {
            this.sdkConfiguration.serverUrl = serverUrl;
            return this;
        }

        /**
         * Overrides the default server URL  with a templated URL populated with the provided parameters.
         *
         * @param serverUrl The server URL to use for all requests.
         * @param params The parameters to use when templating the URL.
         * @return The builder instance.
         */
        public Builder serverURL(String serverUrl, Map<String, String> params) {
            this.sdkConfiguration.serverUrl = Utils.templateUrl(serverUrl, params);
            return this;
        }
        
        /**
         * Overrides the default server by name.
         *
         * @param server The server to use for all requests.
         * @return The builder instance.
         */
        public Builder server(AvailableServers server) {
            this.sdkConfiguration.server = server.toString();
            this.sdkConfiguration.serverUrl = SERVERS.get(server);
            return this;
        }
        
        /**
         * Overrides the default configuration for retries
         *
         * @param retryConfig The retry configuration to use for all requests.
         * @return The builder instance.
         */
        public Builder retryConfig(RetryConfig retryConfig) {
            this.sdkConfiguration.retryConfig = Optional.of(retryConfig);
            return this;
        }
        // Visible for testing, will be accessed via reflection
        void _hooks(pl.gsmservice.gateway.utils.Hooks hooks) {
            sdkConfiguration.setHooks(hooks);    
        }
        
        /**
         * Builds a new instance of the SDK.
         * @return The SDK instance.
         */
        public Client build() {
            if (sdkConfiguration.defaultClient == null) {
                sdkConfiguration.defaultClient = new SpeakeasyHTTPClient();
            }
	        if (sdkConfiguration.securitySource == null) {
	    	    sdkConfiguration.securitySource = SecuritySource.of(null);
	        }
            if (sdkConfiguration.serverUrl == null || sdkConfiguration.serverUrl.isBlank()) {
                sdkConfiguration.serverUrl = SERVERS.get(AvailableServers.PROD);
                sdkConfiguration.server = AvailableServers.PROD.toString();
            }
            if (sdkConfiguration.serverUrl.endsWith("/")) {
                sdkConfiguration.serverUrl = sdkConfiguration.serverUrl.substring(0, sdkConfiguration.serverUrl.length() - 1);
            }
            return new Client(sdkConfiguration);
        }
    }
    
    /**
     * Get a new instance of the SDK builder to configure a new instance of the SDK.
     * @return The SDK builder instance.
     */
    public static Builder builder() {
        return new Builder();
    }

    private Client(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
        this.accounts = new Accounts(sdkConfiguration);
        this.outgoing = new Outgoing(sdkConfiguration);
        this.incoming = new Incoming(sdkConfiguration);
        this.common = new Common(sdkConfiguration);
        this.senders = new Senders(sdkConfiguration);
        this.sdkConfiguration.initialize();
    }}
