/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */

package pl.gsmservice.gateway.models.components;


import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.Boolean;
import java.lang.Float;
import java.lang.Long;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.time.OffsetDateTime;
import java.util.Objects;
import java.util.Optional;
import org.openapitools.jackson.nullable.JsonNullable;
import pl.gsmservice.gateway.utils.Utils;

/**
 * Message - An object defining the properties of a single message
 */

public class Message {

    /**
     * Unique message identifier
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("id")
    private JsonNullable<Long> id;

    /**
     * Custom message ID assigned by the User
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("cid")
    private JsonNullable<String> cid;

    /**
     * Message type according to the table:
     *     
     * |type|Description|
     * |----|-----------|
     * |  1 | SMS PRO   |
     * |  3 | SMS ECO   |
     * |  4 | SMS 2WAY  |
     * | 10 | MMS       |
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("type")
    private Optional<? extends MessageType> type;

    /**
     * A telephone number in international format (with a plus sign and the country code at the beginning, e.g. +48 for Poland)
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("recipient")
    private Optional<String> recipient;

    /**
     * Message sender name
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("sender")
    private JsonNullable<String> sender;

    /**
     * The count of parts that message consists of
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("parts")
    private JsonNullable<Long> parts;

    /**
     * Sending date and time (in ISO 8601 format)
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("sent_date")
    private JsonNullable<OffsetDateTime> sentDate;

    /**
     * Date and time of last status change (in ISO 8601 format)
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("status_date")
    private JsonNullable<OffsetDateTime> statusDate;

    /**
     * Message status code
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("status_code")
    private Optional<String> statusCode;

    /**
     * Human redable description of message status
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("status_description")
    private Optional<String> statusDescription;

    /**
     * Did the message contain special characters, e.g. Polish diacritics?
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("unicode")
    private Optional<Boolean> unicode;

    /**
     * Was the message sent with class 0 (FLASH)?
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("flash")
    private Optional<Boolean> flash;

    /**
     * The price of message (in PLN)
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("price")
    private Optional<Float> price;

    @JsonCreator
    public Message(
            @JsonProperty("id") JsonNullable<Long> id,
            @JsonProperty("cid") JsonNullable<String> cid,
            @JsonProperty("type") Optional<? extends MessageType> type,
            @JsonProperty("recipient") Optional<String> recipient,
            @JsonProperty("sender") JsonNullable<String> sender,
            @JsonProperty("parts") JsonNullable<Long> parts,
            @JsonProperty("sent_date") JsonNullable<OffsetDateTime> sentDate,
            @JsonProperty("status_date") JsonNullable<OffsetDateTime> statusDate,
            @JsonProperty("status_code") Optional<String> statusCode,
            @JsonProperty("status_description") Optional<String> statusDescription,
            @JsonProperty("unicode") Optional<Boolean> unicode,
            @JsonProperty("flash") Optional<Boolean> flash,
            @JsonProperty("price") Optional<Float> price) {
        Utils.checkNotNull(id, "id");
        Utils.checkNotNull(cid, "cid");
        Utils.checkNotNull(type, "type");
        Utils.checkNotNull(recipient, "recipient");
        Utils.checkNotNull(sender, "sender");
        Utils.checkNotNull(parts, "parts");
        Utils.checkNotNull(sentDate, "sentDate");
        Utils.checkNotNull(statusDate, "statusDate");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(statusDescription, "statusDescription");
        Utils.checkNotNull(unicode, "unicode");
        Utils.checkNotNull(flash, "flash");
        Utils.checkNotNull(price, "price");
        this.id = id;
        this.cid = cid;
        this.type = type;
        this.recipient = recipient;
        this.sender = sender;
        this.parts = parts;
        this.sentDate = sentDate;
        this.statusDate = statusDate;
        this.statusCode = statusCode;
        this.statusDescription = statusDescription;
        this.unicode = unicode;
        this.flash = flash;
        this.price = price;
    }
    
    public Message() {
        this(JsonNullable.undefined(), JsonNullable.undefined(), Optional.empty(), Optional.empty(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
    }

    /**
     * Unique message identifier
     */
    @JsonIgnore
    public JsonNullable<Long> id() {
        return id;
    }

    /**
     * Custom message ID assigned by the User
     */
    @JsonIgnore
    public JsonNullable<String> cid() {
        return cid;
    }

    /**
     * Message type according to the table:
     *     
     * |type|Description|
     * |----|-----------|
     * |  1 | SMS PRO   |
     * |  3 | SMS ECO   |
     * |  4 | SMS 2WAY  |
     * | 10 | MMS       |
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public Optional<MessageType> type() {
        return (Optional<MessageType>) type;
    }

    /**
     * A telephone number in international format (with a plus sign and the country code at the beginning, e.g. +48 for Poland)
     */
    @JsonIgnore
    public Optional<String> recipient() {
        return recipient;
    }

    /**
     * Message sender name
     */
    @JsonIgnore
    public JsonNullable<String> sender() {
        return sender;
    }

    /**
     * The count of parts that message consists of
     */
    @JsonIgnore
    public JsonNullable<Long> parts() {
        return parts;
    }

    /**
     * Sending date and time (in ISO 8601 format)
     */
    @JsonIgnore
    public JsonNullable<OffsetDateTime> sentDate() {
        return sentDate;
    }

    /**
     * Date and time of last status change (in ISO 8601 format)
     */
    @JsonIgnore
    public JsonNullable<OffsetDateTime> statusDate() {
        return statusDate;
    }

    /**
     * Message status code
     */
    @JsonIgnore
    public Optional<String> statusCode() {
        return statusCode;
    }

    /**
     * Human redable description of message status
     */
    @JsonIgnore
    public Optional<String> statusDescription() {
        return statusDescription;
    }

    /**
     * Did the message contain special characters, e.g. Polish diacritics?
     */
    @JsonIgnore
    public Optional<Boolean> unicode() {
        return unicode;
    }

    /**
     * Was the message sent with class 0 (FLASH)?
     */
    @JsonIgnore
    public Optional<Boolean> flash() {
        return flash;
    }

    /**
     * The price of message (in PLN)
     */
    @JsonIgnore
    public Optional<Float> price() {
        return price;
    }

    public final static Builder builder() {
        return new Builder();
    }

    /**
     * Unique message identifier
     */
    public Message withId(long id) {
        Utils.checkNotNull(id, "id");
        this.id = JsonNullable.of(id);
        return this;
    }

    /**
     * Unique message identifier
     */
    public Message withId(JsonNullable<Long> id) {
        Utils.checkNotNull(id, "id");
        this.id = id;
        return this;
    }

    /**
     * Custom message ID assigned by the User
     */
    public Message withCid(String cid) {
        Utils.checkNotNull(cid, "cid");
        this.cid = JsonNullable.of(cid);
        return this;
    }

    /**
     * Custom message ID assigned by the User
     */
    public Message withCid(JsonNullable<String> cid) {
        Utils.checkNotNull(cid, "cid");
        this.cid = cid;
        return this;
    }

    /**
     * Message type according to the table:
     *     
     * |type|Description|
     * |----|-----------|
     * |  1 | SMS PRO   |
     * |  3 | SMS ECO   |
     * |  4 | SMS 2WAY  |
     * | 10 | MMS       |
     */
    public Message withType(MessageType type) {
        Utils.checkNotNull(type, "type");
        this.type = Optional.ofNullable(type);
        return this;
    }

    /**
     * Message type according to the table:
     *     
     * |type|Description|
     * |----|-----------|
     * |  1 | SMS PRO   |
     * |  3 | SMS ECO   |
     * |  4 | SMS 2WAY  |
     * | 10 | MMS       |
     */
    public Message withType(Optional<? extends MessageType> type) {
        Utils.checkNotNull(type, "type");
        this.type = type;
        return this;
    }

    /**
     * A telephone number in international format (with a plus sign and the country code at the beginning, e.g. +48 for Poland)
     */
    public Message withRecipient(String recipient) {
        Utils.checkNotNull(recipient, "recipient");
        this.recipient = Optional.ofNullable(recipient);
        return this;
    }

    /**
     * A telephone number in international format (with a plus sign and the country code at the beginning, e.g. +48 for Poland)
     */
    public Message withRecipient(Optional<String> recipient) {
        Utils.checkNotNull(recipient, "recipient");
        this.recipient = recipient;
        return this;
    }

    /**
     * Message sender name
     */
    public Message withSender(String sender) {
        Utils.checkNotNull(sender, "sender");
        this.sender = JsonNullable.of(sender);
        return this;
    }

    /**
     * Message sender name
     */
    public Message withSender(JsonNullable<String> sender) {
        Utils.checkNotNull(sender, "sender");
        this.sender = sender;
        return this;
    }

    /**
     * The count of parts that message consists of
     */
    public Message withParts(long parts) {
        Utils.checkNotNull(parts, "parts");
        this.parts = JsonNullable.of(parts);
        return this;
    }

    /**
     * The count of parts that message consists of
     */
    public Message withParts(JsonNullable<Long> parts) {
        Utils.checkNotNull(parts, "parts");
        this.parts = parts;
        return this;
    }

    /**
     * Sending date and time (in ISO 8601 format)
     */
    public Message withSentDate(OffsetDateTime sentDate) {
        Utils.checkNotNull(sentDate, "sentDate");
        this.sentDate = JsonNullable.of(sentDate);
        return this;
    }

    /**
     * Sending date and time (in ISO 8601 format)
     */
    public Message withSentDate(JsonNullable<OffsetDateTime> sentDate) {
        Utils.checkNotNull(sentDate, "sentDate");
        this.sentDate = sentDate;
        return this;
    }

    /**
     * Date and time of last status change (in ISO 8601 format)
     */
    public Message withStatusDate(OffsetDateTime statusDate) {
        Utils.checkNotNull(statusDate, "statusDate");
        this.statusDate = JsonNullable.of(statusDate);
        return this;
    }

    /**
     * Date and time of last status change (in ISO 8601 format)
     */
    public Message withStatusDate(JsonNullable<OffsetDateTime> statusDate) {
        Utils.checkNotNull(statusDate, "statusDate");
        this.statusDate = statusDate;
        return this;
    }

    /**
     * Message status code
     */
    public Message withStatusCode(String statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = Optional.ofNullable(statusCode);
        return this;
    }

    /**
     * Message status code
     */
    public Message withStatusCode(Optional<String> statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    /**
     * Human redable description of message status
     */
    public Message withStatusDescription(String statusDescription) {
        Utils.checkNotNull(statusDescription, "statusDescription");
        this.statusDescription = Optional.ofNullable(statusDescription);
        return this;
    }

    /**
     * Human redable description of message status
     */
    public Message withStatusDescription(Optional<String> statusDescription) {
        Utils.checkNotNull(statusDescription, "statusDescription");
        this.statusDescription = statusDescription;
        return this;
    }

    /**
     * Did the message contain special characters, e.g. Polish diacritics?
     */
    public Message withUnicode(boolean unicode) {
        Utils.checkNotNull(unicode, "unicode");
        this.unicode = Optional.ofNullable(unicode);
        return this;
    }

    /**
     * Did the message contain special characters, e.g. Polish diacritics?
     */
    public Message withUnicode(Optional<Boolean> unicode) {
        Utils.checkNotNull(unicode, "unicode");
        this.unicode = unicode;
        return this;
    }

    /**
     * Was the message sent with class 0 (FLASH)?
     */
    public Message withFlash(boolean flash) {
        Utils.checkNotNull(flash, "flash");
        this.flash = Optional.ofNullable(flash);
        return this;
    }

    /**
     * Was the message sent with class 0 (FLASH)?
     */
    public Message withFlash(Optional<Boolean> flash) {
        Utils.checkNotNull(flash, "flash");
        this.flash = flash;
        return this;
    }

    /**
     * The price of message (in PLN)
     */
    public Message withPrice(float price) {
        Utils.checkNotNull(price, "price");
        this.price = Optional.ofNullable(price);
        return this;
    }

    /**
     * The price of message (in PLN)
     */
    public Message withPrice(Optional<Float> price) {
        Utils.checkNotNull(price, "price");
        this.price = price;
        return this;
    }
    
    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        Message other = (Message) o;
        return 
            Objects.deepEquals(this.id, other.id) &&
            Objects.deepEquals(this.cid, other.cid) &&
            Objects.deepEquals(this.type, other.type) &&
            Objects.deepEquals(this.recipient, other.recipient) &&
            Objects.deepEquals(this.sender, other.sender) &&
            Objects.deepEquals(this.parts, other.parts) &&
            Objects.deepEquals(this.sentDate, other.sentDate) &&
            Objects.deepEquals(this.statusDate, other.statusDate) &&
            Objects.deepEquals(this.statusCode, other.statusCode) &&
            Objects.deepEquals(this.statusDescription, other.statusDescription) &&
            Objects.deepEquals(this.unicode, other.unicode) &&
            Objects.deepEquals(this.flash, other.flash) &&
            Objects.deepEquals(this.price, other.price);
    }
    
    @Override
    public int hashCode() {
        return Objects.hash(
            id,
            cid,
            type,
            recipient,
            sender,
            parts,
            sentDate,
            statusDate,
            statusCode,
            statusDescription,
            unicode,
            flash,
            price);
    }
    
    @Override
    public String toString() {
        return Utils.toString(Message.class,
                "id", id,
                "cid", cid,
                "type", type,
                "recipient", recipient,
                "sender", sender,
                "parts", parts,
                "sentDate", sentDate,
                "statusDate", statusDate,
                "statusCode", statusCode,
                "statusDescription", statusDescription,
                "unicode", unicode,
                "flash", flash,
                "price", price);
    }
    
    public final static class Builder {
 
        private JsonNullable<Long> id = JsonNullable.undefined();
 
        private JsonNullable<String> cid = JsonNullable.undefined();
 
        private Optional<? extends MessageType> type = Optional.empty();
 
        private Optional<String> recipient = Optional.empty();
 
        private JsonNullable<String> sender = JsonNullable.undefined();
 
        private JsonNullable<Long> parts = JsonNullable.undefined();
 
        private JsonNullable<OffsetDateTime> sentDate = JsonNullable.undefined();
 
        private JsonNullable<OffsetDateTime> statusDate = JsonNullable.undefined();
 
        private Optional<String> statusCode = Optional.empty();
 
        private Optional<String> statusDescription = Optional.empty();
 
        private Optional<Boolean> unicode = Optional.empty();
 
        private Optional<Boolean> flash = Optional.empty();
 
        private Optional<Float> price = Optional.empty();  
        
        private Builder() {
          // force use of static builder() method
        }

        /**
         * Unique message identifier
         */
        public Builder id(long id) {
            Utils.checkNotNull(id, "id");
            this.id = JsonNullable.of(id);
            return this;
        }

        /**
         * Unique message identifier
         */
        public Builder id(JsonNullable<Long> id) {
            Utils.checkNotNull(id, "id");
            this.id = id;
            return this;
        }

        /**
         * Custom message ID assigned by the User
         */
        public Builder cid(String cid) {
            Utils.checkNotNull(cid, "cid");
            this.cid = JsonNullable.of(cid);
            return this;
        }

        /**
         * Custom message ID assigned by the User
         */
        public Builder cid(JsonNullable<String> cid) {
            Utils.checkNotNull(cid, "cid");
            this.cid = cid;
            return this;
        }

        /**
         * Message type according to the table:
         *     
         * |type|Description|
         * |----|-----------|
         * |  1 | SMS PRO   |
         * |  3 | SMS ECO   |
         * |  4 | SMS 2WAY  |
         * | 10 | MMS       |
         */
        public Builder type(MessageType type) {
            Utils.checkNotNull(type, "type");
            this.type = Optional.ofNullable(type);
            return this;
        }

        /**
         * Message type according to the table:
         *     
         * |type|Description|
         * |----|-----------|
         * |  1 | SMS PRO   |
         * |  3 | SMS ECO   |
         * |  4 | SMS 2WAY  |
         * | 10 | MMS       |
         */
        public Builder type(Optional<? extends MessageType> type) {
            Utils.checkNotNull(type, "type");
            this.type = type;
            return this;
        }

        /**
         * A telephone number in international format (with a plus sign and the country code at the beginning, e.g. +48 for Poland)
         */
        public Builder recipient(String recipient) {
            Utils.checkNotNull(recipient, "recipient");
            this.recipient = Optional.ofNullable(recipient);
            return this;
        }

        /**
         * A telephone number in international format (with a plus sign and the country code at the beginning, e.g. +48 for Poland)
         */
        public Builder recipient(Optional<String> recipient) {
            Utils.checkNotNull(recipient, "recipient");
            this.recipient = recipient;
            return this;
        }

        /**
         * Message sender name
         */
        public Builder sender(String sender) {
            Utils.checkNotNull(sender, "sender");
            this.sender = JsonNullable.of(sender);
            return this;
        }

        /**
         * Message sender name
         */
        public Builder sender(JsonNullable<String> sender) {
            Utils.checkNotNull(sender, "sender");
            this.sender = sender;
            return this;
        }

        /**
         * The count of parts that message consists of
         */
        public Builder parts(long parts) {
            Utils.checkNotNull(parts, "parts");
            this.parts = JsonNullable.of(parts);
            return this;
        }

        /**
         * The count of parts that message consists of
         */
        public Builder parts(JsonNullable<Long> parts) {
            Utils.checkNotNull(parts, "parts");
            this.parts = parts;
            return this;
        }

        /**
         * Sending date and time (in ISO 8601 format)
         */
        public Builder sentDate(OffsetDateTime sentDate) {
            Utils.checkNotNull(sentDate, "sentDate");
            this.sentDate = JsonNullable.of(sentDate);
            return this;
        }

        /**
         * Sending date and time (in ISO 8601 format)
         */
        public Builder sentDate(JsonNullable<OffsetDateTime> sentDate) {
            Utils.checkNotNull(sentDate, "sentDate");
            this.sentDate = sentDate;
            return this;
        }

        /**
         * Date and time of last status change (in ISO 8601 format)
         */
        public Builder statusDate(OffsetDateTime statusDate) {
            Utils.checkNotNull(statusDate, "statusDate");
            this.statusDate = JsonNullable.of(statusDate);
            return this;
        }

        /**
         * Date and time of last status change (in ISO 8601 format)
         */
        public Builder statusDate(JsonNullable<OffsetDateTime> statusDate) {
            Utils.checkNotNull(statusDate, "statusDate");
            this.statusDate = statusDate;
            return this;
        }

        /**
         * Message status code
         */
        public Builder statusCode(String statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = Optional.ofNullable(statusCode);
            return this;
        }

        /**
         * Message status code
         */
        public Builder statusCode(Optional<String> statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        /**
         * Human redable description of message status
         */
        public Builder statusDescription(String statusDescription) {
            Utils.checkNotNull(statusDescription, "statusDescription");
            this.statusDescription = Optional.ofNullable(statusDescription);
            return this;
        }

        /**
         * Human redable description of message status
         */
        public Builder statusDescription(Optional<String> statusDescription) {
            Utils.checkNotNull(statusDescription, "statusDescription");
            this.statusDescription = statusDescription;
            return this;
        }

        /**
         * Did the message contain special characters, e.g. Polish diacritics?
         */
        public Builder unicode(boolean unicode) {
            Utils.checkNotNull(unicode, "unicode");
            this.unicode = Optional.ofNullable(unicode);
            return this;
        }

        /**
         * Did the message contain special characters, e.g. Polish diacritics?
         */
        public Builder unicode(Optional<Boolean> unicode) {
            Utils.checkNotNull(unicode, "unicode");
            this.unicode = unicode;
            return this;
        }

        /**
         * Was the message sent with class 0 (FLASH)?
         */
        public Builder flash(boolean flash) {
            Utils.checkNotNull(flash, "flash");
            this.flash = Optional.ofNullable(flash);
            return this;
        }

        /**
         * Was the message sent with class 0 (FLASH)?
         */
        public Builder flash(Optional<Boolean> flash) {
            Utils.checkNotNull(flash, "flash");
            this.flash = flash;
            return this;
        }

        /**
         * The price of message (in PLN)
         */
        public Builder price(float price) {
            Utils.checkNotNull(price, "price");
            this.price = Optional.ofNullable(price);
            return this;
        }

        /**
         * The price of message (in PLN)
         */
        public Builder price(Optional<Float> price) {
            Utils.checkNotNull(price, "price");
            this.price = price;
            return this;
        }
        
        public Message build() {
            return new Message(
                id,
                cid,
                type,
                recipient,
                sender,
                parts,
                sentDate,
                statusDate,
                statusCode,
                statusDescription,
                unicode,
                flash,
                price);
        }
    }
}

