/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */

package pl.gsmservice.gateway.models.components;


import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.Boolean;
import java.lang.Float;
import java.lang.Long;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Objects;
import java.util.Optional;
import org.openapitools.jackson.nullable.JsonNullable;
import pl.gsmservice.gateway.utils.Utils;

/**
 * Price - An object with the properties and price of a single message
 */

public class Price {

    /**
     * Information about a possible error
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("error")
    private JsonNullable<String> error;

    /**
     * Custom message ID assigned by the User
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("cid")
    private JsonNullable<String> cid;

    /**
     * Message type according to the table:
     *     
     * |type|Description|
     * |----|-----------|
     * |  1 | SMS PRO   |
     * |  3 | SMS ECO   |
     * |  4 | SMS 2WAY  |
     * | 10 | MMS       |
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("type")
    private Optional<? extends MessageType> type;

    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("recipient")
    private JsonNullable<String> recipient;

    /**
     * Message sender name
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("sender")
    private JsonNullable<String> sender;

    /**
     * The count of parts that message consists of
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("parts")
    private JsonNullable<Long> parts;

    /**
     * Did the message contain special characters, e.g. Polish diacritics?
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("unicode")
    private Optional<Boolean> unicode;

    /**
     * Was the message sent with class 0 (FLASH)?
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("flash")
    private Optional<Boolean> flash;

    /**
     * The price of message (in PLN)
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("price")
    private Optional<Float> price;

    @JsonCreator
    public Price(
            @JsonProperty("error") JsonNullable<String> error,
            @JsonProperty("cid") JsonNullable<String> cid,
            @JsonProperty("type") Optional<? extends MessageType> type,
            @JsonProperty("recipient") JsonNullable<String> recipient,
            @JsonProperty("sender") JsonNullable<String> sender,
            @JsonProperty("parts") JsonNullable<Long> parts,
            @JsonProperty("unicode") Optional<Boolean> unicode,
            @JsonProperty("flash") Optional<Boolean> flash,
            @JsonProperty("price") Optional<Float> price) {
        Utils.checkNotNull(error, "error");
        Utils.checkNotNull(cid, "cid");
        Utils.checkNotNull(type, "type");
        Utils.checkNotNull(recipient, "recipient");
        Utils.checkNotNull(sender, "sender");
        Utils.checkNotNull(parts, "parts");
        Utils.checkNotNull(unicode, "unicode");
        Utils.checkNotNull(flash, "flash");
        Utils.checkNotNull(price, "price");
        this.error = error;
        this.cid = cid;
        this.type = type;
        this.recipient = recipient;
        this.sender = sender;
        this.parts = parts;
        this.unicode = unicode;
        this.flash = flash;
        this.price = price;
    }
    
    public Price() {
        this(JsonNullable.undefined(), JsonNullable.undefined(), Optional.empty(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), Optional.empty(), Optional.empty(), Optional.empty());
    }

    /**
     * Information about a possible error
     */
    @JsonIgnore
    public JsonNullable<String> error() {
        return error;
    }

    /**
     * Custom message ID assigned by the User
     */
    @JsonIgnore
    public JsonNullable<String> cid() {
        return cid;
    }

    /**
     * Message type according to the table:
     *     
     * |type|Description|
     * |----|-----------|
     * |  1 | SMS PRO   |
     * |  3 | SMS ECO   |
     * |  4 | SMS 2WAY  |
     * | 10 | MMS       |
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public Optional<MessageType> type() {
        return (Optional<MessageType>) type;
    }

    @JsonIgnore
    public JsonNullable<String> recipient() {
        return recipient;
    }

    /**
     * Message sender name
     */
    @JsonIgnore
    public JsonNullable<String> sender() {
        return sender;
    }

    /**
     * The count of parts that message consists of
     */
    @JsonIgnore
    public JsonNullable<Long> parts() {
        return parts;
    }

    /**
     * Did the message contain special characters, e.g. Polish diacritics?
     */
    @JsonIgnore
    public Optional<Boolean> unicode() {
        return unicode;
    }

    /**
     * Was the message sent with class 0 (FLASH)?
     */
    @JsonIgnore
    public Optional<Boolean> flash() {
        return flash;
    }

    /**
     * The price of message (in PLN)
     */
    @JsonIgnore
    public Optional<Float> price() {
        return price;
    }

    public final static Builder builder() {
        return new Builder();
    }

    /**
     * Information about a possible error
     */
    public Price withError(String error) {
        Utils.checkNotNull(error, "error");
        this.error = JsonNullable.of(error);
        return this;
    }

    /**
     * Information about a possible error
     */
    public Price withError(JsonNullable<String> error) {
        Utils.checkNotNull(error, "error");
        this.error = error;
        return this;
    }

    /**
     * Custom message ID assigned by the User
     */
    public Price withCid(String cid) {
        Utils.checkNotNull(cid, "cid");
        this.cid = JsonNullable.of(cid);
        return this;
    }

    /**
     * Custom message ID assigned by the User
     */
    public Price withCid(JsonNullable<String> cid) {
        Utils.checkNotNull(cid, "cid");
        this.cid = cid;
        return this;
    }

    /**
     * Message type according to the table:
     *     
     * |type|Description|
     * |----|-----------|
     * |  1 | SMS PRO   |
     * |  3 | SMS ECO   |
     * |  4 | SMS 2WAY  |
     * | 10 | MMS       |
     */
    public Price withType(MessageType type) {
        Utils.checkNotNull(type, "type");
        this.type = Optional.ofNullable(type);
        return this;
    }

    /**
     * Message type according to the table:
     *     
     * |type|Description|
     * |----|-----------|
     * |  1 | SMS PRO   |
     * |  3 | SMS ECO   |
     * |  4 | SMS 2WAY  |
     * | 10 | MMS       |
     */
    public Price withType(Optional<? extends MessageType> type) {
        Utils.checkNotNull(type, "type");
        this.type = type;
        return this;
    }

    public Price withRecipient(String recipient) {
        Utils.checkNotNull(recipient, "recipient");
        this.recipient = JsonNullable.of(recipient);
        return this;
    }

    public Price withRecipient(JsonNullable<String> recipient) {
        Utils.checkNotNull(recipient, "recipient");
        this.recipient = recipient;
        return this;
    }

    /**
     * Message sender name
     */
    public Price withSender(String sender) {
        Utils.checkNotNull(sender, "sender");
        this.sender = JsonNullable.of(sender);
        return this;
    }

    /**
     * Message sender name
     */
    public Price withSender(JsonNullable<String> sender) {
        Utils.checkNotNull(sender, "sender");
        this.sender = sender;
        return this;
    }

    /**
     * The count of parts that message consists of
     */
    public Price withParts(long parts) {
        Utils.checkNotNull(parts, "parts");
        this.parts = JsonNullable.of(parts);
        return this;
    }

    /**
     * The count of parts that message consists of
     */
    public Price withParts(JsonNullable<Long> parts) {
        Utils.checkNotNull(parts, "parts");
        this.parts = parts;
        return this;
    }

    /**
     * Did the message contain special characters, e.g. Polish diacritics?
     */
    public Price withUnicode(boolean unicode) {
        Utils.checkNotNull(unicode, "unicode");
        this.unicode = Optional.ofNullable(unicode);
        return this;
    }

    /**
     * Did the message contain special characters, e.g. Polish diacritics?
     */
    public Price withUnicode(Optional<Boolean> unicode) {
        Utils.checkNotNull(unicode, "unicode");
        this.unicode = unicode;
        return this;
    }

    /**
     * Was the message sent with class 0 (FLASH)?
     */
    public Price withFlash(boolean flash) {
        Utils.checkNotNull(flash, "flash");
        this.flash = Optional.ofNullable(flash);
        return this;
    }

    /**
     * Was the message sent with class 0 (FLASH)?
     */
    public Price withFlash(Optional<Boolean> flash) {
        Utils.checkNotNull(flash, "flash");
        this.flash = flash;
        return this;
    }

    /**
     * The price of message (in PLN)
     */
    public Price withPrice(float price) {
        Utils.checkNotNull(price, "price");
        this.price = Optional.ofNullable(price);
        return this;
    }

    /**
     * The price of message (in PLN)
     */
    public Price withPrice(Optional<Float> price) {
        Utils.checkNotNull(price, "price");
        this.price = price;
        return this;
    }
    
    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        Price other = (Price) o;
        return 
            Objects.deepEquals(this.error, other.error) &&
            Objects.deepEquals(this.cid, other.cid) &&
            Objects.deepEquals(this.type, other.type) &&
            Objects.deepEquals(this.recipient, other.recipient) &&
            Objects.deepEquals(this.sender, other.sender) &&
            Objects.deepEquals(this.parts, other.parts) &&
            Objects.deepEquals(this.unicode, other.unicode) &&
            Objects.deepEquals(this.flash, other.flash) &&
            Objects.deepEquals(this.price, other.price);
    }
    
    @Override
    public int hashCode() {
        return Objects.hash(
            error,
            cid,
            type,
            recipient,
            sender,
            parts,
            unicode,
            flash,
            price);
    }
    
    @Override
    public String toString() {
        return Utils.toString(Price.class,
                "error", error,
                "cid", cid,
                "type", type,
                "recipient", recipient,
                "sender", sender,
                "parts", parts,
                "unicode", unicode,
                "flash", flash,
                "price", price);
    }
    
    public final static class Builder {
 
        private JsonNullable<String> error = JsonNullable.undefined();
 
        private JsonNullable<String> cid = JsonNullable.undefined();
 
        private Optional<? extends MessageType> type = Optional.empty();
 
        private JsonNullable<String> recipient = JsonNullable.undefined();
 
        private JsonNullable<String> sender = JsonNullable.undefined();
 
        private JsonNullable<Long> parts = JsonNullable.undefined();
 
        private Optional<Boolean> unicode = Optional.empty();
 
        private Optional<Boolean> flash = Optional.empty();
 
        private Optional<Float> price = Optional.empty();  
        
        private Builder() {
          // force use of static builder() method
        }

        /**
         * Information about a possible error
         */
        public Builder error(String error) {
            Utils.checkNotNull(error, "error");
            this.error = JsonNullable.of(error);
            return this;
        }

        /**
         * Information about a possible error
         */
        public Builder error(JsonNullable<String> error) {
            Utils.checkNotNull(error, "error");
            this.error = error;
            return this;
        }

        /**
         * Custom message ID assigned by the User
         */
        public Builder cid(String cid) {
            Utils.checkNotNull(cid, "cid");
            this.cid = JsonNullable.of(cid);
            return this;
        }

        /**
         * Custom message ID assigned by the User
         */
        public Builder cid(JsonNullable<String> cid) {
            Utils.checkNotNull(cid, "cid");
            this.cid = cid;
            return this;
        }

        /**
         * Message type according to the table:
         *     
         * |type|Description|
         * |----|-----------|
         * |  1 | SMS PRO   |
         * |  3 | SMS ECO   |
         * |  4 | SMS 2WAY  |
         * | 10 | MMS       |
         */
        public Builder type(MessageType type) {
            Utils.checkNotNull(type, "type");
            this.type = Optional.ofNullable(type);
            return this;
        }

        /**
         * Message type according to the table:
         *     
         * |type|Description|
         * |----|-----------|
         * |  1 | SMS PRO   |
         * |  3 | SMS ECO   |
         * |  4 | SMS 2WAY  |
         * | 10 | MMS       |
         */
        public Builder type(Optional<? extends MessageType> type) {
            Utils.checkNotNull(type, "type");
            this.type = type;
            return this;
        }

        public Builder recipient(String recipient) {
            Utils.checkNotNull(recipient, "recipient");
            this.recipient = JsonNullable.of(recipient);
            return this;
        }

        public Builder recipient(JsonNullable<String> recipient) {
            Utils.checkNotNull(recipient, "recipient");
            this.recipient = recipient;
            return this;
        }

        /**
         * Message sender name
         */
        public Builder sender(String sender) {
            Utils.checkNotNull(sender, "sender");
            this.sender = JsonNullable.of(sender);
            return this;
        }

        /**
         * Message sender name
         */
        public Builder sender(JsonNullable<String> sender) {
            Utils.checkNotNull(sender, "sender");
            this.sender = sender;
            return this;
        }

        /**
         * The count of parts that message consists of
         */
        public Builder parts(long parts) {
            Utils.checkNotNull(parts, "parts");
            this.parts = JsonNullable.of(parts);
            return this;
        }

        /**
         * The count of parts that message consists of
         */
        public Builder parts(JsonNullable<Long> parts) {
            Utils.checkNotNull(parts, "parts");
            this.parts = parts;
            return this;
        }

        /**
         * Did the message contain special characters, e.g. Polish diacritics?
         */
        public Builder unicode(boolean unicode) {
            Utils.checkNotNull(unicode, "unicode");
            this.unicode = Optional.ofNullable(unicode);
            return this;
        }

        /**
         * Did the message contain special characters, e.g. Polish diacritics?
         */
        public Builder unicode(Optional<Boolean> unicode) {
            Utils.checkNotNull(unicode, "unicode");
            this.unicode = unicode;
            return this;
        }

        /**
         * Was the message sent with class 0 (FLASH)?
         */
        public Builder flash(boolean flash) {
            Utils.checkNotNull(flash, "flash");
            this.flash = Optional.ofNullable(flash);
            return this;
        }

        /**
         * Was the message sent with class 0 (FLASH)?
         */
        public Builder flash(Optional<Boolean> flash) {
            Utils.checkNotNull(flash, "flash");
            this.flash = flash;
            return this;
        }

        /**
         * The price of message (in PLN)
         */
        public Builder price(float price) {
            Utils.checkNotNull(price, "price");
            this.price = Optional.ofNullable(price);
            return this;
        }

        /**
         * The price of message (in PLN)
         */
        public Builder price(Optional<Float> price) {
            Utils.checkNotNull(price, "price");
            this.price = price;
            return this;
        }
        
        public Price build() {
            return new Price(
                error,
                cid,
                type,
                recipient,
                sender,
                parts,
                unicode,
                flash,
                price);
        }
    }
}

