/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */

package pl.gsmservice.gateway.models.operations;


import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.InputStream;
import java.lang.Integer;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.net.http.HttpResponse;
import java.util.Objects;
import java.util.Optional;
import pl.gsmservice.gateway.models.components.AccountResponse;
import pl.gsmservice.gateway.utils.Response;
import pl.gsmservice.gateway.utils.Utils;


public class GetSubaccountDetailsResponse implements Response {

    /**
     * HTTP response content type for this operation
     */
    private String contentType;

    /**
     * HTTP response status code for this operation
     */
    private int statusCode;

    /**
     * Raw HTTP response; suitable for custom response parsing
     */
    private HttpResponse<InputStream> rawResponse;

    /**
     * The request was processed successfully
     */
    private Optional<? extends AccountResponse> accountResponse;

    @JsonCreator
    public GetSubaccountDetailsResponse(
            String contentType,
            int statusCode,
            HttpResponse<InputStream> rawResponse,
            Optional<? extends AccountResponse> accountResponse) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(accountResponse, "accountResponse");
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.accountResponse = accountResponse;
    }
    
    public GetSubaccountDetailsResponse(
            String contentType,
            int statusCode,
            HttpResponse<InputStream> rawResponse) {
        this(contentType, statusCode, rawResponse, Optional.empty());
    }

    /**
     * HTTP response content type for this operation
     */
    @JsonIgnore
    public String contentType() {
        return contentType;
    }

    /**
     * HTTP response status code for this operation
     */
    @JsonIgnore
    public int statusCode() {
        return statusCode;
    }

    /**
     * Raw HTTP response; suitable for custom response parsing
     */
    @JsonIgnore
    public HttpResponse<InputStream> rawResponse() {
        return rawResponse;
    }

    /**
     * The request was processed successfully
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public Optional<AccountResponse> accountResponse() {
        return (Optional<AccountResponse>) accountResponse;
    }

    public final static Builder builder() {
        return new Builder();
    }

    /**
     * HTTP response content type for this operation
     */
    public GetSubaccountDetailsResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    /**
     * HTTP response status code for this operation
     */
    public GetSubaccountDetailsResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    /**
     * Raw HTTP response; suitable for custom response parsing
     */
    public GetSubaccountDetailsResponse withRawResponse(HttpResponse<InputStream> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    /**
     * The request was processed successfully
     */
    public GetSubaccountDetailsResponse withAccountResponse(AccountResponse accountResponse) {
        Utils.checkNotNull(accountResponse, "accountResponse");
        this.accountResponse = Optional.ofNullable(accountResponse);
        return this;
    }

    /**
     * The request was processed successfully
     */
    public GetSubaccountDetailsResponse withAccountResponse(Optional<? extends AccountResponse> accountResponse) {
        Utils.checkNotNull(accountResponse, "accountResponse");
        this.accountResponse = accountResponse;
        return this;
    }
    
    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        GetSubaccountDetailsResponse other = (GetSubaccountDetailsResponse) o;
        return 
            Objects.deepEquals(this.contentType, other.contentType) &&
            Objects.deepEquals(this.statusCode, other.statusCode) &&
            Objects.deepEquals(this.rawResponse, other.rawResponse) &&
            Objects.deepEquals(this.accountResponse, other.accountResponse);
    }
    
    @Override
    public int hashCode() {
        return Objects.hash(
            contentType,
            statusCode,
            rawResponse,
            accountResponse);
    }
    
    @Override
    public String toString() {
        return Utils.toString(GetSubaccountDetailsResponse.class,
                "contentType", contentType,
                "statusCode", statusCode,
                "rawResponse", rawResponse,
                "accountResponse", accountResponse);
    }
    
    public final static class Builder {
 
        private String contentType;
 
        private Integer statusCode;
 
        private HttpResponse<InputStream> rawResponse;
 
        private Optional<? extends AccountResponse> accountResponse = Optional.empty();  
        
        private Builder() {
          // force use of static builder() method
        }

        /**
         * HTTP response content type for this operation
         */
        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }

        /**
         * HTTP response status code for this operation
         */
        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        /**
         * Raw HTTP response; suitable for custom response parsing
         */
        public Builder rawResponse(HttpResponse<InputStream> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }

        /**
         * The request was processed successfully
         */
        public Builder accountResponse(AccountResponse accountResponse) {
            Utils.checkNotNull(accountResponse, "accountResponse");
            this.accountResponse = Optional.ofNullable(accountResponse);
            return this;
        }

        /**
         * The request was processed successfully
         */
        public Builder accountResponse(Optional<? extends AccountResponse> accountResponse) {
            Utils.checkNotNull(accountResponse, "accountResponse");
            this.accountResponse = accountResponse;
            return this;
        }
        
        public GetSubaccountDetailsResponse build() {
            return new GetSubaccountDetailsResponse(
                contentType,
                statusCode,
                rawResponse,
                accountResponse);
        }
    }
}

