/*
 * Decompiled with CFR 0.152.
 */
package pl.gsmservice.gateway.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import java.util.Optional;
import org.openapitools.jackson.nullable.JsonNullable;
import pl.gsmservice.gateway.models.components.AccountType;
import pl.gsmservice.gateway.utils.Utils;

public class AccountResponse {
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="login")
    private Optional<String> login;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="account_type")
    private Optional<? extends AccountType> accountType;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="limit")
    private Optional<Float> limit;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="credit")
    private Optional<Float> credit;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="subcredit")
    private JsonNullable<Float> subcredit;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="currency")
    private Optional<String> currency;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="name")
    private Optional<String> name;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="is_main")
    private Optional<Boolean> isMain;

    @JsonCreator
    public AccountResponse(@JsonProperty(value="login") Optional<String> login, @JsonProperty(value="account_type") Optional<? extends AccountType> accountType, @JsonProperty(value="limit") Optional<Float> limit, @JsonProperty(value="credit") Optional<Float> credit, @JsonProperty(value="subcredit") JsonNullable<Float> subcredit, @JsonProperty(value="currency") Optional<String> currency, @JsonProperty(value="name") Optional<String> name, @JsonProperty(value="is_main") Optional<Boolean> isMain) {
        Utils.checkNotNull(login, "login");
        Utils.checkNotNull(accountType, "accountType");
        Utils.checkNotNull(limit, "limit");
        Utils.checkNotNull(credit, "credit");
        Utils.checkNotNull(subcredit, "subcredit");
        Utils.checkNotNull(currency, "currency");
        Utils.checkNotNull(name, "name");
        Utils.checkNotNull(isMain, "isMain");
        this.login = login;
        this.accountType = accountType;
        this.limit = limit;
        this.credit = credit;
        this.subcredit = subcredit;
        this.currency = currency;
        this.name = name;
        this.isMain = isMain;
    }

    public AccountResponse() {
        this(Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), (JsonNullable<Float>)JsonNullable.undefined(), Optional.empty(), Optional.empty(), Optional.empty());
    }

    @JsonIgnore
    public Optional<String> login() {
        return this.login;
    }

    @JsonIgnore
    public Optional<AccountType> accountType() {
        return this.accountType;
    }

    @JsonIgnore
    public Optional<Float> limit() {
        return this.limit;
    }

    @JsonIgnore
    public Optional<Float> credit() {
        return this.credit;
    }

    @JsonIgnore
    public JsonNullable<Float> subcredit() {
        return this.subcredit;
    }

    @JsonIgnore
    public Optional<String> currency() {
        return this.currency;
    }

    @JsonIgnore
    public Optional<String> name() {
        return this.name;
    }

    @JsonIgnore
    public Optional<Boolean> isMain() {
        return this.isMain;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public AccountResponse withLogin(String login) {
        Utils.checkNotNull(login, "login");
        this.login = Optional.ofNullable(login);
        return this;
    }

    public AccountResponse withLogin(Optional<String> login) {
        Utils.checkNotNull(login, "login");
        this.login = login;
        return this;
    }

    public AccountResponse withAccountType(AccountType accountType) {
        Utils.checkNotNull(accountType, "accountType");
        this.accountType = Optional.ofNullable(accountType);
        return this;
    }

    public AccountResponse withAccountType(Optional<? extends AccountType> accountType) {
        Utils.checkNotNull(accountType, "accountType");
        this.accountType = accountType;
        return this;
    }

    public AccountResponse withLimit(float limit) {
        Utils.checkNotNull(Float.valueOf(limit), "limit");
        this.limit = Optional.ofNullable(Float.valueOf(limit));
        return this;
    }

    public AccountResponse withLimit(Optional<Float> limit) {
        Utils.checkNotNull(limit, "limit");
        this.limit = limit;
        return this;
    }

    public AccountResponse withCredit(float credit) {
        Utils.checkNotNull(Float.valueOf(credit), "credit");
        this.credit = Optional.ofNullable(Float.valueOf(credit));
        return this;
    }

    public AccountResponse withCredit(Optional<Float> credit) {
        Utils.checkNotNull(credit, "credit");
        this.credit = credit;
        return this;
    }

    public AccountResponse withSubcredit(float subcredit) {
        Utils.checkNotNull(Float.valueOf(subcredit), "subcredit");
        this.subcredit = JsonNullable.of((Object)Float.valueOf(subcredit));
        return this;
    }

    public AccountResponse withSubcredit(JsonNullable<Float> subcredit) {
        Utils.checkNotNull(subcredit, "subcredit");
        this.subcredit = subcredit;
        return this;
    }

    public AccountResponse withCurrency(String currency) {
        Utils.checkNotNull(currency, "currency");
        this.currency = Optional.ofNullable(currency);
        return this;
    }

    public AccountResponse withCurrency(Optional<String> currency) {
        Utils.checkNotNull(currency, "currency");
        this.currency = currency;
        return this;
    }

    public AccountResponse withName(String name) {
        Utils.checkNotNull(name, "name");
        this.name = Optional.ofNullable(name);
        return this;
    }

    public AccountResponse withName(Optional<String> name) {
        Utils.checkNotNull(name, "name");
        this.name = name;
        return this;
    }

    public AccountResponse withIsMain(boolean isMain) {
        Utils.checkNotNull(isMain, "isMain");
        this.isMain = Optional.ofNullable(isMain);
        return this;
    }

    public AccountResponse withIsMain(Optional<Boolean> isMain) {
        Utils.checkNotNull(isMain, "isMain");
        this.isMain = isMain;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AccountResponse other = (AccountResponse)o;
        return Objects.deepEquals(this.login, other.login) && Objects.deepEquals(this.accountType, other.accountType) && Objects.deepEquals(this.limit, other.limit) && Objects.deepEquals(this.credit, other.credit) && Objects.deepEquals(this.subcredit, other.subcredit) && Objects.deepEquals(this.currency, other.currency) && Objects.deepEquals(this.name, other.name) && Objects.deepEquals(this.isMain, other.isMain);
    }

    public int hashCode() {
        return Objects.hash(this.login, this.accountType, this.limit, this.credit, this.subcredit, this.currency, this.name, this.isMain);
    }

    public String toString() {
        return Utils.toString(AccountResponse.class, "login", this.login, "accountType", this.accountType, "limit", this.limit, "credit", this.credit, "subcredit", this.subcredit, "currency", this.currency, "name", this.name, "isMain", this.isMain);
    }

    public static final class Builder {
        private Optional<String> login = Optional.empty();
        private Optional<? extends AccountType> accountType = Optional.empty();
        private Optional<Float> limit = Optional.empty();
        private Optional<Float> credit = Optional.empty();
        private JsonNullable<Float> subcredit = JsonNullable.undefined();
        private Optional<String> currency = Optional.empty();
        private Optional<String> name = Optional.empty();
        private Optional<Boolean> isMain = Optional.empty();

        private Builder() {
        }

        public Builder login(String login) {
            Utils.checkNotNull(login, "login");
            this.login = Optional.ofNullable(login);
            return this;
        }

        public Builder login(Optional<String> login) {
            Utils.checkNotNull(login, "login");
            this.login = login;
            return this;
        }

        public Builder accountType(AccountType accountType) {
            Utils.checkNotNull(accountType, "accountType");
            this.accountType = Optional.ofNullable(accountType);
            return this;
        }

        public Builder accountType(Optional<? extends AccountType> accountType) {
            Utils.checkNotNull(accountType, "accountType");
            this.accountType = accountType;
            return this;
        }

        public Builder limit(float limit) {
            Utils.checkNotNull(Float.valueOf(limit), "limit");
            this.limit = Optional.ofNullable(Float.valueOf(limit));
            return this;
        }

        public Builder limit(Optional<Float> limit) {
            Utils.checkNotNull(limit, "limit");
            this.limit = limit;
            return this;
        }

        public Builder credit(float credit) {
            Utils.checkNotNull(Float.valueOf(credit), "credit");
            this.credit = Optional.ofNullable(Float.valueOf(credit));
            return this;
        }

        public Builder credit(Optional<Float> credit) {
            Utils.checkNotNull(credit, "credit");
            this.credit = credit;
            return this;
        }

        public Builder subcredit(float subcredit) {
            Utils.checkNotNull(Float.valueOf(subcredit), "subcredit");
            this.subcredit = JsonNullable.of((Object)Float.valueOf(subcredit));
            return this;
        }

        public Builder subcredit(JsonNullable<Float> subcredit) {
            Utils.checkNotNull(subcredit, "subcredit");
            this.subcredit = subcredit;
            return this;
        }

        public Builder currency(String currency) {
            Utils.checkNotNull(currency, "currency");
            this.currency = Optional.ofNullable(currency);
            return this;
        }

        public Builder currency(Optional<String> currency) {
            Utils.checkNotNull(currency, "currency");
            this.currency = currency;
            return this;
        }

        public Builder name(String name) {
            Utils.checkNotNull(name, "name");
            this.name = Optional.ofNullable(name);
            return this;
        }

        public Builder name(Optional<String> name) {
            Utils.checkNotNull(name, "name");
            this.name = name;
            return this;
        }

        public Builder isMain(boolean isMain) {
            Utils.checkNotNull(isMain, "isMain");
            this.isMain = Optional.ofNullable(isMain);
            return this;
        }

        public Builder isMain(Optional<Boolean> isMain) {
            Utils.checkNotNull(isMain, "isMain");
            this.isMain = isMain;
            return this;
        }

        public AccountResponse build() {
            return new AccountResponse(this.login, this.accountType, this.limit, this.credit, this.subcredit, this.currency, this.name, this.isMain);
        }
    }
}

