/*
 * Decompiled with CFR 0.152.
 */
package pl.gsmservice.gateway.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import java.util.Optional;
import pl.gsmservice.gateway.utils.Utils;

public class ErrorResponse {
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="type")
    private Optional<String> type;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="status")
    private Optional<Long> status;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="title")
    private Optional<String> title;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="detail")
    private Optional<String> detail;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="code")
    private Optional<String> code;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="instance")
    private Optional<String> instance;

    @JsonCreator
    public ErrorResponse(@JsonProperty(value="type") Optional<String> type, @JsonProperty(value="status") Optional<Long> status, @JsonProperty(value="title") Optional<String> title, @JsonProperty(value="detail") Optional<String> detail, @JsonProperty(value="code") Optional<String> code, @JsonProperty(value="instance") Optional<String> instance) {
        Utils.checkNotNull(type, "type");
        Utils.checkNotNull(status, "status");
        Utils.checkNotNull(title, "title");
        Utils.checkNotNull(detail, "detail");
        Utils.checkNotNull(code, "code");
        Utils.checkNotNull(instance, "instance");
        this.type = type;
        this.status = status;
        this.title = title;
        this.detail = detail;
        this.code = code;
        this.instance = instance;
    }

    public ErrorResponse() {
        this(Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
    }

    @JsonIgnore
    public Optional<String> type() {
        return this.type;
    }

    @JsonIgnore
    public Optional<Long> status() {
        return this.status;
    }

    @JsonIgnore
    public Optional<String> title() {
        return this.title;
    }

    @JsonIgnore
    public Optional<String> detail() {
        return this.detail;
    }

    @JsonIgnore
    public Optional<String> code() {
        return this.code;
    }

    @JsonIgnore
    public Optional<String> instance() {
        return this.instance;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public ErrorResponse withType(String type) {
        Utils.checkNotNull(type, "type");
        this.type = Optional.ofNullable(type);
        return this;
    }

    public ErrorResponse withType(Optional<String> type) {
        Utils.checkNotNull(type, "type");
        this.type = type;
        return this;
    }

    public ErrorResponse withStatus(long status) {
        Utils.checkNotNull(status, "status");
        this.status = Optional.ofNullable(status);
        return this;
    }

    public ErrorResponse withStatus(Optional<Long> status) {
        Utils.checkNotNull(status, "status");
        this.status = status;
        return this;
    }

    public ErrorResponse withTitle(String title) {
        Utils.checkNotNull(title, "title");
        this.title = Optional.ofNullable(title);
        return this;
    }

    public ErrorResponse withTitle(Optional<String> title) {
        Utils.checkNotNull(title, "title");
        this.title = title;
        return this;
    }

    public ErrorResponse withDetail(String detail) {
        Utils.checkNotNull(detail, "detail");
        this.detail = Optional.ofNullable(detail);
        return this;
    }

    public ErrorResponse withDetail(Optional<String> detail) {
        Utils.checkNotNull(detail, "detail");
        this.detail = detail;
        return this;
    }

    public ErrorResponse withCode(String code) {
        Utils.checkNotNull(code, "code");
        this.code = Optional.ofNullable(code);
        return this;
    }

    public ErrorResponse withCode(Optional<String> code) {
        Utils.checkNotNull(code, "code");
        this.code = code;
        return this;
    }

    public ErrorResponse withInstance(String instance) {
        Utils.checkNotNull(instance, "instance");
        this.instance = Optional.ofNullable(instance);
        return this;
    }

    public ErrorResponse withInstance(Optional<String> instance) {
        Utils.checkNotNull(instance, "instance");
        this.instance = instance;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ErrorResponse other = (ErrorResponse)o;
        return Objects.deepEquals(this.type, other.type) && Objects.deepEquals(this.status, other.status) && Objects.deepEquals(this.title, other.title) && Objects.deepEquals(this.detail, other.detail) && Objects.deepEquals(this.code, other.code) && Objects.deepEquals(this.instance, other.instance);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.status, this.title, this.detail, this.code, this.instance);
    }

    public String toString() {
        return Utils.toString(ErrorResponse.class, "type", this.type, "status", this.status, "title", this.title, "detail", this.detail, "code", this.code, "instance", this.instance);
    }

    public static final class Builder {
        private Optional<String> type = Optional.empty();
        private Optional<Long> status = Optional.empty();
        private Optional<String> title = Optional.empty();
        private Optional<String> detail = Optional.empty();
        private Optional<String> code = Optional.empty();
        private Optional<String> instance = Optional.empty();

        private Builder() {
        }

        public Builder type(String type) {
            Utils.checkNotNull(type, "type");
            this.type = Optional.ofNullable(type);
            return this;
        }

        public Builder type(Optional<String> type) {
            Utils.checkNotNull(type, "type");
            this.type = type;
            return this;
        }

        public Builder status(long status) {
            Utils.checkNotNull(status, "status");
            this.status = Optional.ofNullable(status);
            return this;
        }

        public Builder status(Optional<Long> status) {
            Utils.checkNotNull(status, "status");
            this.status = status;
            return this;
        }

        public Builder title(String title) {
            Utils.checkNotNull(title, "title");
            this.title = Optional.ofNullable(title);
            return this;
        }

        public Builder title(Optional<String> title) {
            Utils.checkNotNull(title, "title");
            this.title = title;
            return this;
        }

        public Builder detail(String detail) {
            Utils.checkNotNull(detail, "detail");
            this.detail = Optional.ofNullable(detail);
            return this;
        }

        public Builder detail(Optional<String> detail) {
            Utils.checkNotNull(detail, "detail");
            this.detail = detail;
            return this;
        }

        public Builder code(String code) {
            Utils.checkNotNull(code, "code");
            this.code = Optional.ofNullable(code);
            return this;
        }

        public Builder code(Optional<String> code) {
            Utils.checkNotNull(code, "code");
            this.code = code;
            return this;
        }

        public Builder instance(String instance) {
            Utils.checkNotNull(instance, "instance");
            this.instance = Optional.ofNullable(instance);
            return this;
        }

        public Builder instance(Optional<String> instance) {
            Utils.checkNotNull(instance, "instance");
            this.instance = instance;
            return this;
        }

        public ErrorResponse build() {
            return new ErrorResponse(this.type, this.status, this.title, this.detail, this.code, this.instance);
        }
    }
}

