/*
 * Decompiled with CFR 0.152.
 */
package pl.gsmservice.gateway.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import java.util.Optional;
import pl.gsmservice.gateway.utils.Utils;

public class PhoneNumberWithCid {
    @JsonProperty(value="nr")
    private String nr;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="cid")
    private Optional<String> cid;

    @JsonCreator
    public PhoneNumberWithCid(@JsonProperty(value="nr") String nr, @JsonProperty(value="cid") Optional<String> cid) {
        Utils.checkNotNull(nr, "nr");
        Utils.checkNotNull(cid, "cid");
        this.nr = nr;
        this.cid = cid;
    }

    public PhoneNumberWithCid(String nr) {
        this(nr, Optional.empty());
    }

    @JsonIgnore
    public String nr() {
        return this.nr;
    }

    @JsonIgnore
    public Optional<String> cid() {
        return this.cid;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public PhoneNumberWithCid withNr(String nr) {
        Utils.checkNotNull(nr, "nr");
        this.nr = nr;
        return this;
    }

    public PhoneNumberWithCid withCid(String cid) {
        Utils.checkNotNull(cid, "cid");
        this.cid = Optional.ofNullable(cid);
        return this;
    }

    public PhoneNumberWithCid withCid(Optional<String> cid) {
        Utils.checkNotNull(cid, "cid");
        this.cid = cid;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PhoneNumberWithCid other = (PhoneNumberWithCid)o;
        return Objects.deepEquals(this.nr, other.nr) && Objects.deepEquals(this.cid, other.cid);
    }

    public int hashCode() {
        return Objects.hash(this.nr, this.cid);
    }

    public String toString() {
        return Utils.toString(PhoneNumberWithCid.class, "nr", this.nr, "cid", this.cid);
    }

    public static final class Builder {
        private String nr;
        private Optional<String> cid = Optional.empty();

        private Builder() {
        }

        public Builder nr(String nr) {
            Utils.checkNotNull(nr, "nr");
            this.nr = nr;
            return this;
        }

        public Builder cid(String cid) {
            Utils.checkNotNull(cid, "cid");
            this.cid = Optional.ofNullable(cid);
            return this;
        }

        public Builder cid(Optional<String> cid) {
            Utils.checkNotNull(cid, "cid");
            this.cid = cid;
            return this;
        }

        public PhoneNumberWithCid build() {
            return new PhoneNumberWithCid(this.nr, this.cid);
        }
    }
}

