/*
 * Decompiled with CFR 0.152.
 */
package pl.gsmservice.gateway.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Objects;
import java.util.Optional;
import pl.gsmservice.gateway.utils.SpeakeasyMetadata;
import pl.gsmservice.gateway.utils.Utils;

public class Security {
    @SpeakeasyMetadata(value="security:scheme=true,type=http,subtype=bearer,name=Authorization")
    private Optional<String> bearer;

    @JsonCreator
    public Security(Optional<String> bearer) {
        Utils.checkNotNull(bearer, "bearer");
        this.bearer = bearer;
    }

    public Security() {
        this(Optional.empty());
    }

    @JsonIgnore
    public Optional<String> bearer() {
        return this.bearer;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public Security withBearer(String bearer) {
        Utils.checkNotNull(bearer, "bearer");
        this.bearer = Optional.ofNullable(bearer);
        return this;
    }

    public Security withBearer(Optional<String> bearer) {
        Utils.checkNotNull(bearer, "bearer");
        this.bearer = bearer;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Security other = (Security)o;
        return Objects.deepEquals(this.bearer, other.bearer);
    }

    public int hashCode() {
        return Objects.hash(this.bearer);
    }

    public String toString() {
        return Utils.toString(Security.class, "bearer", this.bearer);
    }

    public static final class Builder {
        private Optional<String> bearer = Optional.empty();

        private Builder() {
        }

        public Builder bearer(String bearer) {
            Utils.checkNotNull(bearer, "bearer");
            this.bearer = Optional.ofNullable(bearer);
            return this;
        }

        public Builder bearer(Optional<String> bearer) {
            Utils.checkNotNull(bearer, "bearer");
            this.bearer = bearer;
            return this;
        }

        public Security build() {
            return new Security(this.bearer);
        }
    }
}

