/*
 * Decompiled with CFR 0.152.
 */
package pl.gsmservice.gateway.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import java.time.OffsetDateTime;
import java.util.Objects;
import java.util.Optional;
import org.openapitools.jackson.nullable.JsonNullable;
import pl.gsmservice.gateway.models.components.Recipients;
import pl.gsmservice.gateway.models.components.SmsType;
import pl.gsmservice.gateway.utils.LazySingletonValue;
import pl.gsmservice.gateway.utils.Utils;

public class Sms {
    @JsonProperty(value="recipients")
    private Recipients recipients;
    @JsonProperty(value="message")
    private String message;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="sender")
    private Optional<String> sender;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="type")
    private Optional<? extends SmsType> type;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="unicode")
    private Optional<Boolean> unicode;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="flash")
    private Optional<Boolean> flash;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="date")
    private JsonNullable<OffsetDateTime> date;

    @JsonCreator
    public Sms(@JsonProperty(value="recipients") Recipients recipients, @JsonProperty(value="message") String message, @JsonProperty(value="sender") Optional<String> sender, @JsonProperty(value="type") Optional<? extends SmsType> type, @JsonProperty(value="unicode") Optional<Boolean> unicode, @JsonProperty(value="flash") Optional<Boolean> flash, @JsonProperty(value="date") JsonNullable<OffsetDateTime> date) {
        Utils.checkNotNull(recipients, "recipients");
        Utils.checkNotNull(message, "message");
        Utils.checkNotNull(sender, "sender");
        Utils.checkNotNull(type, "type");
        Utils.checkNotNull(unicode, "unicode");
        Utils.checkNotNull(flash, "flash");
        Utils.checkNotNull(date, "date");
        this.recipients = recipients;
        this.message = message;
        this.sender = sender;
        this.type = type;
        this.unicode = unicode;
        this.flash = flash;
        this.date = date;
    }

    public Sms(Recipients recipients, String message) {
        this(recipients, message, Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), (JsonNullable<OffsetDateTime>)JsonNullable.undefined());
    }

    @JsonIgnore
    public Recipients recipients() {
        return this.recipients;
    }

    @JsonIgnore
    public String message() {
        return this.message;
    }

    @JsonIgnore
    public Optional<String> sender() {
        return this.sender;
    }

    @JsonIgnore
    public Optional<SmsType> type() {
        return this.type;
    }

    @JsonIgnore
    public Optional<Boolean> unicode() {
        return this.unicode;
    }

    @JsonIgnore
    public Optional<Boolean> flash() {
        return this.flash;
    }

    @JsonIgnore
    public JsonNullable<OffsetDateTime> date() {
        return this.date;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public Sms withRecipients(Recipients recipients) {
        Utils.checkNotNull(recipients, "recipients");
        this.recipients = recipients;
        return this;
    }

    public Sms withMessage(String message) {
        Utils.checkNotNull(message, "message");
        this.message = message;
        return this;
    }

    public Sms withSender(String sender) {
        Utils.checkNotNull(sender, "sender");
        this.sender = Optional.ofNullable(sender);
        return this;
    }

    public Sms withSender(Optional<String> sender) {
        Utils.checkNotNull(sender, "sender");
        this.sender = sender;
        return this;
    }

    public Sms withType(SmsType type) {
        Utils.checkNotNull(type, "type");
        this.type = Optional.ofNullable(type);
        return this;
    }

    public Sms withType(Optional<? extends SmsType> type) {
        Utils.checkNotNull(type, "type");
        this.type = type;
        return this;
    }

    public Sms withUnicode(boolean unicode) {
        Utils.checkNotNull(unicode, "unicode");
        this.unicode = Optional.ofNullable(unicode);
        return this;
    }

    public Sms withUnicode(Optional<Boolean> unicode) {
        Utils.checkNotNull(unicode, "unicode");
        this.unicode = unicode;
        return this;
    }

    public Sms withFlash(boolean flash) {
        Utils.checkNotNull(flash, "flash");
        this.flash = Optional.ofNullable(flash);
        return this;
    }

    public Sms withFlash(Optional<Boolean> flash) {
        Utils.checkNotNull(flash, "flash");
        this.flash = flash;
        return this;
    }

    public Sms withDate(OffsetDateTime date) {
        Utils.checkNotNull(date, "date");
        this.date = JsonNullable.of((Object)date);
        return this;
    }

    public Sms withDate(JsonNullable<OffsetDateTime> date) {
        Utils.checkNotNull(date, "date");
        this.date = date;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Sms other = (Sms)o;
        return Objects.deepEquals(this.recipients, other.recipients) && Objects.deepEquals(this.message, other.message) && Objects.deepEquals(this.sender, other.sender) && Objects.deepEquals(this.type, other.type) && Objects.deepEquals(this.unicode, other.unicode) && Objects.deepEquals(this.flash, other.flash) && Objects.deepEquals(this.date, other.date);
    }

    public int hashCode() {
        return Objects.hash(this.recipients, this.message, this.sender, this.type, this.unicode, this.flash, this.date);
    }

    public String toString() {
        return Utils.toString(Sms.class, "recipients", this.recipients, "message", this.message, "sender", this.sender, "type", this.type, "unicode", this.unicode, "flash", this.flash, "date", this.date);
    }

    public static final class Builder {
        private Recipients recipients;
        private String message;
        private Optional<String> sender;
        private Optional<? extends SmsType> type;
        private Optional<Boolean> unicode;
        private Optional<Boolean> flash;
        private JsonNullable<OffsetDateTime> date;
        private static final LazySingletonValue<Optional<String>> _SINGLETON_VALUE_Sender = new LazySingletonValue<Optional<String>>("sender", "\"Bramka SMS\"", new TypeReference<Optional<String>>(){});
        private static final LazySingletonValue<Optional<? extends SmsType>> _SINGLETON_VALUE_Type = new LazySingletonValue<Optional<? extends SmsType>>("type", "1", new TypeReference<Optional<? extends SmsType>>(){});
        private static final LazySingletonValue<Optional<Boolean>> _SINGLETON_VALUE_Unicode = new LazySingletonValue<Optional<Boolean>>("unicode", "false", new TypeReference<Optional<Boolean>>(){});
        private static final LazySingletonValue<Optional<Boolean>> _SINGLETON_VALUE_Flash = new LazySingletonValue<Optional<Boolean>>("flash", "false", new TypeReference<Optional<Boolean>>(){});
        private static final LazySingletonValue<JsonNullable<OffsetDateTime>> _SINGLETON_VALUE_Date = new LazySingletonValue<JsonNullable<OffsetDateTime>>("date", "null", new TypeReference<JsonNullable<OffsetDateTime>>(){});

        private Builder() {
        }

        public Builder recipients(Recipients recipients) {
            Utils.checkNotNull(recipients, "recipients");
            this.recipients = recipients;
            return this;
        }

        public Builder message(String message) {
            Utils.checkNotNull(message, "message");
            this.message = message;
            return this;
        }

        public Builder sender(String sender) {
            Utils.checkNotNull(sender, "sender");
            this.sender = Optional.ofNullable(sender);
            return this;
        }

        public Builder sender(Optional<String> sender) {
            Utils.checkNotNull(sender, "sender");
            this.sender = sender;
            return this;
        }

        public Builder type(SmsType type) {
            Utils.checkNotNull(type, "type");
            this.type = Optional.ofNullable(type);
            return this;
        }

        public Builder type(Optional<? extends SmsType> type) {
            Utils.checkNotNull(type, "type");
            this.type = type;
            return this;
        }

        public Builder unicode(boolean unicode) {
            Utils.checkNotNull(unicode, "unicode");
            this.unicode = Optional.ofNullable(unicode);
            return this;
        }

        public Builder unicode(Optional<Boolean> unicode) {
            Utils.checkNotNull(unicode, "unicode");
            this.unicode = unicode;
            return this;
        }

        public Builder flash(boolean flash) {
            Utils.checkNotNull(flash, "flash");
            this.flash = Optional.ofNullable(flash);
            return this;
        }

        public Builder flash(Optional<Boolean> flash) {
            Utils.checkNotNull(flash, "flash");
            this.flash = flash;
            return this;
        }

        public Builder date(OffsetDateTime date) {
            Utils.checkNotNull(date, "date");
            this.date = JsonNullable.of((Object)date);
            return this;
        }

        public Builder date(JsonNullable<OffsetDateTime> date) {
            Utils.checkNotNull(date, "date");
            this.date = date;
            return this;
        }

        public Sms build() {
            if (this.sender == null) {
                this.sender = _SINGLETON_VALUE_Sender.value();
            }
            if (this.type == null) {
                this.type = _SINGLETON_VALUE_Type.value();
            }
            if (this.unicode == null) {
                this.unicode = _SINGLETON_VALUE_Unicode.value();
            }
            if (this.flash == null) {
                this.flash = _SINGLETON_VALUE_Flash.value();
            }
            if (this.date == null) {
                this.date = _SINGLETON_VALUE_Date.value();
            }
            return new Sms(this.recipients, this.message, this.sender, this.type, this.unicode, this.flash, this.date);
        }
    }
}

