/*
 * Decompiled with CFR 0.152.
 */
package pl.gsmservice.gateway.models.operations;

import java.util.Optional;
import pl.gsmservice.gateway.models.operations.SDKMethodInterfaces;
import pl.gsmservice.gateway.models.operations.SendSmsRequestBody;
import pl.gsmservice.gateway.models.operations.SendSmsResponse;
import pl.gsmservice.gateway.utils.Options;
import pl.gsmservice.gateway.utils.RetryConfig;
import pl.gsmservice.gateway.utils.Utils;

public class SendSmsRequestBuilder {
    private SendSmsRequestBody request;
    private Optional<RetryConfig> retryConfig = Optional.empty();
    private final SDKMethodInterfaces.MethodCallSendSms sdk;

    public SendSmsRequestBuilder(SDKMethodInterfaces.MethodCallSendSms sdk) {
        this.sdk = sdk;
    }

    public SendSmsRequestBuilder request(SendSmsRequestBody request) {
        Utils.checkNotNull(request, "request");
        this.request = request;
        return this;
    }

    public SendSmsRequestBuilder retryConfig(RetryConfig retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = Optional.of(retryConfig);
        return this;
    }

    public SendSmsRequestBuilder retryConfig(Optional<RetryConfig> retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = retryConfig;
        return this;
    }

    public SendSmsResponse call() throws Exception {
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        return this.sdk.send(this.request, options);
    }
}

