/*
 * Decompiled with CFR 0.152.
 */
package pl.gsmservice.gateway.utils;

import java.net.URISyntaxException;
import java.net.http.HttpRequest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.message.BasicNameValuePair;
import pl.gsmservice.gateway.utils.SerializedBody;
import pl.gsmservice.gateway.utils.Utils;

public class HTTPRequest {
    private final String baseURL;
    private final String method;
    private final List<NameValuePair> queryParams = new ArrayList<NameValuePair>();
    private final Map<String, List<String>> headers = new HashMap<String, List<String>>();
    private Optional<SerializedBody> body = Optional.empty();

    public HTTPRequest(String baseURL, String method) {
        Utils.checkNotNull(baseURL, "baseURL");
        Utils.checkNotNull(method, "method");
        this.baseURL = baseURL;
        this.method = method;
    }

    public void setBody(Optional<SerializedBody> body) {
        Utils.checkNotNull(body, "body");
        this.body = body;
    }

    public HTTPRequest addHeader(String key, String value) {
        List<String> headerValues = this.headers.get(key);
        if (headerValues == null) {
            headerValues = new ArrayList<String>();
            this.headers.put(key, headerValues);
        }
        headerValues.add(value);
        return this;
    }

    public HTTPRequest addHeaders(Map<String, List<String>> map) {
        map.forEach((key, list) -> list.forEach(v -> this.addHeader((String)key, (String)v)));
        return this;
    }

    public HTTPRequest addQueryParam(String name, String value) {
        this.addQueryParam((NameValuePair)new BasicNameValuePair(name, value));
        return this;
    }

    public HTTPRequest addQueryParam(NameValuePair param) {
        this.queryParams.add(param);
        return this;
    }

    public HTTPRequest addQueryParams(Collection<NameValuePair> params) {
        params.forEach(p -> this.addQueryParam((NameValuePair)p));
        return this;
    }

    public HttpRequest build() {
        HttpRequest.BodyPublisher bodyPublisher;
        HttpRequest.Builder requestBuilder = HttpRequest.newBuilder();
        if (this.body.isPresent()) {
            bodyPublisher = this.body.get().body();
            requestBuilder.header("Content-Type", this.body.get().contentType());
        } else {
            bodyPublisher = HttpRequest.BodyPublishers.noBody();
        }
        requestBuilder.method(this.method, bodyPublisher);
        try {
            URIBuilder b = new URIBuilder(this.baseURL);
            this.queryParams.forEach(pair -> b.addParameter(pair.getName(), pair.getValue()));
            requestBuilder.uri(b.build());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        this.headers.forEach((k, list) -> list.forEach(v -> requestBuilder.header((String)k, (String)v)));
        return requestBuilder.build();
    }
}

