/*
 * Decompiled with CFR 0.152.
 */
package pl.gsmservice.gateway.utils;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicNameValuePair;
import pl.gsmservice.gateway.utils.JSON;
import pl.gsmservice.gateway.utils.QueryParamsMetadata;
import pl.gsmservice.gateway.utils.Types;
import pl.gsmservice.gateway.utils.Utils;

public class QueryParameters {
    public static <T> List<NameValuePair> parseQueryParams(Class<T> type, T queryParams, Map<String, Map<String, Map<String, Object>>> globals) throws Exception {
        Field[] fields;
        ArrayList<NameValuePair> allParams = new ArrayList<NameValuePair>();
        block10: for (Field field : fields = type.getDeclaredFields()) {
            QueryParamsMetadata queryParamsMetadata;
            field.setAccessible(true);
            if (Modifier.isStatic(field.getModifiers())) continue;
            Object value = queryParams != null ? field.get(queryParams) : null;
            value = Utils.resolveStringShape(type, field.getName(), value);
            value = Utils.resolveOptionals(value);
            if ((value = Utils.populateGlobal(value, field.getName(), "queryParam", globals)) == null || (queryParamsMetadata = QueryParamsMetadata.parse(field)) == null) continue;
            if (queryParamsMetadata.serialization != null && !queryParamsMetadata.serialization.isBlank()) {
                List<NameValuePair> params = QueryParameters.parseSerializedParams(queryParamsMetadata, value);
                allParams.addAll(params);
                continue;
            }
            switch (queryParamsMetadata.style) {
                case "form": {
                    List<NameValuePair> formParams = QueryParameters.parseDelimitedParams(queryParamsMetadata, value, ",");
                    allParams.addAll(formParams);
                    continue block10;
                }
                case "deepObject": {
                    List<NameValuePair> deepObjectParams = QueryParameters.parseDeepObjectParams(queryParamsMetadata, value);
                    allParams.addAll(deepObjectParams);
                    continue block10;
                }
                case "pipeDelimited": {
                    List<NameValuePair> pipeDelimitedParams = QueryParameters.parseDelimitedParams(queryParamsMetadata, value, "|");
                    allParams.addAll(pipeDelimitedParams);
                    continue block10;
                }
            }
        }
        return allParams;
    }

    private static List<NameValuePair> parseSerializedParams(QueryParamsMetadata queryParamsMetadata, Object value) throws JsonProcessingException {
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        switch (queryParamsMetadata.serialization) {
            case "json": {
                ObjectMapper mapper = JSON.getMapper();
                String json = mapper.writeValueAsString(value);
                params.add((NameValuePair)new BasicNameValuePair(queryParamsMetadata.name, json));
                break;
            }
        }
        return params;
    }

    private static List<NameValuePair> parseDelimitedParams(QueryParamsMetadata queryParamsMetadata, Object value, String delimiter) throws IllegalArgumentException, IllegalAccessException {
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        switch (Types.getType(value.getClass())) {
            case ARRAY: {
                List<?> array = Utils.toList(value);
                ArrayList<String> values = new ArrayList<String>();
                ArrayList<String> items = new ArrayList<String>();
                for (Object v2 : array) {
                    if (queryParamsMetadata.explode) {
                        values.add(Utils.valToString(v2));
                        continue;
                    }
                    items.add(Utils.valToString(v2));
                }
                if (items.size() > 0) {
                    values.add(String.join((CharSequence)delimiter, items));
                }
                params.addAll(values.stream().map(v -> new BasicNameValuePair(queryParamsMetadata.name, v)).collect(Collectors.toList()));
                break;
            }
            case MAP: {
                Map map = (Map)value;
                ArrayList<String> items = new ArrayList<String>();
                for (Map.Entry entry : map.entrySet()) {
                    String key = Utils.valToString(entry.getKey());
                    String val = Utils.valToString(entry.getValue());
                    if (queryParamsMetadata.explode) {
                        params.add((NameValuePair)new BasicNameValuePair(key, val));
                        continue;
                    }
                    items.add(String.format("%s%s%s", key, delimiter, val));
                }
                if (items.size() <= 0) break;
                params.add((NameValuePair)new BasicNameValuePair(queryParamsMetadata.name, String.join((CharSequence)delimiter, items)));
                break;
            }
            case OBJECT: {
                if (!Utils.allowIntrospection(value.getClass())) {
                    params.add((NameValuePair)new BasicNameValuePair(queryParamsMetadata.name, Utils.valToString(value)));
                    break;
                }
                Field[] fields = value.getClass().getDeclaredFields();
                ArrayList<String> items = new ArrayList<String>();
                for (Field field : fields) {
                    QueryParamsMetadata metadata;
                    field.setAccessible(true);
                    Object val = field.get(value);
                    val = Utils.resolveOptionals(val);
                    if (val == null || (metadata = QueryParamsMetadata.parse(field)) == null) continue;
                    if (queryParamsMetadata.explode) {
                        params.add((NameValuePair)new BasicNameValuePair(metadata.name, Utils.valToString(val)));
                        continue;
                    }
                    items.add(String.format("%s%s%s", metadata.name, delimiter, Utils.valToString(val)));
                }
                if (items.size() <= 0) break;
                params.add((NameValuePair)new BasicNameValuePair(queryParamsMetadata.name, String.join((CharSequence)delimiter, items)));
                break;
            }
            default: {
                params.add((NameValuePair)new BasicNameValuePair(queryParamsMetadata.name, Utils.valToString(value)));
            }
        }
        return params;
    }

    private static List<NameValuePair> parseDeepObjectParams(QueryParamsMetadata queryParamsMetadata, Object value) throws Exception {
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        switch (Types.getType(value.getClass())) {
            case MAP: {
                Map map = (Map)value;
                for (Map.Entry entry : map.entrySet()) {
                    String key = Utils.valToString(entry.getKey());
                    Object val = Utils.resolveOptionals(entry.getValue());
                    if (val instanceof List || val.getClass().isArray()) {
                        for (Object v : Utils.toList(val)) {
                            params.add((NameValuePair)new BasicNameValuePair(String.format("%s[%s]", queryParamsMetadata.name, key), Utils.valToString(v)));
                        }
                        continue;
                    }
                    params.add((NameValuePair)new BasicNameValuePair(String.format("%s[%s]", queryParamsMetadata.name, key), Utils.valToString(val)));
                }
                return params;
            }
            case OBJECT: {
                Field[] fields;
                if (!Utils.allowIntrospection(value.getClass())) {
                    throw new RuntimeException("DeepObject style only supports Map and Object types, not " + value.getClass());
                }
                for (Field field : fields = value.getClass().getDeclaredFields()) {
                    QueryParamsMetadata metadata;
                    field.setAccessible(true);
                    Object val = field.get(value);
                    val = Utils.resolveOptionals(val);
                    if (val == null || (metadata = QueryParamsMetadata.parse(field)) == null) continue;
                    if (val instanceof List || val.getClass().isArray()) {
                        for (Object v : Utils.toList(val)) {
                            params.add((NameValuePair)new BasicNameValuePair(String.format("%s[%s]", queryParamsMetadata.name, metadata.name), Utils.valToString(v)));
                        }
                        continue;
                    }
                    params.add((NameValuePair)new BasicNameValuePair(String.format("%s[%s]", queryParamsMetadata.name, metadata.name), Utils.valToString(val)));
                }
                return params;
            }
        }
        throw new RuntimeException("DeepObject style only supports Map and Object types");
    }
}

