/*
 * Decompiled with CFR 0.152.
 */
package pl.gsmservice.gateway.utils;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.net.http.HttpRequest;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.message.BasicNameValuePair;
import org.openapitools.jackson.nullable.JsonNullable;
import pl.gsmservice.gateway.utils.FormMetadata;
import pl.gsmservice.gateway.utils.JSON;
import pl.gsmservice.gateway.utils.MultipartFormMetadata;
import pl.gsmservice.gateway.utils.RequestMetadata;
import pl.gsmservice.gateway.utils.SerializedBody;
import pl.gsmservice.gateway.utils.Types;
import pl.gsmservice.gateway.utils.Utils;

public final class RequestBody {
    private static final Map<String, String> SERIALIZATION_METHOD_TO_CONTENT_TYPE = Map.of("json", "application/json", "form", "application/x-www-form-urlencoded", "multipart", "multipart/form-data", "raw", "application/octet-stream", "string", "text/plain");

    private RequestBody() {
    }

    public static SerializedBody serialize(Object request, String requestField, String serializationMethod, boolean nullable) throws NoSuchFieldException, IllegalArgumentException, IllegalAccessException, UnsupportedOperationException, IOException {
        if (request == null) {
            return null;
        }
        if (!nullable && request instanceof Optional && ((Optional)request).isEmpty()) {
            request = JsonNullable.undefined();
        }
        if (Types.getType(request.getClass()) != Types.OBJECT) {
            return RequestBody.serializeContentType(requestField, SERIALIZATION_METHOD_TO_CONTENT_TYPE.get(serializationMethod), request);
        }
        Field reqField = null;
        try {
            reqField = request.getClass().getDeclaredField(requestField);
            reqField.setAccessible(true);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
        if (reqField == null) {
            return RequestBody.serializeContentType(requestField, SERIALIZATION_METHOD_TO_CONTENT_TYPE.get(serializationMethod), request);
        }
        Object requestValue = reqField.get(request);
        if ((requestValue = Utils.resolveOptionals(requestValue)) == null) {
            return null;
        }
        RequestMetadata requestMetadata = RequestMetadata.parse(reqField);
        if (requestMetadata == null) {
            throw new RuntimeException("Missing request metadata on request field");
        }
        return RequestBody.serializeContentType(requestField, requestMetadata.mediaType, requestValue);
    }

    private static SerializedBody serializeContentType(String fieldName, String contentType, Object value) throws IllegalArgumentException, IllegalAccessException, UnsupportedOperationException, IOException {
        SerializedBody body;
        Pattern jsonPattern = Pattern.compile("(application|text)\\/.*?\\+*json.*");
        Pattern multipartPattern = Pattern.compile("multipart\\/.*");
        Pattern formPattern = Pattern.compile("application\\/x-www-form-urlencoded.*");
        Pattern textPattern = Pattern.compile("text\\/plain");
        if (textPattern.matcher(contentType).matches()) {
            body = new SerializedBody(contentType, HttpRequest.BodyPublishers.ofString(value.toString()));
        } else if (jsonPattern.matcher(contentType).matches()) {
            ObjectMapper mapper = JSON.getMapper();
            body = value instanceof JsonNullable && !((JsonNullable)value).isPresent() ? new SerializedBody(contentType, HttpRequest.BodyPublishers.noBody()) : new SerializedBody(contentType, HttpRequest.BodyPublishers.ofString(mapper.writeValueAsString(value)));
        } else if (multipartPattern.matcher(contentType).matches()) {
            body = RequestBody.serializeMultipart(value);
        } else if (formPattern.matcher(contentType).matches()) {
            body = RequestBody.serializeFormData(value);
        } else if (value instanceof String) {
            body = new SerializedBody(contentType, HttpRequest.BodyPublishers.ofString((String)value));
        } else if (value instanceof byte[]) {
            body = new SerializedBody(contentType, HttpRequest.BodyPublishers.ofByteArray((byte[])value));
        } else {
            throw new RuntimeException("Unsupported content type " + contentType + " for field " + fieldName);
        }
        return body;
    }

    private static SerializedBody serializeMultipart(Object value) throws IllegalArgumentException, IllegalAccessException, UnsupportedOperationException, IOException {
        Field[] fields;
        MultipartEntityBuilder builder = MultipartEntityBuilder.create();
        builder.setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
        String boundary = "-------------" + System.currentTimeMillis();
        builder.setBoundary(boundary);
        for (Field field : fields = value.getClass().getDeclaredFields()) {
            Object val;
            field.setAccessible(true);
            if (Modifier.isStatic(field.getModifiers()) || (val = Utils.resolveOptionals(field.get(value))) == null) continue;
            MultipartFormMetadata metadata = MultipartFormMetadata.parse(field);
            if (metadata == null) {
                throw new RuntimeException("Missing multipart form metadata on field " + field.getName());
            }
            if (metadata.file) {
                RequestBody.serializeMultipartFile(builder, val);
                continue;
            }
            if (metadata.json) {
                ObjectMapper mapper = JSON.getMapper();
                String json = mapper.writeValueAsString(val);
                builder.addTextBody(metadata.name, json, ContentType.APPLICATION_JSON);
                continue;
            }
            if (val instanceof List || val.getClass().isArray()) {
                List<?> arr = Utils.toList(val);
                for (Object item : arr) {
                    builder.addTextBody(metadata.name + "[]", Utils.valToString(item));
                }
                continue;
            }
            builder.addTextBody(metadata.name, Utils.valToString(val));
        }
        HttpEntity entity = builder.build();
        String ct = builder.build().getContentType().getValue();
        return new SerializedBody(ct, HttpRequest.BodyPublishers.ofInputStream(() -> {
            try {
                return entity.getContent();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }));
    }

    private static void serializeMultipartFile(MultipartEntityBuilder builder, Object file) throws IllegalArgumentException, IllegalAccessException {
        Field[] fields;
        if (Types.getType(file.getClass()) != Types.OBJECT) {
            throw new RuntimeException("Invalid type for multipart file");
        }
        String fieldName = "";
        String fileName = "";
        byte[] content = null;
        for (Field field : fields = file.getClass().getDeclaredFields()) {
            MultipartFormMetadata metadata;
            field.setAccessible(true);
            Object val = field.get(file);
            if (val == null || (metadata = MultipartFormMetadata.parse(field)) == null || !metadata.content && (metadata.name == null || metadata.name.isBlank())) continue;
            if (metadata.content) {
                content = (byte[])val;
                continue;
            }
            fieldName = metadata.name;
            fileName = Utils.valToString(val);
        }
        if (fieldName.isBlank() || fileName.isBlank() || content == null) {
            throw new RuntimeException("Invalid multipart file");
        }
        builder.addBinaryBody(fieldName, content, ContentType.APPLICATION_OCTET_STREAM, fileName);
    }

    public static SerializedBody serializeFormData(Object value) throws IOException, IllegalArgumentException, IllegalAccessException {
        ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
        switch (Types.getType(value.getClass())) {
            case MAP: {
                Map map = (Map)value;
                for (Map.Entry entry : map.entrySet()) {
                    params.add(new BasicNameValuePair(Utils.valToString(entry.getKey()), Utils.valToString(entry.getValue())));
                }
                break;
            }
            case OBJECT: {
                Field[] fields;
                if (!Utils.allowIntrospection(value.getClass())) {
                    throw new RuntimeException("Invalid type for form data");
                }
                block10: for (Field field : fields = value.getClass().getDeclaredFields()) {
                    FormMetadata metadata;
                    field.setAccessible(true);
                    Object val = Utils.resolveOptionals(field.get(value));
                    if (val == null || (metadata = FormMetadata.parse(field)) == null) continue;
                    if (metadata.json) {
                        ObjectMapper mapper = JSON.getMapper();
                        String json = mapper.writeValueAsString(val);
                        params.add(new BasicNameValuePair(metadata.name, json));
                        continue;
                    }
                    switch (Types.getType(val.getClass())) {
                        case OBJECT: {
                            if (!Utils.allowIntrospection(val.getClass())) {
                                params.add(new BasicNameValuePair(metadata.name, String.valueOf(val)));
                                continue block10;
                            }
                            Field[] valFields = val.getClass().getDeclaredFields();
                            ArrayList<String> items = new ArrayList();
                            for (Field field2 : valFields) {
                                FormMetadata valMetadata;
                                field2.setAccessible(true);
                                Object v = Utils.resolveOptionals(field2.get(val));
                                if (v == null || (valMetadata = FormMetadata.parse(field2)) == null) continue;
                                if (metadata.explode) {
                                    params.add(new BasicNameValuePair(valMetadata.name, Utils.valToString(v)));
                                    continue;
                                }
                                items.add(String.format("%s,%s", valMetadata.name, Utils.valToString(v)));
                            }
                            if (items.size() <= 0) continue block10;
                            params.add(new BasicNameValuePair(metadata.name, String.join((CharSequence)",", items)));
                            continue block10;
                        }
                        case MAP: {
                            Map valMap = (Map)val;
                            ArrayList<String> items = new ArrayList<String>();
                            for (Map.Entry entry : valMap.entrySet()) {
                                if (metadata.explode) {
                                    params.add(new BasicNameValuePair(Utils.valToString(entry.getKey()), Utils.valToString(entry.getValue())));
                                    continue;
                                }
                                items.add(String.format("%s,%s", entry.getKey(), entry.getValue()));
                            }
                            if (items.size() <= 0) continue block10;
                            params.add(new BasicNameValuePair(metadata.name, String.join((CharSequence)",", items)));
                            continue block10;
                        }
                        case ARRAY: {
                            List<Object> array = Utils.toList(val);
                            ArrayList<String> items = new ArrayList();
                            for (Object e : array) {
                                if (metadata.explode) {
                                    params.add(new BasicNameValuePair(metadata.name, Utils.valToString(e)));
                                    continue;
                                }
                                items.add(Utils.valToString(e));
                            }
                            if (items.size() <= 0) continue block10;
                            params.add(new BasicNameValuePair(metadata.name, String.join((CharSequence)",", items)));
                            continue block10;
                        }
                        default: {
                            params.add(new BasicNameValuePair(metadata.name, Utils.valToString(val)));
                        }
                    }
                }
                break;
            }
            default: {
                throw new RuntimeException("Invalid type for form data");
            }
        }
        UrlEncodedFormEntity entity = new UrlEncodedFormEntity(params);
        String ct = entity.getContentType().getValue();
        return new SerializedBody(ct, HttpRequest.BodyPublishers.ofInputStream(() -> {
            try {
                return entity.getContent();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }));
    }
}

