/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */

package pl.gsmservice.gateway.models.components;


import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.Long;
import java.lang.Override;
import java.lang.String;
import java.time.OffsetDateTime;
import java.util.Objects;
import java.util.Optional;
import org.openapitools.jackson.nullable.JsonNullable;
import pl.gsmservice.gateway.utils.Utils;

/**
 * IncomingMessage - An object with the properties of the received message
 */

public class IncomingMessage {

    /**
     * Unique identifier of incoming message
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("id")
    private Optional<Long> id;

    /**
     * Login of the account (sub-account) on which the message was received
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("login")
    private Optional<String> login;

    /**
     * Recipient number (or service name)
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("recipient")
    private Optional<String> recipient;

    /**
     * Message sender number (or alphanumeric name)
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("sender")
    private Optional<String> sender;

    /**
     * Sender name (matched with phonebook)
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("phonebook_sender_name")
    private JsonNullable<String> phonebookSenderName;

    /**
     * Date and time of message receipt in ISO 8601 format
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("date")
    private Optional<OffsetDateTime> date;

    /**
     * Received message content
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("message")
    private Optional<String> message;

    /**
     * Dedicated Mobile Originated service number (if the message was received on this number)
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("dedicated_number")
    private JsonNullable<String> dedicatedNumber;

    /**
     * Dedicated Mobile Originated service prefix (if the message was received on this number with such prefix)
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("dedicated_prefix")
    private JsonNullable<String> dedicatedPrefix;

    @JsonCreator
    public IncomingMessage(
            @JsonProperty("id") Optional<Long> id,
            @JsonProperty("login") Optional<String> login,
            @JsonProperty("recipient") Optional<String> recipient,
            @JsonProperty("sender") Optional<String> sender,
            @JsonProperty("phonebook_sender_name") JsonNullable<String> phonebookSenderName,
            @JsonProperty("date") Optional<OffsetDateTime> date,
            @JsonProperty("message") Optional<String> message,
            @JsonProperty("dedicated_number") JsonNullable<String> dedicatedNumber,
            @JsonProperty("dedicated_prefix") JsonNullable<String> dedicatedPrefix) {
        Utils.checkNotNull(id, "id");
        Utils.checkNotNull(login, "login");
        Utils.checkNotNull(recipient, "recipient");
        Utils.checkNotNull(sender, "sender");
        Utils.checkNotNull(phonebookSenderName, "phonebookSenderName");
        Utils.checkNotNull(date, "date");
        Utils.checkNotNull(message, "message");
        Utils.checkNotNull(dedicatedNumber, "dedicatedNumber");
        Utils.checkNotNull(dedicatedPrefix, "dedicatedPrefix");
        this.id = id;
        this.login = login;
        this.recipient = recipient;
        this.sender = sender;
        this.phonebookSenderName = phonebookSenderName;
        this.date = date;
        this.message = message;
        this.dedicatedNumber = dedicatedNumber;
        this.dedicatedPrefix = dedicatedPrefix;
    }
    
    public IncomingMessage() {
        this(Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), JsonNullable.undefined(), Optional.empty(), Optional.empty(), JsonNullable.undefined(), JsonNullable.undefined());
    }

    /**
     * Unique identifier of incoming message
     */
    @JsonIgnore
    public Optional<Long> id() {
        return id;
    }

    /**
     * Login of the account (sub-account) on which the message was received
     */
    @JsonIgnore
    public Optional<String> login() {
        return login;
    }

    /**
     * Recipient number (or service name)
     */
    @JsonIgnore
    public Optional<String> recipient() {
        return recipient;
    }

    /**
     * Message sender number (or alphanumeric name)
     */
    @JsonIgnore
    public Optional<String> sender() {
        return sender;
    }

    /**
     * Sender name (matched with phonebook)
     */
    @JsonIgnore
    public JsonNullable<String> phonebookSenderName() {
        return phonebookSenderName;
    }

    /**
     * Date and time of message receipt in ISO 8601 format
     */
    @JsonIgnore
    public Optional<OffsetDateTime> date() {
        return date;
    }

    /**
     * Received message content
     */
    @JsonIgnore
    public Optional<String> message() {
        return message;
    }

    /**
     * Dedicated Mobile Originated service number (if the message was received on this number)
     */
    @JsonIgnore
    public JsonNullable<String> dedicatedNumber() {
        return dedicatedNumber;
    }

    /**
     * Dedicated Mobile Originated service prefix (if the message was received on this number with such prefix)
     */
    @JsonIgnore
    public JsonNullable<String> dedicatedPrefix() {
        return dedicatedPrefix;
    }

    public final static Builder builder() {
        return new Builder();
    }

    /**
     * Unique identifier of incoming message
     */
    public IncomingMessage withId(long id) {
        Utils.checkNotNull(id, "id");
        this.id = Optional.ofNullable(id);
        return this;
    }

    /**
     * Unique identifier of incoming message
     */
    public IncomingMessage withId(Optional<Long> id) {
        Utils.checkNotNull(id, "id");
        this.id = id;
        return this;
    }

    /**
     * Login of the account (sub-account) on which the message was received
     */
    public IncomingMessage withLogin(String login) {
        Utils.checkNotNull(login, "login");
        this.login = Optional.ofNullable(login);
        return this;
    }

    /**
     * Login of the account (sub-account) on which the message was received
     */
    public IncomingMessage withLogin(Optional<String> login) {
        Utils.checkNotNull(login, "login");
        this.login = login;
        return this;
    }

    /**
     * Recipient number (or service name)
     */
    public IncomingMessage withRecipient(String recipient) {
        Utils.checkNotNull(recipient, "recipient");
        this.recipient = Optional.ofNullable(recipient);
        return this;
    }

    /**
     * Recipient number (or service name)
     */
    public IncomingMessage withRecipient(Optional<String> recipient) {
        Utils.checkNotNull(recipient, "recipient");
        this.recipient = recipient;
        return this;
    }

    /**
     * Message sender number (or alphanumeric name)
     */
    public IncomingMessage withSender(String sender) {
        Utils.checkNotNull(sender, "sender");
        this.sender = Optional.ofNullable(sender);
        return this;
    }

    /**
     * Message sender number (or alphanumeric name)
     */
    public IncomingMessage withSender(Optional<String> sender) {
        Utils.checkNotNull(sender, "sender");
        this.sender = sender;
        return this;
    }

    /**
     * Sender name (matched with phonebook)
     */
    public IncomingMessage withPhonebookSenderName(String phonebookSenderName) {
        Utils.checkNotNull(phonebookSenderName, "phonebookSenderName");
        this.phonebookSenderName = JsonNullable.of(phonebookSenderName);
        return this;
    }

    /**
     * Sender name (matched with phonebook)
     */
    public IncomingMessage withPhonebookSenderName(JsonNullable<String> phonebookSenderName) {
        Utils.checkNotNull(phonebookSenderName, "phonebookSenderName");
        this.phonebookSenderName = phonebookSenderName;
        return this;
    }

    /**
     * Date and time of message receipt in ISO 8601 format
     */
    public IncomingMessage withDate(OffsetDateTime date) {
        Utils.checkNotNull(date, "date");
        this.date = Optional.ofNullable(date);
        return this;
    }

    /**
     * Date and time of message receipt in ISO 8601 format
     */
    public IncomingMessage withDate(Optional<OffsetDateTime> date) {
        Utils.checkNotNull(date, "date");
        this.date = date;
        return this;
    }

    /**
     * Received message content
     */
    public IncomingMessage withMessage(String message) {
        Utils.checkNotNull(message, "message");
        this.message = Optional.ofNullable(message);
        return this;
    }

    /**
     * Received message content
     */
    public IncomingMessage withMessage(Optional<String> message) {
        Utils.checkNotNull(message, "message");
        this.message = message;
        return this;
    }

    /**
     * Dedicated Mobile Originated service number (if the message was received on this number)
     */
    public IncomingMessage withDedicatedNumber(String dedicatedNumber) {
        Utils.checkNotNull(dedicatedNumber, "dedicatedNumber");
        this.dedicatedNumber = JsonNullable.of(dedicatedNumber);
        return this;
    }

    /**
     * Dedicated Mobile Originated service number (if the message was received on this number)
     */
    public IncomingMessage withDedicatedNumber(JsonNullable<String> dedicatedNumber) {
        Utils.checkNotNull(dedicatedNumber, "dedicatedNumber");
        this.dedicatedNumber = dedicatedNumber;
        return this;
    }

    /**
     * Dedicated Mobile Originated service prefix (if the message was received on this number with such prefix)
     */
    public IncomingMessage withDedicatedPrefix(String dedicatedPrefix) {
        Utils.checkNotNull(dedicatedPrefix, "dedicatedPrefix");
        this.dedicatedPrefix = JsonNullable.of(dedicatedPrefix);
        return this;
    }

    /**
     * Dedicated Mobile Originated service prefix (if the message was received on this number with such prefix)
     */
    public IncomingMessage withDedicatedPrefix(JsonNullable<String> dedicatedPrefix) {
        Utils.checkNotNull(dedicatedPrefix, "dedicatedPrefix");
        this.dedicatedPrefix = dedicatedPrefix;
        return this;
    }
    
    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        IncomingMessage other = (IncomingMessage) o;
        return 
            Objects.deepEquals(this.id, other.id) &&
            Objects.deepEquals(this.login, other.login) &&
            Objects.deepEquals(this.recipient, other.recipient) &&
            Objects.deepEquals(this.sender, other.sender) &&
            Objects.deepEquals(this.phonebookSenderName, other.phonebookSenderName) &&
            Objects.deepEquals(this.date, other.date) &&
            Objects.deepEquals(this.message, other.message) &&
            Objects.deepEquals(this.dedicatedNumber, other.dedicatedNumber) &&
            Objects.deepEquals(this.dedicatedPrefix, other.dedicatedPrefix);
    }
    
    @Override
    public int hashCode() {
        return Objects.hash(
            id,
            login,
            recipient,
            sender,
            phonebookSenderName,
            date,
            message,
            dedicatedNumber,
            dedicatedPrefix);
    }
    
    @Override
    public String toString() {
        return Utils.toString(IncomingMessage.class,
                "id", id,
                "login", login,
                "recipient", recipient,
                "sender", sender,
                "phonebookSenderName", phonebookSenderName,
                "date", date,
                "message", message,
                "dedicatedNumber", dedicatedNumber,
                "dedicatedPrefix", dedicatedPrefix);
    }
    
    public final static class Builder {
 
        private Optional<Long> id = Optional.empty();
 
        private Optional<String> login = Optional.empty();
 
        private Optional<String> recipient = Optional.empty();
 
        private Optional<String> sender = Optional.empty();
 
        private JsonNullable<String> phonebookSenderName = JsonNullable.undefined();
 
        private Optional<OffsetDateTime> date = Optional.empty();
 
        private Optional<String> message = Optional.empty();
 
        private JsonNullable<String> dedicatedNumber = JsonNullable.undefined();
 
        private JsonNullable<String> dedicatedPrefix = JsonNullable.undefined();  
        
        private Builder() {
          // force use of static builder() method
        }

        /**
         * Unique identifier of incoming message
         */
        public Builder id(long id) {
            Utils.checkNotNull(id, "id");
            this.id = Optional.ofNullable(id);
            return this;
        }

        /**
         * Unique identifier of incoming message
         */
        public Builder id(Optional<Long> id) {
            Utils.checkNotNull(id, "id");
            this.id = id;
            return this;
        }

        /**
         * Login of the account (sub-account) on which the message was received
         */
        public Builder login(String login) {
            Utils.checkNotNull(login, "login");
            this.login = Optional.ofNullable(login);
            return this;
        }

        /**
         * Login of the account (sub-account) on which the message was received
         */
        public Builder login(Optional<String> login) {
            Utils.checkNotNull(login, "login");
            this.login = login;
            return this;
        }

        /**
         * Recipient number (or service name)
         */
        public Builder recipient(String recipient) {
            Utils.checkNotNull(recipient, "recipient");
            this.recipient = Optional.ofNullable(recipient);
            return this;
        }

        /**
         * Recipient number (or service name)
         */
        public Builder recipient(Optional<String> recipient) {
            Utils.checkNotNull(recipient, "recipient");
            this.recipient = recipient;
            return this;
        }

        /**
         * Message sender number (or alphanumeric name)
         */
        public Builder sender(String sender) {
            Utils.checkNotNull(sender, "sender");
            this.sender = Optional.ofNullable(sender);
            return this;
        }

        /**
         * Message sender number (or alphanumeric name)
         */
        public Builder sender(Optional<String> sender) {
            Utils.checkNotNull(sender, "sender");
            this.sender = sender;
            return this;
        }

        /**
         * Sender name (matched with phonebook)
         */
        public Builder phonebookSenderName(String phonebookSenderName) {
            Utils.checkNotNull(phonebookSenderName, "phonebookSenderName");
            this.phonebookSenderName = JsonNullable.of(phonebookSenderName);
            return this;
        }

        /**
         * Sender name (matched with phonebook)
         */
        public Builder phonebookSenderName(JsonNullable<String> phonebookSenderName) {
            Utils.checkNotNull(phonebookSenderName, "phonebookSenderName");
            this.phonebookSenderName = phonebookSenderName;
            return this;
        }

        /**
         * Date and time of message receipt in ISO 8601 format
         */
        public Builder date(OffsetDateTime date) {
            Utils.checkNotNull(date, "date");
            this.date = Optional.ofNullable(date);
            return this;
        }

        /**
         * Date and time of message receipt in ISO 8601 format
         */
        public Builder date(Optional<OffsetDateTime> date) {
            Utils.checkNotNull(date, "date");
            this.date = date;
            return this;
        }

        /**
         * Received message content
         */
        public Builder message(String message) {
            Utils.checkNotNull(message, "message");
            this.message = Optional.ofNullable(message);
            return this;
        }

        /**
         * Received message content
         */
        public Builder message(Optional<String> message) {
            Utils.checkNotNull(message, "message");
            this.message = message;
            return this;
        }

        /**
         * Dedicated Mobile Originated service number (if the message was received on this number)
         */
        public Builder dedicatedNumber(String dedicatedNumber) {
            Utils.checkNotNull(dedicatedNumber, "dedicatedNumber");
            this.dedicatedNumber = JsonNullable.of(dedicatedNumber);
            return this;
        }

        /**
         * Dedicated Mobile Originated service number (if the message was received on this number)
         */
        public Builder dedicatedNumber(JsonNullable<String> dedicatedNumber) {
            Utils.checkNotNull(dedicatedNumber, "dedicatedNumber");
            this.dedicatedNumber = dedicatedNumber;
            return this;
        }

        /**
         * Dedicated Mobile Originated service prefix (if the message was received on this number with such prefix)
         */
        public Builder dedicatedPrefix(String dedicatedPrefix) {
            Utils.checkNotNull(dedicatedPrefix, "dedicatedPrefix");
            this.dedicatedPrefix = JsonNullable.of(dedicatedPrefix);
            return this;
        }

        /**
         * Dedicated Mobile Originated service prefix (if the message was received on this number with such prefix)
         */
        public Builder dedicatedPrefix(JsonNullable<String> dedicatedPrefix) {
            Utils.checkNotNull(dedicatedPrefix, "dedicatedPrefix");
            this.dedicatedPrefix = dedicatedPrefix;
            return this;
        }
        
        public IncomingMessage build() {
            return new IncomingMessage(
                id,
                login,
                recipient,
                sender,
                phonebookSenderName,
                date,
                message,
                dedicatedNumber,
                dedicatedPrefix);
        }
    }
}

