/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */

package pl.gsmservice.gateway;

import com.fasterxml.jackson.core.type.TypeReference;
import java.io.InputStream;
import java.lang.Exception;
import java.lang.String;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import pl.gsmservice.gateway.models.components.AccountResponse;
import pl.gsmservice.gateway.models.errors.ErrorResponse;
import pl.gsmservice.gateway.models.errors.SDKError;
import pl.gsmservice.gateway.models.operations.GetAccountDetailsRequestBuilder;
import pl.gsmservice.gateway.models.operations.GetAccountDetailsResponse;
import pl.gsmservice.gateway.models.operations.GetSubaccountDetailsRequest;
import pl.gsmservice.gateway.models.operations.GetSubaccountDetailsRequestBuilder;
import pl.gsmservice.gateway.models.operations.GetSubaccountDetailsResponse;
import pl.gsmservice.gateway.models.operations.SDKMethodInterfaces.*;
import pl.gsmservice.gateway.utils.BackoffStrategy;
import pl.gsmservice.gateway.utils.HTTPClient;
import pl.gsmservice.gateway.utils.HTTPRequest;
import pl.gsmservice.gateway.utils.Hook.AfterErrorContextImpl;
import pl.gsmservice.gateway.utils.Hook.AfterSuccessContextImpl;
import pl.gsmservice.gateway.utils.Hook.BeforeRequestContextImpl;
import pl.gsmservice.gateway.utils.Options;
import pl.gsmservice.gateway.utils.Retries.NonRetryableException;
import pl.gsmservice.gateway.utils.Retries;
import pl.gsmservice.gateway.utils.RetryConfig;
import pl.gsmservice.gateway.utils.Utils; 

public class Accounts implements
            MethodCallGetAccountDetails,
            MethodCallGetSubaccountDetails {

    private final SDKConfiguration sdkConfiguration;

    Accounts(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }


    /**
     * Get account details
     * 
 * <br>
 * <br>Get current account balance and other details of your account. You can check also account limit and if account is main one. Main accounts have unlimited privileges and using <a href="https://panel.gsmservice.pl">User Panel</a> you can create as many subaccounts as you need.
 * <br>
 * <br>This method doesn't take any parameters. As a successful result a details of current account you are logged in using an API Access Token will be returned.
     * @return The call builder
     */
    public GetAccountDetailsRequestBuilder get() {
        return new GetAccountDetailsRequestBuilder(this);
    }

    /**
     * Get account details
     * 
 * <br>
 * <br>Get current account balance and other details of your account. You can check also account limit and if account is main one. Main accounts have unlimited privileges and using <a href="https://panel.gsmservice.pl">User Panel</a> you can create as many subaccounts as you need.
 * <br>
 * <br>This method doesn't take any parameters. As a successful result a details of current account you are logged in using an API Access Token will be returned.
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public GetAccountDetailsResponse getDirect() throws Exception {
        return get(Optional.empty());
    }
    
    /**
     * Get account details
     * 
 * <br>
 * <br>Get current account balance and other details of your account. You can check also account limit and if account is main one. Main accounts have unlimited privileges and using <a href="https://panel.gsmservice.pl">User Panel</a> you can create as many subaccounts as you need.
 * <br>
 * <br>This method doesn't take any parameters. As a successful result a details of current account you are logged in using an API Access Token will be returned.
     * @param options additional options
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public GetAccountDetailsResponse get(
            Optional<Options> options) throws Exception {

        if (options.isPresent()) {
          options.get().validate(Arrays.asList(Options.Option.RETRY_CONFIG));
        }
        String _baseUrl = this.sdkConfiguration.serverUrl;
        String _url = Utils.generateURL(
                _baseUrl,
                "/account");
        
        HTTPRequest _req = new HTTPRequest(_url, "GET");
        _req.addHeader("Accept", "application/json")
            .addHeader("user-agent", 
                SDKConfiguration.USER_AGENT);

        Utils.configureSecurity(_req,  
                this.sdkConfiguration.securitySource.getSecurity());

        HTTPClient _client = this.sdkConfiguration.defaultClient;
        HTTPRequest _finalReq = _req;
        RetryConfig _retryConfig;
        if (options.isPresent() && options.get().retryConfig().isPresent()) {
            _retryConfig = options.get().retryConfig().get();
        } else if (this.sdkConfiguration.retryConfig.isPresent()) {
            _retryConfig = this.sdkConfiguration.retryConfig.get();
        } else {
            _retryConfig = RetryConfig.builder()
                .backoff(BackoffStrategy.builder()
                            .initialInterval(500, TimeUnit.MILLISECONDS)
                            .maxInterval(60000, TimeUnit.MILLISECONDS)
                            .baseFactor((double)(1.5))
                            .maxElapsedTime(3600000, TimeUnit.MILLISECONDS)
                            .retryConnectError(true)
                            .build())
                .build();
        }
        List<String> _statusCodes = new ArrayList<>();
        _statusCodes.add("5XX");
        Retries _retries = Retries.builder()
            .action(() -> {
                HttpRequest _r = null;
                try {
                    _r = sdkConfiguration.hooks()
                        .beforeRequest(
                            new BeforeRequestContextImpl(
                                "getAccountDetails", 
                                Optional.of(List.of()), 
                                sdkConfiguration.securitySource()),
                            _finalReq.build());
                } catch (Exception _e) {
                    throw new NonRetryableException(_e);
                }
                try {
                    return _client.send(_r);
                } catch (Exception _e) {
                    return sdkConfiguration.hooks()
                        .afterError(
                            new AfterErrorContextImpl(
                                "getAccountDetails",
                                 Optional.of(List.of()),
                                 sdkConfiguration.securitySource()), 
                            Optional.empty(),
                            Optional.of(_e));
                }
            })
            .retryConfig(_retryConfig)
            .statusCodes(_statusCodes)
            .build();
        HttpResponse<InputStream> _httpRes = sdkConfiguration.hooks()
                 .afterSuccess(
                     new AfterSuccessContextImpl(
                         "getAccountDetails", 
                         Optional.of(List.of()), 
                         sdkConfiguration.securitySource()),
                     _retries.run());
        String _contentType = _httpRes
            .headers()
            .firstValue("Content-Type")
            .orElse("application/octet-stream");
        GetAccountDetailsResponse.Builder _resBuilder = 
            GetAccountDetailsResponse
                .builder()
                .contentType(_contentType)
                .statusCode(_httpRes.statusCode())
                .rawResponse(_httpRes);

        GetAccountDetailsResponse _res = _resBuilder.build();
        
        if (Utils.statusCodeMatches(_httpRes.statusCode(), "200")) {
            if (Utils.contentTypeMatches(_contentType, "application/json")) {
                AccountResponse _out = Utils.mapper().readValue(
                    Utils.toUtf8AndClose(_httpRes.body()),
                    new TypeReference<AccountResponse>() {});
                _res.withAccountResponse(Optional.ofNullable(_out));
                return _res;
            } else {
                throw new SDKError(
                    _httpRes, 
                    _httpRes.statusCode(), 
                    "Unexpected content-type received: " + _contentType, 
                    Utils.extractByteArrayFromBody(_httpRes));
            }
        }
        if (Utils.statusCodeMatches(_httpRes.statusCode(), "401", "403", "4XX", "5XX")) {
            if (Utils.contentTypeMatches(_contentType, "application/problem+json")) {
                ErrorResponse _out = Utils.mapper().readValue(
                    Utils.toUtf8AndClose(_httpRes.body()),
                    new TypeReference<ErrorResponse>() {});
                throw _out;
            } else {
                throw new SDKError(
                    _httpRes, 
                    _httpRes.statusCode(), 
                    "Unexpected content-type received: " + _contentType, 
                    Utils.extractByteArrayFromBody(_httpRes));
            }
        }
        throw new SDKError(
            _httpRes, 
            _httpRes.statusCode(), 
            "Unexpected status code received: " + _httpRes.statusCode(), 
            Utils.extractByteArrayFromBody(_httpRes));
    }



    /**
     * Get subaccount details
     * 
 * <br>
 * <br>Check account balance and other details such subcredit balance of a subaccount. Subaccounts are additional users who can access your account services and the details. You can restrict access level and setup privileges to subaccounts using <a href="https://panel.gsmservice.pl">User Panel</a>.
 * <br>
 * <br>You should pass the subaccount user login to access its data. Please use builder style: 
 * <br>
     * <pre><code>
     * GetSubaccountDetailsResponse res = sdk.accounts().getSubaccount()
     *    .userLogin("some-login")
     *    .call();
     * </code></pre>
     * 
 * <br>As a successful result the details of subaccount with provided login will be returned.
     * @return The call builder
     */
    public GetSubaccountDetailsRequestBuilder getSubaccount() {
        return new GetSubaccountDetailsRequestBuilder(this);
    }

    /**
     * Get subaccount details
     * 
 * <br>
 * <br>Check account balance and other details such subcredit balance of a subaccount. Subaccounts are additional users who can access your account services and the details. You can restrict access level and setup privileges to subaccounts using <a href="https://panel.gsmservice.pl">User Panel</a>.
 * <br>
 * <br>You should pass the subaccount user login to access its data. Please use builder style: 
 * <br>
     * <pre><code>
     * GetSubaccountDetailsResponse res = sdk.accounts().getSubaccount()
     *    .userLogin("some-login")
     *    .call();
     * </code></pre>
     * 
 * <br>As a successful result the details of subaccount with provided login will be returned.
     * @param userLogin Login of the subaccount (user) to get the data for
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public GetSubaccountDetailsResponse getSubaccount(
            String userLogin) throws Exception {
        return getSubaccount(userLogin, Optional.empty());
    }
    
    /**
     * Get subaccount details
     * 
 * <br>
 * <br>Check account balance and other details such subcredit balance of a subaccount. Subaccounts are additional users who can access your account services and the details. You can restrict access level and setup privileges to subaccounts using <a href="https://panel.gsmservice.pl">User Panel</a>.
 * <br>
 * <br>You should pass the subaccount user login to access its data. Please use builder style: 
 * <br>
     * <pre><code>
     * GetSubaccountDetailsResponse res = sdk.accounts().getSubaccount()
     *    .userLogin("some-login")
     *    .call();
     * </code></pre>
     * 
 * <br>As a successful result the details of subaccount with provided login will be returned.
     * @param userLogin Login of the subaccount (user) to get the data for
     * @param options additional options
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public GetSubaccountDetailsResponse getSubaccount(
            String userLogin,
            Optional<Options> options) throws Exception {

        if (options.isPresent()) {
          options.get().validate(Arrays.asList(Options.Option.RETRY_CONFIG));
        }
        GetSubaccountDetailsRequest request =
            GetSubaccountDetailsRequest
                .builder()
                .userLogin(userLogin)
                .build();
        
        String _baseUrl = this.sdkConfiguration.serverUrl;
        String _url = Utils.generateURL(
                GetSubaccountDetailsRequest.class,
                _baseUrl,
                "/account/{user_login}",
                request, null);
        
        HTTPRequest _req = new HTTPRequest(_url, "GET");
        _req.addHeader("Accept", "application/json")
            .addHeader("user-agent", 
                SDKConfiguration.USER_AGENT);

        Utils.configureSecurity(_req,  
                this.sdkConfiguration.securitySource.getSecurity());

        HTTPClient _client = this.sdkConfiguration.defaultClient;
        HTTPRequest _finalReq = _req;
        RetryConfig _retryConfig;
        if (options.isPresent() && options.get().retryConfig().isPresent()) {
            _retryConfig = options.get().retryConfig().get();
        } else if (this.sdkConfiguration.retryConfig.isPresent()) {
            _retryConfig = this.sdkConfiguration.retryConfig.get();
        } else {
            _retryConfig = RetryConfig.builder()
                .backoff(BackoffStrategy.builder()
                            .initialInterval(500, TimeUnit.MILLISECONDS)
                            .maxInterval(60000, TimeUnit.MILLISECONDS)
                            .baseFactor((double)(1.5))
                            .maxElapsedTime(3600000, TimeUnit.MILLISECONDS)
                            .retryConnectError(true)
                            .build())
                .build();
        }
        List<String> _statusCodes = new ArrayList<>();
        _statusCodes.add("5XX");
        Retries _retries = Retries.builder()
            .action(() -> {
                HttpRequest _r = null;
                try {
                    _r = sdkConfiguration.hooks()
                        .beforeRequest(
                            new BeforeRequestContextImpl(
                                "getSubaccountDetails", 
                                Optional.of(List.of()), 
                                sdkConfiguration.securitySource()),
                            _finalReq.build());
                } catch (Exception _e) {
                    throw new NonRetryableException(_e);
                }
                try {
                    return _client.send(_r);
                } catch (Exception _e) {
                    return sdkConfiguration.hooks()
                        .afterError(
                            new AfterErrorContextImpl(
                                "getSubaccountDetails",
                                 Optional.of(List.of()),
                                 sdkConfiguration.securitySource()), 
                            Optional.empty(),
                            Optional.of(_e));
                }
            })
            .retryConfig(_retryConfig)
            .statusCodes(_statusCodes)
            .build();
        HttpResponse<InputStream> _httpRes = sdkConfiguration.hooks()
                 .afterSuccess(
                     new AfterSuccessContextImpl(
                         "getSubaccountDetails", 
                         Optional.of(List.of()), 
                         sdkConfiguration.securitySource()),
                     _retries.run());
        String _contentType = _httpRes
            .headers()
            .firstValue("Content-Type")
            .orElse("application/octet-stream");
        GetSubaccountDetailsResponse.Builder _resBuilder = 
            GetSubaccountDetailsResponse
                .builder()
                .contentType(_contentType)
                .statusCode(_httpRes.statusCode())
                .rawResponse(_httpRes);

        GetSubaccountDetailsResponse _res = _resBuilder.build();
        
        if (Utils.statusCodeMatches(_httpRes.statusCode(), "200")) {
            if (Utils.contentTypeMatches(_contentType, "application/json")) {
                AccountResponse _out = Utils.mapper().readValue(
                    Utils.toUtf8AndClose(_httpRes.body()),
                    new TypeReference<AccountResponse>() {});
                _res.withAccountResponse(Optional.ofNullable(_out));
                return _res;
            } else {
                throw new SDKError(
                    _httpRes, 
                    _httpRes.statusCode(), 
                    "Unexpected content-type received: " + _contentType, 
                    Utils.extractByteArrayFromBody(_httpRes));
            }
        }
        if (Utils.statusCodeMatches(_httpRes.statusCode(), "401", "403", "404", "4XX", "5XX")) {
            if (Utils.contentTypeMatches(_contentType, "application/problem+json")) {
                ErrorResponse _out = Utils.mapper().readValue(
                    Utils.toUtf8AndClose(_httpRes.body()),
                    new TypeReference<ErrorResponse>() {});
                throw _out;
            } else {
                throw new SDKError(
                    _httpRes, 
                    _httpRes.statusCode(), 
                    "Unexpected content-type received: " + _contentType, 
                    Utils.extractByteArrayFromBody(_httpRes));
            }
        }
        throw new SDKError(
            _httpRes, 
            _httpRes.statusCode(), 
            "Unexpected status code received: " + _httpRes.statusCode(), 
            Utils.extractByteArrayFromBody(_httpRes));
    }

}
