/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */

package pl.gsmservice.gateway.models.components;


import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.List;
import java.util.Objects;
import pl.gsmservice.gateway.utils.OneOfDeserializer;
import pl.gsmservice.gateway.utils.TypedObject;
import pl.gsmservice.gateway.utils.Utils.JsonShape;
import pl.gsmservice.gateway.utils.Utils.TypeReferenceWithShape;
import pl.gsmservice.gateway.utils.Utils;

/**
 * Recipients - The recipient number or multiple recipients numbers of single message. To set one recipient, please use <code>Recipients.of(String)</code> method simply passing to it a <code>string</code> with his phone number. To set multiple recipients, please use <code>Recipients.ofArrayOfStrings(List.of(String,...))</code> method passing to it <code>List&lt;string&gt;</code>. Optionally you can also set custom id (user identifier) for each message - use <code>Recipients.of(PhoneNumberWithCid)</code> method passing <code>PhoneNumberWithCid</code> object (in case of single recipient) or <code>Recipients.ofArrayOfPhoneNumberWithCids(Recipients.of(PhoneNumberWithCid,...))</code> method passing List&lt;PhoneNumberWithCid&gt; (in case of multiple recipients).
 */

@JsonDeserialize(using = Recipients._Deserializer.class)
public class Recipients {

    @JsonValue
    private TypedObject value;
    
    private Recipients(TypedObject value) {
        this.value = value;
    }

    public static Recipients of(String value) {
        Utils.checkNotNull(value, "value");
        return new Recipients(TypedObject.of(value, JsonShape.DEFAULT, new TypeReference<String>(){}));
    }

    public static Recipients of2(List<String> value) {
        Utils.checkNotNull(value, "value");
        return new Recipients(TypedObject.of(value, JsonShape.DEFAULT, new TypeReference<List<String>>(){}));
    }

    public static Recipients of(PhoneNumberWithCid value) {
        Utils.checkNotNull(value, "value");
        return new Recipients(TypedObject.of(value, JsonShape.DEFAULT, new TypeReference<PhoneNumberWithCid>(){}));
    }

    public static Recipients ofPhoneNumberWithCid(List<PhoneNumberWithCid> value) {
        Utils.checkNotNull(value, "value");
        return new Recipients(TypedObject.of(value, JsonShape.DEFAULT, new TypeReference<List<PhoneNumberWithCid>>(){}));
    }
    
    /**
     * Returns an instance of one of these types:
     * <ul>
     * <li>{@code java.lang.String}</li>
     * <li>{@code java.util.List<java.lang.String>}</li>
     * <li>{@code pl.gsmservice.gateway.models.components.PhoneNumberWithCid}</li>
     * <li>{@code java.util.List<pl.gsmservice.gateway.models.components.PhoneNumberWithCid>}</li>
     * </ul>
     * 
     * <p>Use {@code instanceof} to determine what type is returned. For example:
     * 
     * <pre>
     * if (obj.value() instanceof String) {
     *     String answer = (String) obj.value();
     *     System.out.println("answer=" + answer);
     * }
     * </pre>
     * 
     * @return value of oneOf type
     **/ 
    public java.lang.Object value() {
        return value.value();
    }    
    
    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        Recipients other = (Recipients) o;
        return Objects.deepEquals(this.value.value(), other.value.value()); 
    }
    
    @Override
    public int hashCode() {
        return Objects.hash(value.value());
    }
    
    @SuppressWarnings("serial")
    public static final class _Deserializer extends OneOfDeserializer<Recipients> {

        public _Deserializer() {
            super(Recipients.class, false,
                  TypeReferenceWithShape.of(new TypeReference<List<PhoneNumberWithCid>>() {}, JsonShape.DEFAULT),
                  TypeReferenceWithShape.of(new TypeReference<List<String>>() {}, JsonShape.DEFAULT),
                  TypeReferenceWithShape.of(new TypeReference<String>() {}, JsonShape.DEFAULT),
                  TypeReferenceWithShape.of(new TypeReference<PhoneNumberWithCid>() {}, JsonShape.DEFAULT));
        }
    }
    
    @Override
    public String toString() {
        return Utils.toString(Recipients.class,
                "value", value);
    }
 
}
