/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */

package pl.gsmservice.gateway.models.components;


import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.Boolean;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;
import pl.gsmservice.gateway.utils.Utils;

/**
 * Sender - An object with the properties of the message sender
 */

public class Sender {

    /**
     * Message sender name
     */
    @JsonProperty("sender")
    private String sender;

    /**
     * Sender name status
     */
    @JsonProperty("status")
    private String status;

    /**
     * Is the sender default?
     */
    @JsonProperty("is_default")
    private boolean isDefault;

    @JsonCreator
    public Sender(
            @JsonProperty("sender") String sender,
            @JsonProperty("status") String status,
            @JsonProperty("is_default") boolean isDefault) {
        Utils.checkNotNull(sender, "sender");
        Utils.checkNotNull(status, "status");
        Utils.checkNotNull(isDefault, "isDefault");
        this.sender = sender;
        this.status = status;
        this.isDefault = isDefault;
    }

    /**
     * Message sender name
     */
    @JsonIgnore
    public String sender() {
        return sender;
    }

    /**
     * Sender name status
     */
    @JsonIgnore
    public String status() {
        return status;
    }

    /**
     * Is the sender default?
     */
    @JsonIgnore
    public boolean isDefault() {
        return isDefault;
    }

    public final static Builder builder() {
        return new Builder();
    }

    /**
     * Message sender name
     */
    public Sender withSender(String sender) {
        Utils.checkNotNull(sender, "sender");
        this.sender = sender;
        return this;
    }

    /**
     * Sender name status
     */
    public Sender withStatus(String status) {
        Utils.checkNotNull(status, "status");
        this.status = status;
        return this;
    }

    /**
     * Is the sender default?
     */
    public Sender withIsDefault(boolean isDefault) {
        Utils.checkNotNull(isDefault, "isDefault");
        this.isDefault = isDefault;
        return this;
    }
    
    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        Sender other = (Sender) o;
        return 
            Objects.deepEquals(this.sender, other.sender) &&
            Objects.deepEquals(this.status, other.status) &&
            Objects.deepEquals(this.isDefault, other.isDefault);
    }
    
    @Override
    public int hashCode() {
        return Objects.hash(
            sender,
            status,
            isDefault);
    }
    
    @Override
    public String toString() {
        return Utils.toString(Sender.class,
                "sender", sender,
                "status", status,
                "isDefault", isDefault);
    }
    
    public final static class Builder {
 
        private String sender;
 
        private String status;
 
        private Boolean isDefault;  
        
        private Builder() {
          // force use of static builder() method
        }

        /**
         * Message sender name
         */
        public Builder sender(String sender) {
            Utils.checkNotNull(sender, "sender");
            this.sender = sender;
            return this;
        }

        /**
         * Sender name status
         */
        public Builder status(String status) {
            Utils.checkNotNull(status, "status");
            this.status = status;
            return this;
        }

        /**
         * Is the sender default?
         */
        public Builder isDefault(boolean isDefault) {
            Utils.checkNotNull(isDefault, "isDefault");
            this.isDefault = isDefault;
            return this;
        }
        
        public Sender build() {
            return new Sender(
                sender,
                status,
                isDefault);
        }
    }
}

