/*
 * Decompiled with CFR 0.152.
 */
package pl.gsmservice.gateway;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import pl.gsmservice.gateway.Accounts;
import pl.gsmservice.gateway.Common;
import pl.gsmservice.gateway.Incoming;
import pl.gsmservice.gateway.Outgoing;
import pl.gsmservice.gateway.SDKConfiguration;
import pl.gsmservice.gateway.SecuritySource;
import pl.gsmservice.gateway.Senders;
import pl.gsmservice.gateway.models.components.Security;
import pl.gsmservice.gateway.utils.HTTPClient;
import pl.gsmservice.gateway.utils.Hooks;
import pl.gsmservice.gateway.utils.RetryConfig;
import pl.gsmservice.gateway.utils.SpeakeasyHTTPClient;
import pl.gsmservice.gateway.utils.Utils;

public class Client {
    public static final Map<AvailableServers, String> SERVERS = new HashMap<AvailableServers, String>(){
        {
            this.put(AvailableServers.PROD, "https://api.gsmservice.pl/rest");
            this.put(AvailableServers.SANDBOX, "https://api.gsmservice.pl/rest-sandbox");
        }
    };
    private final Accounts accounts;
    private final Outgoing outgoing;
    private final Incoming incoming;
    private final Common common;
    private final Senders senders;
    private final SDKConfiguration sdkConfiguration;

    public Accounts accounts() {
        return this.accounts;
    }

    public Outgoing outgoing() {
        return this.outgoing;
    }

    public Incoming incoming() {
        return this.incoming;
    }

    public Common common() {
        return this.common;
    }

    public Senders senders() {
        return this.senders;
    }

    public static Builder builder() {
        return new Builder();
    }

    private Client(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
        this.accounts = new Accounts(sdkConfiguration);
        this.outgoing = new Outgoing(sdkConfiguration);
        this.incoming = new Incoming(sdkConfiguration);
        this.common = new Common(sdkConfiguration);
        this.senders = new Senders(sdkConfiguration);
        this.sdkConfiguration.initialize();
    }

    public static class Builder {
        private final SDKConfiguration sdkConfiguration = new SDKConfiguration();

        private Builder() {
        }

        public Builder client(HTTPClient client) {
            this.sdkConfiguration.defaultClient = client;
            return this;
        }

        public Builder bearer(String bearer) {
            this.sdkConfiguration.securitySource = SecuritySource.of(Security.builder().bearer(bearer).build());
            return this;
        }

        public Builder securitySource(SecuritySource securitySource) {
            this.sdkConfiguration.securitySource = securitySource;
            return this;
        }

        public Builder serverURL(String serverUrl) {
            this.sdkConfiguration.serverUrl = serverUrl;
            return this;
        }

        public Builder serverURL(String serverUrl, Map<String, String> params) {
            this.sdkConfiguration.serverUrl = Utils.templateUrl(serverUrl, params);
            return this;
        }

        public Builder server(AvailableServers server) {
            this.sdkConfiguration.server = server.toString();
            this.sdkConfiguration.serverUrl = SERVERS.get((Object)server);
            return this;
        }

        public Builder retryConfig(RetryConfig retryConfig) {
            this.sdkConfiguration.retryConfig = Optional.of(retryConfig);
            return this;
        }

        void _hooks(Hooks hooks) {
            this.sdkConfiguration.setHooks(hooks);
        }

        public Client build() {
            if (this.sdkConfiguration.defaultClient == null) {
                this.sdkConfiguration.defaultClient = new SpeakeasyHTTPClient();
            }
            if (this.sdkConfiguration.securitySource == null) {
                this.sdkConfiguration.securitySource = SecuritySource.of(null);
            }
            if (this.sdkConfiguration.serverUrl == null || this.sdkConfiguration.serverUrl.isBlank()) {
                this.sdkConfiguration.serverUrl = SERVERS.get((Object)AvailableServers.PROD);
                this.sdkConfiguration.server = AvailableServers.PROD.toString();
            }
            if (this.sdkConfiguration.serverUrl.endsWith("/")) {
                this.sdkConfiguration.serverUrl = this.sdkConfiguration.serverUrl.substring(0, this.sdkConfiguration.serverUrl.length() - 1);
            }
            return new Client(this.sdkConfiguration);
        }
    }

    public static enum AvailableServers {
        PROD("prod"),
        SANDBOX("sandbox");

        private final String server;

        private AvailableServers(String server) {
            this.server = server;
        }

        public String server() {
            return this.server;
        }
    }
}

