/*
 * Decompiled with CFR 0.152.
 */
package pl.gsmservice.gateway.models.operations;

import java.util.Optional;
import pl.gsmservice.gateway.models.components.SenderInput;
import pl.gsmservice.gateway.models.operations.AddSenderResponse;
import pl.gsmservice.gateway.models.operations.SDKMethodInterfaces;
import pl.gsmservice.gateway.utils.Options;
import pl.gsmservice.gateway.utils.RetryConfig;
import pl.gsmservice.gateway.utils.Utils;

public class AddSenderRequestBuilder {
    private SenderInput request;
    private Optional<RetryConfig> retryConfig = Optional.empty();
    private final SDKMethodInterfaces.MethodCallAddSender sdk;

    public AddSenderRequestBuilder(SDKMethodInterfaces.MethodCallAddSender sdk) {
        this.sdk = sdk;
    }

    public AddSenderRequestBuilder request(SenderInput request) {
        Utils.checkNotNull(request, "request");
        this.request = request;
        return this;
    }

    public AddSenderRequestBuilder retryConfig(RetryConfig retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = Optional.of(retryConfig);
        return this;
    }

    public AddSenderRequestBuilder retryConfig(Optional<RetryConfig> retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = retryConfig;
        return this;
    }

    public AddSenderResponse call() throws Exception {
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        return this.sdk.add(this.request, options);
    }
}

