/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */

package pl.gsmservice.gateway;

import com.fasterxml.jackson.core.type.TypeReference;
import java.io.InputStream;
import java.lang.Exception;
import java.lang.Object;
import java.lang.String;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import pl.gsmservice.gateway.models.components.Message;
import pl.gsmservice.gateway.models.components.Price;
import pl.gsmservice.gateway.models.errors.ErrorResponse;
import pl.gsmservice.gateway.models.errors.SDKError;
import pl.gsmservice.gateway.models.operations.GetMmsPriceRequestBody;
import pl.gsmservice.gateway.models.operations.GetMmsPriceRequestBuilder;
import pl.gsmservice.gateway.models.operations.GetMmsPriceResponse;
import pl.gsmservice.gateway.models.operations.SDKMethodInterfaces.*;
import pl.gsmservice.gateway.models.operations.SendMmsRequestBody;
import pl.gsmservice.gateway.models.operations.SendMmsRequestBuilder;
import pl.gsmservice.gateway.models.operations.SendMmsResponse;
import pl.gsmservice.gateway.utils.BackoffStrategy;
import pl.gsmservice.gateway.utils.HTTPClient;
import pl.gsmservice.gateway.utils.HTTPRequest;
import pl.gsmservice.gateway.utils.Hook.AfterErrorContextImpl;
import pl.gsmservice.gateway.utils.Hook.AfterSuccessContextImpl;
import pl.gsmservice.gateway.utils.Hook.BeforeRequestContextImpl;
import pl.gsmservice.gateway.utils.Options;
import pl.gsmservice.gateway.utils.Retries.NonRetryableException;
import pl.gsmservice.gateway.utils.Retries;
import pl.gsmservice.gateway.utils.RetryConfig;
import pl.gsmservice.gateway.utils.SerializedBody;
import pl.gsmservice.gateway.utils.Utils.JsonShape;
import pl.gsmservice.gateway.utils.Utils; 

public class Mms implements
            MethodCallGetMmsPrice,
            MethodCallSendMms {

    private final SDKConfiguration sdkConfiguration;

    Mms(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }


    /**
     * Check the price of MMS Messages
     * 
 * <br>
 * <br>Check the price of single or multiple MMS messages at the same time before sending them. You can pass a single <code>MmsMessage</code> object using <code>GetMmsPriceRequestBody.of(MmsMessage)</code> method (for single message) or <code>List&lt;SmsMessage&gt;</code> using <code>GetMmsPriceRequestBody.of(List.of(MmsMessage,...))</code> method (for multiple messages).
 * <br>
 * <br>Each <code>MmsMessage</code> object has several properties, describing message parameters such recipient phone number, content of the message, attachments, etc. Please use builder style:
 * <br>
     * <pre><code>
     * GetMmsPriceResponse res = sdk.outgoing().mms().getPrice()
     *    .request(req) // here pass GetMmsPriceRequestBody.of(...) object
     *    .call();
     * </code></pre>
     * 
 * <br>The method will accept maximum <strong>50</strong> messages in one call.
 * <br>
 * <br>As a successful result a <code>GetMmsPriceResponse</code> object will be returned with <code>prices</code> property of type <code>List&lt;Price&gt;</code> containing a <code>Price</code> objects, one object per each single message. You should check the <code>error</code> property of each <code>Price</code> object to make sure which messages were priced successfully and which finished with an error. Successfully priced messages will have <code>null</code> value of <code>error</code> property.
 * <br>
 * <br><code>GetMmsPriceResponse</code> object will include also <code>headers</code> property with <code>X-Success-Count</code> (a count of messages which were processed successfully) and <code>X-Error-Count</code> (count of messages which were rejected) elements.
     * @return The call builder
     */
    public GetMmsPriceRequestBuilder getPrice() {
        return new GetMmsPriceRequestBuilder(this);
    }

    /**
     * Check the price of MMS Messages
     * 
 * <br>
 * <br>Check the price of single or multiple MMS messages at the same time before sending them. You can pass a single <code>MmsMessage</code> object using <code>GetMmsPriceRequestBody.of(MmsMessage)</code> method (for single message) or <code>List&lt;SmsMessage&gt;</code> using <code>GetMmsPriceRequestBody.of(List.of(MmsMessage,...))</code> method (for multiple messages).
 * <br>
 * <br>Each <code>MmsMessage</code> object has several properties, describing message parameters such recipient phone number, content of the message, attachments, etc. Please use builder style:
 * <br>
     * <pre><code>
     * GetMmsPriceResponse res = sdk.outgoing().mms().getPrice()
     *    .request(req) // here pass GetMmsPriceRequestBody.of(...) object
     *    .call();
     * </code></pre>
     * 
 * <br>The method will accept maximum <strong>50</strong> messages in one call.
 * <br>
 * <br>As a successful result a <code>GetMmsPriceResponse</code> object will be returned with <code>prices</code> property of type <code>List&lt;Price&gt;</code> containing a <code>Price</code> objects, one object per each single message. You should check the <code>error</code> property of each <code>Price</code> object to make sure which messages were priced successfully and which finished with an error. Successfully priced messages will have <code>null</code> value of <code>error</code> property.
 * <br>
 * <br><code>GetMmsPriceResponse</code> object will include also <code>headers</code> property with <code>X-Success-Count</code> (a count of messages which were processed successfully) and <code>X-Error-Count</code> (count of messages which were rejected) elements.
     * @param request The request object containing all of the parameters for the API call.
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public GetMmsPriceResponse getPrice(
            GetMmsPriceRequestBody request) throws Exception {
        return getPrice(request, Optional.empty());
    }
    
    /**
     * Check the price of MMS Messages
     * 
 * <br>
 * <br>Check the price of single or multiple MMS messages at the same time before sending them. You can pass a single <code>MmsMessage</code> object using <code>GetMmsPriceRequestBody.of(MmsMessage)</code> method (for single message) or <code>List&lt;SmsMessage&gt;</code> using <code>GetMmsPriceRequestBody.of(List.of(MmsMessage,...))</code> method (for multiple messages).
 * <br>
 * <br>Each <code>MmsMessage</code> object has several properties, describing message parameters such recipient phone number, content of the message, attachments, etc. Please use builder style:
 * <br>
     * <pre><code>
     * GetMmsPriceResponse res = sdk.outgoing().mms().getPrice()
     *    .request(req) // here pass GetMmsPriceRequestBody.of(...) object
     *    .call();
     * </code></pre>
     * 
 * <br>The method will accept maximum <strong>50</strong> messages in one call.
 * <br>
 * <br>As a successful result a <code>GetMmsPriceResponse</code> object will be returned with <code>prices</code> property of type <code>List&lt;Price&gt;</code> containing a <code>Price</code> objects, one object per each single message. You should check the <code>error</code> property of each <code>Price</code> object to make sure which messages were priced successfully and which finished with an error. Successfully priced messages will have <code>null</code> value of <code>error</code> property.
 * <br>
 * <br><code>GetMmsPriceResponse</code> object will include also <code>headers</code> property with <code>X-Success-Count</code> (a count of messages which were processed successfully) and <code>X-Error-Count</code> (count of messages which were rejected) elements.
     * @param request The request object containing all of the parameters for the API call.
     * @param options additional options
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public GetMmsPriceResponse getPrice(
            GetMmsPriceRequestBody request,
            Optional<Options> options) throws Exception {

        if (options.isPresent()) {
          options.get().validate(Arrays.asList(Options.Option.RETRY_CONFIG));
        }
        String _baseUrl = this.sdkConfiguration.serverUrl;
        String _url = Utils.generateURL(
                _baseUrl,
                "/messages/mms/price");
        
        HTTPRequest _req = new HTTPRequest(_url, "POST");
        Object _convertedRequest = Utils.convertToShape(
                request, 
                JsonShape.DEFAULT,
                new TypeReference<GetMmsPriceRequestBody>() {});
        SerializedBody _serializedRequestBody = Utils.serializeRequestBody(
                _convertedRequest, 
                "request",
                "json",
                false);
        if (_serializedRequestBody == null) {
            throw new Exception("Request body is required");
        }
        _req.setBody(Optional.ofNullable(_serializedRequestBody));
        _req.addHeader("Accept", "application/json")
            .addHeader("user-agent", 
                SDKConfiguration.USER_AGENT);
        
        Optional<SecuritySource> _hookSecuritySource = this.sdkConfiguration.securitySource();
        Utils.configureSecurity(_req,  
                this.sdkConfiguration.securitySource.getSecurity());
        HTTPClient _client = this.sdkConfiguration.defaultClient;
        HTTPRequest _finalReq = _req;
        RetryConfig _retryConfig;
        if (options.isPresent() && options.get().retryConfig().isPresent()) {
            _retryConfig = options.get().retryConfig().get();
        } else if (this.sdkConfiguration.retryConfig.isPresent()) {
            _retryConfig = this.sdkConfiguration.retryConfig.get();
        } else {
            _retryConfig = RetryConfig.builder()
                .backoff(BackoffStrategy.builder()
                            .initialInterval(500, TimeUnit.MILLISECONDS)
                            .maxInterval(60000, TimeUnit.MILLISECONDS)
                            .baseFactor((double)(1.5))
                            .maxElapsedTime(3600000, TimeUnit.MILLISECONDS)
                            .retryConnectError(true)
                            .build())
                .build();
        }
        List<String> _statusCodes = new ArrayList<>();
        _statusCodes.add("5XX");
        Retries _retries = Retries.builder()
            .action(() -> {
                HttpRequest _r = null;
                try {
                    _r = sdkConfiguration.hooks()
                        .beforeRequest(
                            new BeforeRequestContextImpl(
                                "getMmsPrice", 
                                Optional.of(List.of()), 
                                _hookSecuritySource),
                            _finalReq.build());
                } catch (Exception _e) {
                    throw new NonRetryableException(_e);
                }
                try {
                    return _client.send(_r);
                } catch (Exception _e) {
                    return sdkConfiguration.hooks()
                        .afterError(
                            new AfterErrorContextImpl(
                                "getMmsPrice",
                                 Optional.of(List.of()),
                                 _hookSecuritySource), 
                            Optional.empty(),
                            Optional.of(_e));
                }
            })
            .retryConfig(_retryConfig)
            .statusCodes(_statusCodes)
            .build();
        HttpResponse<InputStream> _httpRes = sdkConfiguration.hooks()
                 .afterSuccess(
                     new AfterSuccessContextImpl(
                         "getMmsPrice", 
                         Optional.of(List.of()), 
                         _hookSecuritySource),
                     _retries.run());
        String _contentType = _httpRes
            .headers()
            .firstValue("Content-Type")
            .orElse("application/octet-stream");
        GetMmsPriceResponse.Builder _resBuilder = 
            GetMmsPriceResponse
                .builder()
                .contentType(_contentType)
                .statusCode(_httpRes.statusCode())
                .rawResponse(_httpRes);

        GetMmsPriceResponse _res = _resBuilder.build();
        
        if (Utils.statusCodeMatches(_httpRes.statusCode(), "200")) {
            _res.withHeaders(_httpRes.headers().map());
            if (Utils.contentTypeMatches(_contentType, "application/json")) {
                List<Price> _out = Utils.mapper().readValue(
                    Utils.toUtf8AndClose(_httpRes.body()),
                    new TypeReference<List<Price>>() {});
                _res.withPrices(Optional.ofNullable(_out));
                return _res;
            } else {
                throw new SDKError(
                    _httpRes, 
                    _httpRes.statusCode(), 
                    "Unexpected content-type received: " + _contentType, 
                    Utils.extractByteArrayFromBody(_httpRes));
            }
        }
        if (Utils.statusCodeMatches(_httpRes.statusCode(), "400", "401", "4XX")) {
            if (Utils.contentTypeMatches(_contentType, "application/problem+json")) {
                ErrorResponse _out = Utils.mapper().readValue(
                    Utils.toUtf8AndClose(_httpRes.body()),
                    new TypeReference<ErrorResponse>() {});
                throw _out;
            } else {
                throw new SDKError(
                    _httpRes, 
                    _httpRes.statusCode(), 
                    "Unexpected content-type received: " + _contentType, 
                    Utils.extractByteArrayFromBody(_httpRes));
            }
        }
        if (Utils.statusCodeMatches(_httpRes.statusCode(), "5XX")) {
            if (Utils.contentTypeMatches(_contentType, "application/problem+json")) {
                ErrorResponse _out = Utils.mapper().readValue(
                    Utils.toUtf8AndClose(_httpRes.body()),
                    new TypeReference<ErrorResponse>() {});
                throw _out;
            } else {
                throw new SDKError(
                    _httpRes, 
                    _httpRes.statusCode(), 
                    "Unexpected content-type received: " + _contentType, 
                    Utils.extractByteArrayFromBody(_httpRes));
            }
        }
        throw new SDKError(
            _httpRes, 
            _httpRes.statusCode(), 
            "Unexpected status code received: " + _httpRes.statusCode(), 
            Utils.extractByteArrayFromBody(_httpRes));
    }



    /**
     * Send MMS Messages
     * 
 * <br>
 * <br>Send single or multiple MMS messages at the same time. You can pass a single <code>MmsMessage</code> object using <code>SendMmsRequestBody.of(MmsMessage)</code> method (for single message) or <code>List&lt;MmsMessage&gt;</code> using <code>SendMmsRequestBody.of(List.of(MmsMessage,...))</code> method (for multiple messages). Each <code>MmsMessage</code> object has several properties, describing message parameters such recipient phone number, content of the message, attachments or scheduled sending date, etc. Please use builder style:
 * <br>
     * <pre><code>
     * SendMmsResponse res = sdk.outgoing().mms().send()
     *    .request(req) // here pass GetMmsPriceRequestBody.of(...) object
     *    .call();
     * </code></pre>
     * 
 * <br>This method will accept maximum 50 messages in one call.
 * <br>
 * <br>As a successful result a <code>SendMmsResponse</code> object will be returned with <code>messages</code> property of type List&lt;Message&gt; containing <code>Message</code> objects, one object per each single message. You should check the <code>statusCode</code> property of each <code>Message</code> object to make sure which messages were accepted by gateway (queued) and which were rejected. In case of rejection, <code>statusDescription</code> property will include a reason.
 * <br>
 * <br><code>SendMmsResponse</code> will also include <code>headers</code> property with <code>X-Success-Count</code> (a count of messages which were processed successfully), <code>X-Error-Count</code> (count of messages which were rejected) and <code>X-Sandbox</code> (if a request was made in Sandbox or Production system) elements.
     * @return The call builder
     */
    public SendMmsRequestBuilder send() {
        return new SendMmsRequestBuilder(this);
    }

    /**
     * Send MMS Messages
     * 
 * <br>
 * <br>Send single or multiple MMS messages at the same time. You can pass a single <code>MmsMessage</code> object using <code>SendMmsRequestBody.of(MmsMessage)</code> method (for single message) or <code>List&lt;MmsMessage&gt;</code> using <code>SendMmsRequestBody.of(List.of(MmsMessage,...))</code> method (for multiple messages). Each <code>MmsMessage</code> object has several properties, describing message parameters such recipient phone number, content of the message, attachments or scheduled sending date, etc. Please use builder style:
 * <br>
     * <pre><code>
     * SendMmsResponse res = sdk.outgoing().mms().send()
     *    .request(req) // here pass GetMmsPriceRequestBody.of(...) object
     *    .call();
     * </code></pre>
     * 
 * <br>This method will accept maximum 50 messages in one call.
 * <br>
 * <br>As a successful result a <code>SendMmsResponse</code> object will be returned with <code>messages</code> property of type List&lt;Message&gt; containing <code>Message</code> objects, one object per each single message. You should check the <code>statusCode</code> property of each <code>Message</code> object to make sure which messages were accepted by gateway (queued) and which were rejected. In case of rejection, <code>statusDescription</code> property will include a reason.
 * <br>
 * <br><code>SendMmsResponse</code> will also include <code>headers</code> property with <code>X-Success-Count</code> (a count of messages which were processed successfully), <code>X-Error-Count</code> (count of messages which were rejected) and <code>X-Sandbox</code> (if a request was made in Sandbox or Production system) elements.
     * @param request The request object containing all of the parameters for the API call.
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public SendMmsResponse send(
            SendMmsRequestBody request) throws Exception {
        return send(request, Optional.empty());
    }
    
    /**
     * Send MMS Messages
     * 
 * <br>
 * <br>Send single or multiple MMS messages at the same time. You can pass a single <code>MmsMessage</code> object using <code>SendMmsRequestBody.of(MmsMessage)</code> method (for single message) or <code>List&lt;MmsMessage&gt;</code> using <code>SendMmsRequestBody.of(List.of(MmsMessage,...))</code> method (for multiple messages). Each <code>MmsMessage</code> object has several properties, describing message parameters such recipient phone number, content of the message, attachments or scheduled sending date, etc. Please use builder style:
 * <br>
     * <pre><code>
     * SendMmsResponse res = sdk.outgoing().mms().send()
     *    .request(req) // here pass GetMmsPriceRequestBody.of(...) object
     *    .call();
     * </code></pre>
     * 
 * <br>This method will accept maximum 50 messages in one call.
 * <br>
 * <br>As a successful result a <code>SendMmsResponse</code> object will be returned with <code>messages</code> property of type List&lt;Message&gt; containing <code>Message</code> objects, one object per each single message. You should check the <code>statusCode</code> property of each <code>Message</code> object to make sure which messages were accepted by gateway (queued) and which were rejected. In case of rejection, <code>statusDescription</code> property will include a reason.
 * <br>
 * <br><code>SendMmsResponse</code> will also include <code>headers</code> property with <code>X-Success-Count</code> (a count of messages which were processed successfully), <code>X-Error-Count</code> (count of messages which were rejected) and <code>X-Sandbox</code> (if a request was made in Sandbox or Production system) elements.
     * @param request The request object containing all of the parameters for the API call.
     * @param options additional options
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public SendMmsResponse send(
            SendMmsRequestBody request,
            Optional<Options> options) throws Exception {

        if (options.isPresent()) {
          options.get().validate(Arrays.asList(Options.Option.RETRY_CONFIG));
        }
        String _baseUrl = this.sdkConfiguration.serverUrl;
        String _url = Utils.generateURL(
                _baseUrl,
                "/messages/mms");
        
        HTTPRequest _req = new HTTPRequest(_url, "POST");
        Object _convertedRequest = Utils.convertToShape(
                request, 
                JsonShape.DEFAULT,
                new TypeReference<SendMmsRequestBody>() {});
        SerializedBody _serializedRequestBody = Utils.serializeRequestBody(
                _convertedRequest, 
                "request",
                "json",
                false);
        if (_serializedRequestBody == null) {
            throw new Exception("Request body is required");
        }
        _req.setBody(Optional.ofNullable(_serializedRequestBody));
        _req.addHeader("Accept", "application/json")
            .addHeader("user-agent", 
                SDKConfiguration.USER_AGENT);
        
        Optional<SecuritySource> _hookSecuritySource = this.sdkConfiguration.securitySource();
        Utils.configureSecurity(_req,  
                this.sdkConfiguration.securitySource.getSecurity());
        HTTPClient _client = this.sdkConfiguration.defaultClient;
        HTTPRequest _finalReq = _req;
        RetryConfig _retryConfig;
        if (options.isPresent() && options.get().retryConfig().isPresent()) {
            _retryConfig = options.get().retryConfig().get();
        } else if (this.sdkConfiguration.retryConfig.isPresent()) {
            _retryConfig = this.sdkConfiguration.retryConfig.get();
        } else {
            _retryConfig = RetryConfig.builder()
                .backoff(BackoffStrategy.builder()
                            .initialInterval(500, TimeUnit.MILLISECONDS)
                            .maxInterval(60000, TimeUnit.MILLISECONDS)
                            .baseFactor((double)(1.5))
                            .maxElapsedTime(3600000, TimeUnit.MILLISECONDS)
                            .retryConnectError(true)
                            .build())
                .build();
        }
        List<String> _statusCodes = new ArrayList<>();
        _statusCodes.add("5XX");
        Retries _retries = Retries.builder()
            .action(() -> {
                HttpRequest _r = null;
                try {
                    _r = sdkConfiguration.hooks()
                        .beforeRequest(
                            new BeforeRequestContextImpl(
                                "sendMms", 
                                Optional.of(List.of()), 
                                _hookSecuritySource),
                            _finalReq.build());
                } catch (Exception _e) {
                    throw new NonRetryableException(_e);
                }
                try {
                    return _client.send(_r);
                } catch (Exception _e) {
                    return sdkConfiguration.hooks()
                        .afterError(
                            new AfterErrorContextImpl(
                                "sendMms",
                                 Optional.of(List.of()),
                                 _hookSecuritySource), 
                            Optional.empty(),
                            Optional.of(_e));
                }
            })
            .retryConfig(_retryConfig)
            .statusCodes(_statusCodes)
            .build();
        HttpResponse<InputStream> _httpRes = sdkConfiguration.hooks()
                 .afterSuccess(
                     new AfterSuccessContextImpl(
                         "sendMms", 
                         Optional.of(List.of()), 
                         _hookSecuritySource),
                     _retries.run());
        String _contentType = _httpRes
            .headers()
            .firstValue("Content-Type")
            .orElse("application/octet-stream");
        SendMmsResponse.Builder _resBuilder = 
            SendMmsResponse
                .builder()
                .contentType(_contentType)
                .statusCode(_httpRes.statusCode())
                .rawResponse(_httpRes);

        SendMmsResponse _res = _resBuilder.build();
        
        if (Utils.statusCodeMatches(_httpRes.statusCode(), "200")) {
            _res.withHeaders(_httpRes.headers().map());
            if (Utils.contentTypeMatches(_contentType, "application/json")) {
                List<Message> _out = Utils.mapper().readValue(
                    Utils.toUtf8AndClose(_httpRes.body()),
                    new TypeReference<List<Message>>() {});
                _res.withMessages(Optional.ofNullable(_out));
                return _res;
            } else {
                throw new SDKError(
                    _httpRes, 
                    _httpRes.statusCode(), 
                    "Unexpected content-type received: " + _contentType, 
                    Utils.extractByteArrayFromBody(_httpRes));
            }
        }
        if (Utils.statusCodeMatches(_httpRes.statusCode(), "400", "401", "403", "4XX")) {
            if (Utils.contentTypeMatches(_contentType, "application/problem+json")) {
                ErrorResponse _out = Utils.mapper().readValue(
                    Utils.toUtf8AndClose(_httpRes.body()),
                    new TypeReference<ErrorResponse>() {});
                throw _out;
            } else {
                throw new SDKError(
                    _httpRes, 
                    _httpRes.statusCode(), 
                    "Unexpected content-type received: " + _contentType, 
                    Utils.extractByteArrayFromBody(_httpRes));
            }
        }
        if (Utils.statusCodeMatches(_httpRes.statusCode(), "5XX")) {
            if (Utils.contentTypeMatches(_contentType, "application/problem+json")) {
                ErrorResponse _out = Utils.mapper().readValue(
                    Utils.toUtf8AndClose(_httpRes.body()),
                    new TypeReference<ErrorResponse>() {});
                throw _out;
            } else {
                throw new SDKError(
                    _httpRes, 
                    _httpRes.statusCode(), 
                    "Unexpected content-type received: " + _contentType, 
                    Utils.extractByteArrayFromBody(_httpRes));
            }
        }
        throw new SDKError(
            _httpRes, 
            _httpRes.statusCode(), 
            "Unexpected status code received: " + _httpRes.statusCode(), 
            Utils.extractByteArrayFromBody(_httpRes));
    }

}
