/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */

package pl.gsmservice.gateway;

import com.fasterxml.jackson.core.type.TypeReference;
import java.io.InputStream;
import java.lang.Exception;
import java.lang.Long;
import java.lang.String;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import pl.gsmservice.gateway.models.components.CancelledMessage;
import pl.gsmservice.gateway.models.components.Message;
import pl.gsmservice.gateway.models.errors.ErrorResponse;
import pl.gsmservice.gateway.models.errors.SDKError;
import pl.gsmservice.gateway.models.operations.CancelMessagesRequest;
import pl.gsmservice.gateway.models.operations.CancelMessagesRequestBuilder;
import pl.gsmservice.gateway.models.operations.CancelMessagesResponse;
import pl.gsmservice.gateway.models.operations.GetMessagesRequest;
import pl.gsmservice.gateway.models.operations.GetMessagesRequestBuilder;
import pl.gsmservice.gateway.models.operations.GetMessagesResponse;
import pl.gsmservice.gateway.models.operations.ListMessagesRequest;
import pl.gsmservice.gateway.models.operations.ListMessagesRequestBuilder;
import pl.gsmservice.gateway.models.operations.ListMessagesResponse;
import pl.gsmservice.gateway.models.operations.SDKMethodInterfaces.*;
import pl.gsmservice.gateway.utils.BackoffStrategy;
import pl.gsmservice.gateway.utils.HTTPClient;
import pl.gsmservice.gateway.utils.HTTPRequest;
import pl.gsmservice.gateway.utils.Hook.AfterErrorContextImpl;
import pl.gsmservice.gateway.utils.Hook.AfterSuccessContextImpl;
import pl.gsmservice.gateway.utils.Hook.BeforeRequestContextImpl;
import pl.gsmservice.gateway.utils.Options;
import pl.gsmservice.gateway.utils.Retries.NonRetryableException;
import pl.gsmservice.gateway.utils.Retries;
import pl.gsmservice.gateway.utils.RetryConfig;
import pl.gsmservice.gateway.utils.Utils; 

public class Outgoing implements
            MethodCallGetMessages,
            MethodCallCancelMessages,
            MethodCallListMessages {

    private final SDKConfiguration sdkConfiguration;
    private final Mms mms;
    private final Sms sms;

    Outgoing(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
        this.mms = new Mms(this.sdkConfiguration);
        this.sms = new Sms(this.sdkConfiguration);
    }

    public final Mms mms() {
        return mms;
    }

    public final Sms sms() {
        return sms;
    }


    /**
     * Get the messages details and status by IDs
     * 
 * <br>
 * <br>Check the current status and details of one or more messages using their <code>ids</code>. You should pass the <code>ListOf()</code> containing unique message <em>IDs</em> (<code>Long</code> type) which details you want to fetch. Please use builder style:
 * <br>
     * <pre><code>
     * GetMessagesResponse res = sdk.outgoing().getByIds()
     *    .ids(List.of(43456L))
     *    .call();
     * </code></pre>
     * 
 * <br>This method will accept maximum 50 identifiers in one call.
 * <br>
 * <br>As a successful result a <code>GetMessagesResponse</code> object will be returned containing <code>messages</code> property of type <code>List&lt;Message&gt;</code> with <code>Message</code> objects, each object per single found message. <code>GetMessagesResponse</code> object will also contain <code>headers</code> property where you can find <code>X-Success-Count</code> (a count of messages which were found and returned correctly) and <code>X-Error-Count</code> (count of messages which were not found) elements.
     * @return The call builder
     */
    public GetMessagesRequestBuilder getByIds() {
        return new GetMessagesRequestBuilder(this);
    }

    /**
     * Get the messages details and status by IDs
     * 
 * <br>
 * <br>Check the current status and details of one or more messages using their <code>ids</code>. You should pass the <code>ListOf()</code> containing unique message <em>IDs</em> (<code>Long</code> type) which details you want to fetch. Please use builder style:
 * <br>
     * <pre><code>
     * GetMessagesResponse res = sdk.outgoing().getByIds()
     *    .ids(List.of(43456L))
     *    .call();
     * </code></pre>
     * 
 * <br>This method will accept maximum 50 identifiers in one call.
 * <br>
 * <br>As a successful result a <code>GetMessagesResponse</code> object will be returned containing <code>messages</code> property of type <code>List&lt;Message&gt;</code> with <code>Message</code> objects, each object per single found message. <code>GetMessagesResponse</code> object will also contain <code>headers</code> property where you can find <code>X-Success-Count</code> (a count of messages which were found and returned correctly) and <code>X-Error-Count</code> (count of messages which were not found) elements.
     * @param ids List<Long> of Message IDs assigned by the system. The system will accept a maximum of 50 identifiers in one call.
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public GetMessagesResponse getByIds(
            List<Long> ids) throws Exception {
        return getByIds(ids, Optional.empty());
    }
    
    /**
     * Get the messages details and status by IDs
     * 
 * <br>
 * <br>Check the current status and details of one or more messages using their <code>ids</code>. You should pass the <code>ListOf()</code> containing unique message <em>IDs</em> (<code>Long</code> type) which details you want to fetch. Please use builder style:
 * <br>
     * <pre><code>
     * GetMessagesResponse res = sdk.outgoing().getByIds()
     *    .ids(List.of(43456L))
     *    .call();
     * </code></pre>
     * 
 * <br>This method will accept maximum 50 identifiers in one call.
 * <br>
 * <br>As a successful result a <code>GetMessagesResponse</code> object will be returned containing <code>messages</code> property of type <code>List&lt;Message&gt;</code> with <code>Message</code> objects, each object per single found message. <code>GetMessagesResponse</code> object will also contain <code>headers</code> property where you can find <code>X-Success-Count</code> (a count of messages which were found and returned correctly) and <code>X-Error-Count</code> (count of messages which were not found) elements.
     * @param ids List<Long> of Message IDs assigned by the system. The system will accept a maximum of 50 identifiers in one call.
     * @param options additional options
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public GetMessagesResponse getByIds(
            List<Long> ids,
            Optional<Options> options) throws Exception {

        if (options.isPresent()) {
          options.get().validate(Arrays.asList(Options.Option.RETRY_CONFIG));
        }
        GetMessagesRequest request =
            GetMessagesRequest
                .builder()
                .ids(ids)
                .build();
        
        String _baseUrl = this.sdkConfiguration.serverUrl;
        String _url = Utils.generateURL(
                GetMessagesRequest.class,
                _baseUrl,
                "/messages/{ids}",
                request, null);
        
        HTTPRequest _req = new HTTPRequest(_url, "GET");
        _req.addHeader("Accept", "application/json")
            .addHeader("user-agent", 
                SDKConfiguration.USER_AGENT);
        
        Optional<SecuritySource> _hookSecuritySource = this.sdkConfiguration.securitySource();
        Utils.configureSecurity(_req,  
                this.sdkConfiguration.securitySource.getSecurity());
        HTTPClient _client = this.sdkConfiguration.defaultClient;
        HTTPRequest _finalReq = _req;
        RetryConfig _retryConfig;
        if (options.isPresent() && options.get().retryConfig().isPresent()) {
            _retryConfig = options.get().retryConfig().get();
        } else if (this.sdkConfiguration.retryConfig.isPresent()) {
            _retryConfig = this.sdkConfiguration.retryConfig.get();
        } else {
            _retryConfig = RetryConfig.builder()
                .backoff(BackoffStrategy.builder()
                            .initialInterval(500, TimeUnit.MILLISECONDS)
                            .maxInterval(60000, TimeUnit.MILLISECONDS)
                            .baseFactor((double)(1.5))
                            .maxElapsedTime(3600000, TimeUnit.MILLISECONDS)
                            .retryConnectError(true)
                            .build())
                .build();
        }
        List<String> _statusCodes = new ArrayList<>();
        _statusCodes.add("5XX");
        Retries _retries = Retries.builder()
            .action(() -> {
                HttpRequest _r = null;
                try {
                    _r = sdkConfiguration.hooks()
                        .beforeRequest(
                            new BeforeRequestContextImpl(
                                "getMessages", 
                                Optional.of(List.of()), 
                                _hookSecuritySource),
                            _finalReq.build());
                } catch (Exception _e) {
                    throw new NonRetryableException(_e);
                }
                try {
                    return _client.send(_r);
                } catch (Exception _e) {
                    return sdkConfiguration.hooks()
                        .afterError(
                            new AfterErrorContextImpl(
                                "getMessages",
                                 Optional.of(List.of()),
                                 _hookSecuritySource), 
                            Optional.empty(),
                            Optional.of(_e));
                }
            })
            .retryConfig(_retryConfig)
            .statusCodes(_statusCodes)
            .build();
        HttpResponse<InputStream> _httpRes = sdkConfiguration.hooks()
                 .afterSuccess(
                     new AfterSuccessContextImpl(
                         "getMessages", 
                         Optional.of(List.of()), 
                         _hookSecuritySource),
                     _retries.run());
        String _contentType = _httpRes
            .headers()
            .firstValue("Content-Type")
            .orElse("application/octet-stream");
        GetMessagesResponse.Builder _resBuilder = 
            GetMessagesResponse
                .builder()
                .contentType(_contentType)
                .statusCode(_httpRes.statusCode())
                .rawResponse(_httpRes);

        GetMessagesResponse _res = _resBuilder.build();
        
        if (Utils.statusCodeMatches(_httpRes.statusCode(), "200")) {
            _res.withHeaders(_httpRes.headers().map());
            if (Utils.contentTypeMatches(_contentType, "application/json")) {
                List<Message> _out = Utils.mapper().readValue(
                    Utils.toUtf8AndClose(_httpRes.body()),
                    new TypeReference<List<Message>>() {});
                _res.withMessages(Optional.ofNullable(_out));
                return _res;
            } else {
                throw new SDKError(
                    _httpRes, 
                    _httpRes.statusCode(), 
                    "Unexpected content-type received: " + _contentType, 
                    Utils.extractByteArrayFromBody(_httpRes));
            }
        }
        if (Utils.statusCodeMatches(_httpRes.statusCode(), "400", "401", "403", "404", "4XX")) {
            if (Utils.contentTypeMatches(_contentType, "application/problem+json")) {
                ErrorResponse _out = Utils.mapper().readValue(
                    Utils.toUtf8AndClose(_httpRes.body()),
                    new TypeReference<ErrorResponse>() {});
                throw _out;
            } else {
                throw new SDKError(
                    _httpRes, 
                    _httpRes.statusCode(), 
                    "Unexpected content-type received: " + _contentType, 
                    Utils.extractByteArrayFromBody(_httpRes));
            }
        }
        if (Utils.statusCodeMatches(_httpRes.statusCode(), "5XX")) {
            if (Utils.contentTypeMatches(_contentType, "application/problem+json")) {
                ErrorResponse _out = Utils.mapper().readValue(
                    Utils.toUtf8AndClose(_httpRes.body()),
                    new TypeReference<ErrorResponse>() {});
                throw _out;
            } else {
                throw new SDKError(
                    _httpRes, 
                    _httpRes.statusCode(), 
                    "Unexpected content-type received: " + _contentType, 
                    Utils.extractByteArrayFromBody(_httpRes));
            }
        }
        throw new SDKError(
            _httpRes, 
            _httpRes.statusCode(), 
            "Unexpected status code received: " + _httpRes.statusCode(), 
            Utils.extractByteArrayFromBody(_httpRes));
    }



    /**
     * Cancel a scheduled messages
     * 
 * <br>
 * <br>Cancel messages using their <code>ids</code> which were scheduled to be sent at a specific time. You have to pass a <code>ListOf()</code> containing the unique message IDs (<code>Long</code> type), which were returned after sending a message. Please use builder style:
 * <br>
     * <pre><code>
     * CancelMessagesResponse res2 = sdk.outgoing().cancelScheduled()
     *    .ids(List.of(43456L))
     *    .call();
     * </code></pre>
     * 
 * <br>This method will accept maximum 50 identifiers in one call. You can cancel only messages with <em>SCHEDULED</em> status.
     *  
     * As a successful result a <code>CancelMessagesResponse</code> object will be returned, with <code>cancelledMessages</code> property of type <code>List&lt;CancelledMessage&gt;</code> containing <code>CancelledMessage</code> objects. The <code>status</code> property of each <code>CancelledMessage</code> object will contain a status code of operation - <code>204</code> if a particular message was cancelled successfully and other code if an error occured.
     *  
     * <code>CancelMessagesResponse</code> object will also contain <code>headers</code> property where you can find <code>X-Success-Count</code> (a count of messages which were cancelled successfully), <code>X-Error-Count</code> (count of messages which were not cancelled) and <code>X-Sandbox</code> (if a request was made in Sandbox or Production system) elements.
     * @return The call builder
     */
    public CancelMessagesRequestBuilder cancelScheduled() {
        return new CancelMessagesRequestBuilder(this);
    }

    /**
     * Cancel a scheduled messages
     * 
 * <br>
 * <br>Cancel messages using their <code>ids</code> which were scheduled to be sent at a specific time. You have to pass a <code>ListOf()</code> containing the unique message IDs (<code>Long</code> type), which were returned after sending a message. Please use builder style:
 * <br>
     * <pre><code>
     * CancelMessagesResponse res2 = sdk.outgoing().cancelScheduled()
     *    .ids(List.of(43456L))
     *    .call();
     * </code></pre>
     * 
 * <br>This method will accept maximum 50 identifiers in one call. You can cancel only messages with <em>SCHEDULED</em> status.
     *  
     * As a successful result a <code>CancelMessagesResponse</code> object will be returned, with <code>cancelledMessages</code> property of type <code>List&lt;CancelledMessage&gt;</code> containing <code>CancelledMessage</code> objects. The <code>status</code> property of each <code>CancelledMessage</code> object will contain a status code of operation - <code>204</code> if a particular message was cancelled successfully and other code if an error occured.
     *  
     * <code>CancelMessagesResponse</code> object will also contain <code>headers</code> property where you can find <code>X-Success-Count</code> (a count of messages which were cancelled successfully), <code>X-Error-Count</code> (count of messages which were not cancelled) and <code>X-Sandbox</code> (if a request was made in Sandbox or Production system) elements.
     * @param ids List<Long> of Message IDs assigned by the system. The system will accept a maximum of 50 identifiers in one call.
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public CancelMessagesResponse cancelScheduled(
            List<Long> ids) throws Exception {
        return cancelScheduled(ids, Optional.empty());
    }
    
    /**
     * Cancel a scheduled messages
     * 
 * <br>
 * <br>Cancel messages using their <code>ids</code> which were scheduled to be sent at a specific time. You have to pass a <code>ListOf()</code> containing the unique message IDs (<code>Long</code> type), which were returned after sending a message. Please use builder style:
 * <br>
     * <pre><code>
     * CancelMessagesResponse res2 = sdk.outgoing().cancelScheduled()
     *    .ids(List.of(43456L))
     *    .call();
     * </code></pre>
     * 
 * <br>This method will accept maximum 50 identifiers in one call. You can cancel only messages with <em>SCHEDULED</em> status.
     *  
     * As a successful result a <code>CancelMessagesResponse</code> object will be returned, with <code>cancelledMessages</code> property of type <code>List&lt;CancelledMessage&gt;</code> containing <code>CancelledMessage</code> objects. The <code>status</code> property of each <code>CancelledMessage</code> object will contain a status code of operation - <code>204</code> if a particular message was cancelled successfully and other code if an error occured.
     *  
     * <code>CancelMessagesResponse</code> object will also contain <code>headers</code> property where you can find <code>X-Success-Count</code> (a count of messages which were cancelled successfully), <code>X-Error-Count</code> (count of messages which were not cancelled) and <code>X-Sandbox</code> (if a request was made in Sandbox or Production system) elements.
     * @param ids List<Long> of Message IDs assigned by the system. The system will accept a maximum of 50 identifiers in one call.
     * @param options additional options
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public CancelMessagesResponse cancelScheduled(
            List<Long> ids,
            Optional<Options> options) throws Exception {

        if (options.isPresent()) {
          options.get().validate(Arrays.asList(Options.Option.RETRY_CONFIG));
        }
        CancelMessagesRequest request =
            CancelMessagesRequest
                .builder()
                .ids(ids)
                .build();
        
        String _baseUrl = this.sdkConfiguration.serverUrl;
        String _url = Utils.generateURL(
                CancelMessagesRequest.class,
                _baseUrl,
                "/messages/{ids}",
                request, null);
        
        HTTPRequest _req = new HTTPRequest(_url, "DELETE");
        _req.addHeader("Accept", "application/json")
            .addHeader("user-agent", 
                SDKConfiguration.USER_AGENT);
        
        Optional<SecuritySource> _hookSecuritySource = this.sdkConfiguration.securitySource();
        Utils.configureSecurity(_req,  
                this.sdkConfiguration.securitySource.getSecurity());
        HTTPClient _client = this.sdkConfiguration.defaultClient;
        HTTPRequest _finalReq = _req;
        RetryConfig _retryConfig;
        if (options.isPresent() && options.get().retryConfig().isPresent()) {
            _retryConfig = options.get().retryConfig().get();
        } else if (this.sdkConfiguration.retryConfig.isPresent()) {
            _retryConfig = this.sdkConfiguration.retryConfig.get();
        } else {
            _retryConfig = RetryConfig.builder()
                .backoff(BackoffStrategy.builder()
                            .initialInterval(500, TimeUnit.MILLISECONDS)
                            .maxInterval(60000, TimeUnit.MILLISECONDS)
                            .baseFactor((double)(1.5))
                            .maxElapsedTime(3600000, TimeUnit.MILLISECONDS)
                            .retryConnectError(true)
                            .build())
                .build();
        }
        List<String> _statusCodes = new ArrayList<>();
        _statusCodes.add("5XX");
        Retries _retries = Retries.builder()
            .action(() -> {
                HttpRequest _r = null;
                try {
                    _r = sdkConfiguration.hooks()
                        .beforeRequest(
                            new BeforeRequestContextImpl(
                                "cancelMessages", 
                                Optional.of(List.of()), 
                                _hookSecuritySource),
                            _finalReq.build());
                } catch (Exception _e) {
                    throw new NonRetryableException(_e);
                }
                try {
                    return _client.send(_r);
                } catch (Exception _e) {
                    return sdkConfiguration.hooks()
                        .afterError(
                            new AfterErrorContextImpl(
                                "cancelMessages",
                                 Optional.of(List.of()),
                                 _hookSecuritySource), 
                            Optional.empty(),
                            Optional.of(_e));
                }
            })
            .retryConfig(_retryConfig)
            .statusCodes(_statusCodes)
            .build();
        HttpResponse<InputStream> _httpRes = sdkConfiguration.hooks()
                 .afterSuccess(
                     new AfterSuccessContextImpl(
                         "cancelMessages", 
                         Optional.of(List.of()), 
                         _hookSecuritySource),
                     _retries.run());
        String _contentType = _httpRes
            .headers()
            .firstValue("Content-Type")
            .orElse("application/octet-stream");
        CancelMessagesResponse.Builder _resBuilder = 
            CancelMessagesResponse
                .builder()
                .contentType(_contentType)
                .statusCode(_httpRes.statusCode())
                .rawResponse(_httpRes);

        CancelMessagesResponse _res = _resBuilder.build();
        
        if (Utils.statusCodeMatches(_httpRes.statusCode(), "200")) {
            _res.withHeaders(_httpRes.headers().map());
            if (Utils.contentTypeMatches(_contentType, "application/json")) {
                List<CancelledMessage> _out = Utils.mapper().readValue(
                    Utils.toUtf8AndClose(_httpRes.body()),
                    new TypeReference<List<CancelledMessage>>() {});
                _res.withCancelledMessages(Optional.ofNullable(_out));
                return _res;
            } else {
                throw new SDKError(
                    _httpRes, 
                    _httpRes.statusCode(), 
                    "Unexpected content-type received: " + _contentType, 
                    Utils.extractByteArrayFromBody(_httpRes));
            }
        }
        if (Utils.statusCodeMatches(_httpRes.statusCode(), "400", "401", "403", "404", "4XX")) {
            if (Utils.contentTypeMatches(_contentType, "application/problem+json")) {
                ErrorResponse _out = Utils.mapper().readValue(
                    Utils.toUtf8AndClose(_httpRes.body()),
                    new TypeReference<ErrorResponse>() {});
                throw _out;
            } else {
                throw new SDKError(
                    _httpRes, 
                    _httpRes.statusCode(), 
                    "Unexpected content-type received: " + _contentType, 
                    Utils.extractByteArrayFromBody(_httpRes));
            }
        }
        if (Utils.statusCodeMatches(_httpRes.statusCode(), "5XX")) {
            if (Utils.contentTypeMatches(_contentType, "application/problem+json")) {
                ErrorResponse _out = Utils.mapper().readValue(
                    Utils.toUtf8AndClose(_httpRes.body()),
                    new TypeReference<ErrorResponse>() {});
                throw _out;
            } else {
                throw new SDKError(
                    _httpRes, 
                    _httpRes.statusCode(), 
                    "Unexpected content-type received: " + _contentType, 
                    Utils.extractByteArrayFromBody(_httpRes));
            }
        }
        throw new SDKError(
            _httpRes, 
            _httpRes.statusCode(), 
            "Unexpected status code received: " + _httpRes.statusCode(), 
            Utils.extractByteArrayFromBody(_httpRes));
    }



    /**
     * Lists the history of sent messages
     * 
 * <br>
 * <br>Get the details and current status of all of sent messages from your account message history. This method supports pagination so you have to pass a <code>page</code> (number of page with messages which you want to access, <code>Long</code> type) and a <code>limit</code> (max of messages per page, <code>Long</code> type) parameters. Please use builder style:
 * <br>
     * <pre><code>
     * ListMessagesResponse res = sdk.outgoing().list()
     *    .page(1L)
     *    .limit(10L)
     *    .call();
     * </code></pre>
     * 
 * <br>Messages are fetched from the latest one. This method will accept maximum value of <strong>50</strong> as <code>limit</code> parameter value.
 * <br>
 * <br>As a successful result a <code>ListMessagesResponse</code> object will be returned containing <code>messages</code> property of type <code>List&lt;Message&gt;</code> with a <code>Message</code> objects, each object per single message. <code>ListMessagesResponse</code> will also contain <code>headers</code> property where you can find <code>X-Total-Results</code> (a total count of all messages which are available in history on your account), <code>X-Total-Pages</code> (a total number of all pages with results), <code>X-Current-Page</code> (A current page number) and <code>X-Limit</code> (messages count per single page) elements.
     * @return The call builder
     */
    public ListMessagesRequestBuilder list() {
        return new ListMessagesRequestBuilder(this);
    }

    /**
     * Lists the history of sent messages
     * 
 * <br>
 * <br>Get the details and current status of all of sent messages from your account message history. This method supports pagination so you have to pass a <code>page</code> (number of page with messages which you want to access, <code>Long</code> type) and a <code>limit</code> (max of messages per page, <code>Long</code> type) parameters. Please use builder style:
 * <br>
     * <pre><code>
     * ListMessagesResponse res = sdk.outgoing().list()
     *    .page(1L)
     *    .limit(10L)
     *    .call();
     * </code></pre>
     * 
 * <br>Messages are fetched from the latest one. This method will accept maximum value of <strong>50</strong> as <code>limit</code> parameter value.
 * <br>
 * <br>As a successful result a <code>ListMessagesResponse</code> object will be returned containing <code>messages</code> property of type <code>List&lt;Message&gt;</code> with a <code>Message</code> objects, each object per single message. <code>ListMessagesResponse</code> will also contain <code>headers</code> property where you can find <code>X-Total-Results</code> (a total count of all messages which are available in history on your account), <code>X-Total-Pages</code> (a total number of all pages with results), <code>X-Current-Page</code> (A current page number) and <code>X-Limit</code> (messages count per single page) elements.
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public ListMessagesResponse listDirect() throws Exception {
        return list(Optional.empty(), Optional.empty(), Optional.empty());
    }
    
    /**
     * Lists the history of sent messages
     * 
 * <br>
 * <br>Get the details and current status of all of sent messages from your account message history. This method supports pagination so you have to pass a <code>page</code> (number of page with messages which you want to access, <code>Long</code> type) and a <code>limit</code> (max of messages per page, <code>Long</code> type) parameters. Please use builder style:
 * <br>
     * <pre><code>
     * ListMessagesResponse res = sdk.outgoing().list()
     *    .page(1L)
     *    .limit(10L)
     *    .call();
     * </code></pre>
     * 
 * <br>Messages are fetched from the latest one. This method will accept maximum value of <strong>50</strong> as <code>limit</code> parameter value.
 * <br>
 * <br>As a successful result a <code>ListMessagesResponse</code> object will be returned containing <code>messages</code> property of type <code>List&lt;Message&gt;</code> with a <code>Message</code> objects, each object per single message. <code>ListMessagesResponse</code> will also contain <code>headers</code> property where you can find <code>X-Total-Results</code> (a total count of all messages which are available in history on your account), <code>X-Total-Pages</code> (a total number of all pages with results), <code>X-Current-Page</code> (A current page number) and <code>X-Limit</code> (messages count per single page) elements.
     * @param page Page number of results
     * @param limit Number of results on one page
     * @param options additional options
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public ListMessagesResponse list(
            Optional<Long> page,
            Optional<Long> limit,
            Optional<Options> options) throws Exception {

        if (options.isPresent()) {
          options.get().validate(Arrays.asList(Options.Option.RETRY_CONFIG));
        }
        ListMessagesRequest request =
            ListMessagesRequest
                .builder()
                .page(page)
                .limit(limit)
                .build();
        
        String _baseUrl = this.sdkConfiguration.serverUrl;
        String _url = Utils.generateURL(
                _baseUrl,
                "/messages");
        
        HTTPRequest _req = new HTTPRequest(_url, "GET");
        _req.addHeader("Accept", "application/json")
            .addHeader("user-agent", 
                SDKConfiguration.USER_AGENT);

        _req.addQueryParams(Utils.getQueryParams(
                ListMessagesRequest.class,
                request, 
                null));
        
        Optional<SecuritySource> _hookSecuritySource = this.sdkConfiguration.securitySource();
        Utils.configureSecurity(_req,  
                this.sdkConfiguration.securitySource.getSecurity());
        HTTPClient _client = this.sdkConfiguration.defaultClient;
        HTTPRequest _finalReq = _req;
        RetryConfig _retryConfig;
        if (options.isPresent() && options.get().retryConfig().isPresent()) {
            _retryConfig = options.get().retryConfig().get();
        } else if (this.sdkConfiguration.retryConfig.isPresent()) {
            _retryConfig = this.sdkConfiguration.retryConfig.get();
        } else {
            _retryConfig = RetryConfig.builder()
                .backoff(BackoffStrategy.builder()
                            .initialInterval(500, TimeUnit.MILLISECONDS)
                            .maxInterval(60000, TimeUnit.MILLISECONDS)
                            .baseFactor((double)(1.5))
                            .maxElapsedTime(3600000, TimeUnit.MILLISECONDS)
                            .retryConnectError(true)
                            .build())
                .build();
        }
        List<String> _statusCodes = new ArrayList<>();
        _statusCodes.add("5XX");
        Retries _retries = Retries.builder()
            .action(() -> {
                HttpRequest _r = null;
                try {
                    _r = sdkConfiguration.hooks()
                        .beforeRequest(
                            new BeforeRequestContextImpl(
                                "listMessages", 
                                Optional.of(List.of()), 
                                _hookSecuritySource),
                            _finalReq.build());
                } catch (Exception _e) {
                    throw new NonRetryableException(_e);
                }
                try {
                    return _client.send(_r);
                } catch (Exception _e) {
                    return sdkConfiguration.hooks()
                        .afterError(
                            new AfterErrorContextImpl(
                                "listMessages",
                                 Optional.of(List.of()),
                                 _hookSecuritySource), 
                            Optional.empty(),
                            Optional.of(_e));
                }
            })
            .retryConfig(_retryConfig)
            .statusCodes(_statusCodes)
            .build();
        HttpResponse<InputStream> _httpRes = sdkConfiguration.hooks()
                 .afterSuccess(
                     new AfterSuccessContextImpl(
                         "listMessages", 
                         Optional.of(List.of()), 
                         _hookSecuritySource),
                     _retries.run());
        String _contentType = _httpRes
            .headers()
            .firstValue("Content-Type")
            .orElse("application/octet-stream");
        ListMessagesResponse.Builder _resBuilder = 
            ListMessagesResponse
                .builder()
                .contentType(_contentType)
                .statusCode(_httpRes.statusCode())
                .rawResponse(_httpRes);

        ListMessagesResponse _res = _resBuilder.build();
        
        if (Utils.statusCodeMatches(_httpRes.statusCode(), "200")) {
            _res.withHeaders(_httpRes.headers().map());
            if (Utils.contentTypeMatches(_contentType, "application/json")) {
                List<Message> _out = Utils.mapper().readValue(
                    Utils.toUtf8AndClose(_httpRes.body()),
                    new TypeReference<List<Message>>() {});
                _res.withMessages(Optional.ofNullable(_out));
                return _res;
            } else {
                throw new SDKError(
                    _httpRes, 
                    _httpRes.statusCode(), 
                    "Unexpected content-type received: " + _contentType, 
                    Utils.extractByteArrayFromBody(_httpRes));
            }
        }
        if (Utils.statusCodeMatches(_httpRes.statusCode(), "400", "401", "403", "404", "4XX")) {
            if (Utils.contentTypeMatches(_contentType, "application/problem+json")) {
                ErrorResponse _out = Utils.mapper().readValue(
                    Utils.toUtf8AndClose(_httpRes.body()),
                    new TypeReference<ErrorResponse>() {});
                throw _out;
            } else {
                throw new SDKError(
                    _httpRes, 
                    _httpRes.statusCode(), 
                    "Unexpected content-type received: " + _contentType, 
                    Utils.extractByteArrayFromBody(_httpRes));
            }
        }
        if (Utils.statusCodeMatches(_httpRes.statusCode(), "5XX")) {
            if (Utils.contentTypeMatches(_contentType, "application/problem+json")) {
                ErrorResponse _out = Utils.mapper().readValue(
                    Utils.toUtf8AndClose(_httpRes.body()),
                    new TypeReference<ErrorResponse>() {});
                throw _out;
            } else {
                throw new SDKError(
                    _httpRes, 
                    _httpRes.statusCode(), 
                    "Unexpected content-type received: " + _contentType, 
                    Utils.extractByteArrayFromBody(_httpRes));
            }
        }
        throw new SDKError(
            _httpRes, 
            _httpRes.statusCode(), 
            "Unexpected status code received: " + _httpRes.statusCode(), 
            Utils.extractByteArrayFromBody(_httpRes));
    }

}
