/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */

package pl.gsmservice.gateway;

import com.fasterxml.jackson.core.type.TypeReference;
import java.io.InputStream;
import java.lang.Exception;
import java.lang.Object;
import java.lang.String;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import pl.gsmservice.gateway.models.components.Message;
import pl.gsmservice.gateway.models.components.Price;
import pl.gsmservice.gateway.models.errors.ErrorResponse;
import pl.gsmservice.gateway.models.errors.SDKError;
import pl.gsmservice.gateway.models.operations.GetSmsPriceRequestBody;
import pl.gsmservice.gateway.models.operations.GetSmsPriceRequestBuilder;
import pl.gsmservice.gateway.models.operations.GetSmsPriceResponse;
import pl.gsmservice.gateway.models.operations.SDKMethodInterfaces.*;
import pl.gsmservice.gateway.models.operations.SendSmsRequestBody;
import pl.gsmservice.gateway.models.operations.SendSmsRequestBuilder;
import pl.gsmservice.gateway.models.operations.SendSmsResponse;
import pl.gsmservice.gateway.utils.BackoffStrategy;
import pl.gsmservice.gateway.utils.HTTPClient;
import pl.gsmservice.gateway.utils.HTTPRequest;
import pl.gsmservice.gateway.utils.Hook.AfterErrorContextImpl;
import pl.gsmservice.gateway.utils.Hook.AfterSuccessContextImpl;
import pl.gsmservice.gateway.utils.Hook.BeforeRequestContextImpl;
import pl.gsmservice.gateway.utils.Options;
import pl.gsmservice.gateway.utils.Retries.NonRetryableException;
import pl.gsmservice.gateway.utils.Retries;
import pl.gsmservice.gateway.utils.RetryConfig;
import pl.gsmservice.gateway.utils.SerializedBody;
import pl.gsmservice.gateway.utils.Utils.JsonShape;
import pl.gsmservice.gateway.utils.Utils; 

public class Sms implements
            MethodCallGetSmsPrice,
            MethodCallSendSms {

    private final SDKConfiguration sdkConfiguration;

    Sms(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }


    /**
     * Check the price of SMS Messages
     * 
 * <br>
 * <br>Check the price of single or multiple SMS messages at the same time before sending them. You can pass a single <code>SmsMessage</code> object using <code>GetSmsPriceRequestBody.of(SmsMessage)</code> method (for single message) or <code>List&lt;SmsMessage&gt;</code> using <code>GetSmsPriceRequestBody.of(List.of(SmsMessage,...))</code> method (for multiple messages).
 * <br>
 * <br>Each <code>SmsMessage</code> object has several properties, describing message parameters such as recipient phone number, content of the message, type, etc. Please use builder style:
 * <br>
     * <pre><code>
     * GetSmsPriceResponse res = sdk.outgoing().sms().getPrice()
     *    .request(req) // here pass GetSmsPriceRequestBody.of(...) object
     *    .call();
     * </code></pre>
     * 
 * <br>The method will accept maximum <strong>100</strong> messages in one call.
 * <br>
 * <br>As a successful result a <code>GetSmsPriceResponse</code> object will be returned with <code>prices</code> property of type <code>List&lt;Price&gt;</code> containing a <code>Price</code> objects, one object per each single message. You should check the <code>error</code> property of each <code>Price</code> object to make sure which messages were priced successfully and which finished with an error. Successfully priced messages will have <code>null</code> value of <code>error</code> property.
 * <br>
 * <br><code>GetSmsPriceResponse</code> object will include also <code>headers</code> property with <code>X-Success-Count</code> (a count of messages which were processed successfully) and <code>X-Error-Count</code> (count of messages which were rejected) elements.
     * @return The call builder
     */
    public GetSmsPriceRequestBuilder getPrice() {
        return new GetSmsPriceRequestBuilder(this);
    }

    /**
     * Check the price of SMS Messages
     * 
 * <br>
 * <br>Check the price of single or multiple SMS messages at the same time before sending them. You can pass a single <code>SmsMessage</code> object using <code>GetSmsPriceRequestBody.of(SmsMessage)</code> method (for single message) or <code>List&lt;SmsMessage&gt;</code> using <code>GetSmsPriceRequestBody.of(List.of(SmsMessage,...))</code> method (for multiple messages).
 * <br>
 * <br>Each <code>SmsMessage</code> object has several properties, describing message parameters such as recipient phone number, content of the message, type, etc. Please use builder style:
 * <br>
     * <pre><code>
     * GetSmsPriceResponse res = sdk.outgoing().sms().getPrice()
     *    .request(req) // here pass GetSmsPriceRequestBody.of(...) object
     *    .call();
     * </code></pre>
     * 
 * <br>The method will accept maximum <strong>100</strong> messages in one call.
 * <br>
 * <br>As a successful result a <code>GetSmsPriceResponse</code> object will be returned with <code>prices</code> property of type <code>List&lt;Price&gt;</code> containing a <code>Price</code> objects, one object per each single message. You should check the <code>error</code> property of each <code>Price</code> object to make sure which messages were priced successfully and which finished with an error. Successfully priced messages will have <code>null</code> value of <code>error</code> property.
 * <br>
 * <br><code>GetSmsPriceResponse</code> object will include also <code>headers</code> property with <code>X-Success-Count</code> (a count of messages which were processed successfully) and <code>X-Error-Count</code> (count of messages which were rejected) elements.
     * @param request The request object containing all of the parameters for the API call.
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public GetSmsPriceResponse getPrice(
            GetSmsPriceRequestBody request) throws Exception {
        return getPrice(request, Optional.empty());
    }
    
    /**
     * Check the price of SMS Messages
     * 
 * <br>
 * <br>Check the price of single or multiple SMS messages at the same time before sending them. You can pass a single <code>SmsMessage</code> object using <code>GetSmsPriceRequestBody.of(SmsMessage)</code> method (for single message) or <code>List&lt;SmsMessage&gt;</code> using <code>GetSmsPriceRequestBody.of(List.of(SmsMessage,...))</code> method (for multiple messages).
 * <br>
 * <br>Each <code>SmsMessage</code> object has several properties, describing message parameters such as recipient phone number, content of the message, type, etc. Please use builder style:
 * <br>
     * <pre><code>
     * GetSmsPriceResponse res = sdk.outgoing().sms().getPrice()
     *    .request(req) // here pass GetSmsPriceRequestBody.of(...) object
     *    .call();
     * </code></pre>
     * 
 * <br>The method will accept maximum <strong>100</strong> messages in one call.
 * <br>
 * <br>As a successful result a <code>GetSmsPriceResponse</code> object will be returned with <code>prices</code> property of type <code>List&lt;Price&gt;</code> containing a <code>Price</code> objects, one object per each single message. You should check the <code>error</code> property of each <code>Price</code> object to make sure which messages were priced successfully and which finished with an error. Successfully priced messages will have <code>null</code> value of <code>error</code> property.
 * <br>
 * <br><code>GetSmsPriceResponse</code> object will include also <code>headers</code> property with <code>X-Success-Count</code> (a count of messages which were processed successfully) and <code>X-Error-Count</code> (count of messages which were rejected) elements.
     * @param request The request object containing all of the parameters for the API call.
     * @param options additional options
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public GetSmsPriceResponse getPrice(
            GetSmsPriceRequestBody request,
            Optional<Options> options) throws Exception {

        if (options.isPresent()) {
          options.get().validate(Arrays.asList(Options.Option.RETRY_CONFIG));
        }
        String _baseUrl = this.sdkConfiguration.serverUrl;
        String _url = Utils.generateURL(
                _baseUrl,
                "/messages/sms/price");
        
        HTTPRequest _req = new HTTPRequest(_url, "POST");
        Object _convertedRequest = Utils.convertToShape(
                request, 
                JsonShape.DEFAULT,
                new TypeReference<GetSmsPriceRequestBody>() {});
        SerializedBody _serializedRequestBody = Utils.serializeRequestBody(
                _convertedRequest, 
                "request",
                "json",
                false);
        if (_serializedRequestBody == null) {
            throw new Exception("Request body is required");
        }
        _req.setBody(Optional.ofNullable(_serializedRequestBody));
        _req.addHeader("Accept", "application/json")
            .addHeader("user-agent", 
                SDKConfiguration.USER_AGENT);
        
        Optional<SecuritySource> _hookSecuritySource = this.sdkConfiguration.securitySource();
        Utils.configureSecurity(_req,  
                this.sdkConfiguration.securitySource.getSecurity());
        HTTPClient _client = this.sdkConfiguration.defaultClient;
        HTTPRequest _finalReq = _req;
        RetryConfig _retryConfig;
        if (options.isPresent() && options.get().retryConfig().isPresent()) {
            _retryConfig = options.get().retryConfig().get();
        } else if (this.sdkConfiguration.retryConfig.isPresent()) {
            _retryConfig = this.sdkConfiguration.retryConfig.get();
        } else {
            _retryConfig = RetryConfig.builder()
                .backoff(BackoffStrategy.builder()
                            .initialInterval(500, TimeUnit.MILLISECONDS)
                            .maxInterval(60000, TimeUnit.MILLISECONDS)
                            .baseFactor((double)(1.5))
                            .maxElapsedTime(3600000, TimeUnit.MILLISECONDS)
                            .retryConnectError(true)
                            .build())
                .build();
        }
        List<String> _statusCodes = new ArrayList<>();
        _statusCodes.add("5XX");
        Retries _retries = Retries.builder()
            .action(() -> {
                HttpRequest _r = null;
                try {
                    _r = sdkConfiguration.hooks()
                        .beforeRequest(
                            new BeforeRequestContextImpl(
                                "getSmsPrice", 
                                Optional.of(List.of()), 
                                _hookSecuritySource),
                            _finalReq.build());
                } catch (Exception _e) {
                    throw new NonRetryableException(_e);
                }
                try {
                    return _client.send(_r);
                } catch (Exception _e) {
                    return sdkConfiguration.hooks()
                        .afterError(
                            new AfterErrorContextImpl(
                                "getSmsPrice",
                                 Optional.of(List.of()),
                                 _hookSecuritySource), 
                            Optional.empty(),
                            Optional.of(_e));
                }
            })
            .retryConfig(_retryConfig)
            .statusCodes(_statusCodes)
            .build();
        HttpResponse<InputStream> _httpRes = sdkConfiguration.hooks()
                 .afterSuccess(
                     new AfterSuccessContextImpl(
                         "getSmsPrice", 
                         Optional.of(List.of()), 
                         _hookSecuritySource),
                     _retries.run());
        String _contentType = _httpRes
            .headers()
            .firstValue("Content-Type")
            .orElse("application/octet-stream");
        GetSmsPriceResponse.Builder _resBuilder = 
            GetSmsPriceResponse
                .builder()
                .contentType(_contentType)
                .statusCode(_httpRes.statusCode())
                .rawResponse(_httpRes);

        GetSmsPriceResponse _res = _resBuilder.build();
        
        if (Utils.statusCodeMatches(_httpRes.statusCode(), "200")) {
            _res.withHeaders(_httpRes.headers().map());
            if (Utils.contentTypeMatches(_contentType, "application/json")) {
                List<Price> _out = Utils.mapper().readValue(
                    Utils.toUtf8AndClose(_httpRes.body()),
                    new TypeReference<List<Price>>() {});
                _res.withPrices(Optional.ofNullable(_out));
                return _res;
            } else {
                throw new SDKError(
                    _httpRes, 
                    _httpRes.statusCode(), 
                    "Unexpected content-type received: " + _contentType, 
                    Utils.extractByteArrayFromBody(_httpRes));
            }
        }
        if (Utils.statusCodeMatches(_httpRes.statusCode(), "400", "401", "4XX")) {
            if (Utils.contentTypeMatches(_contentType, "application/problem+json")) {
                ErrorResponse _out = Utils.mapper().readValue(
                    Utils.toUtf8AndClose(_httpRes.body()),
                    new TypeReference<ErrorResponse>() {});
                throw _out;
            } else {
                throw new SDKError(
                    _httpRes, 
                    _httpRes.statusCode(), 
                    "Unexpected content-type received: " + _contentType, 
                    Utils.extractByteArrayFromBody(_httpRes));
            }
        }
        if (Utils.statusCodeMatches(_httpRes.statusCode(), "5XX")) {
            if (Utils.contentTypeMatches(_contentType, "application/problem+json")) {
                ErrorResponse _out = Utils.mapper().readValue(
                    Utils.toUtf8AndClose(_httpRes.body()),
                    new TypeReference<ErrorResponse>() {});
                throw _out;
            } else {
                throw new SDKError(
                    _httpRes, 
                    _httpRes.statusCode(), 
                    "Unexpected content-type received: " + _contentType, 
                    Utils.extractByteArrayFromBody(_httpRes));
            }
        }
        throw new SDKError(
            _httpRes, 
            _httpRes.statusCode(), 
            "Unexpected status code received: " + _httpRes.statusCode(), 
            Utils.extractByteArrayFromBody(_httpRes));
    }



    /**
     * Send SMS Messages
     * 
 * <br>
 * <br>Send single or multiple SMS messages at the same time. You can pass a single <code>SmsMessage</code> object using <code>SendSmsRequestBody.of(SmsMessage)</code> method (for single message) or <code>List&lt;SmsMessage&gt;</code> using <code>SendSmsRequestBody.of(List.of(SmsMessage,...))</code> method (for multiple messages). Each <code>SmsMessage</code> object has several properties, describing message parameters such recipient phone number, content of the message, type or scheduled sending date, etc. Please use builder style:
 * <br>
     * <pre><code>
     * SendSmsResponse res = sdk.outgoing().sms().send()
     *    .request(req) // here pass GetSmsPriceRequestBody.of(...) object
     *    .call();
     * </code></pre>
     * 
 * <br>This method will accept maximum 100 messages in one call.
 * <br>
 * <br>As a successful result a <code>SendSmsResponse</code> object will be returned with <code>messages</code> property of type List&lt;Message&gt; containing <code>Message</code> objects, one object per each single message. You should check the <code>statusCode</code> property of each <code>Message</code> object to make sure which messages were accepted by gateway (queued) and which were rejected. In case of rejection, <code>statusDescription</code> property will include a reason.
 * <br>
 * <br><code>SendSmsResponse</code> will also include <code>headers</code> property with <code>X-Success-Count</code> (a count of messages which were processed successfully), <code>X-Error-Count</code> (count of messages which were rejected) and <code>X-Sandbox</code> (if a request was made in Sandbox or Production system) elements.
     * @return The call builder
     */
    public SendSmsRequestBuilder send() {
        return new SendSmsRequestBuilder(this);
    }

    /**
     * Send SMS Messages
     * 
 * <br>
 * <br>Send single or multiple SMS messages at the same time. You can pass a single <code>SmsMessage</code> object using <code>SendSmsRequestBody.of(SmsMessage)</code> method (for single message) or <code>List&lt;SmsMessage&gt;</code> using <code>SendSmsRequestBody.of(List.of(SmsMessage,...))</code> method (for multiple messages). Each <code>SmsMessage</code> object has several properties, describing message parameters such recipient phone number, content of the message, type or scheduled sending date, etc. Please use builder style:
 * <br>
     * <pre><code>
     * SendSmsResponse res = sdk.outgoing().sms().send()
     *    .request(req) // here pass GetSmsPriceRequestBody.of(...) object
     *    .call();
     * </code></pre>
     * 
 * <br>This method will accept maximum 100 messages in one call.
 * <br>
 * <br>As a successful result a <code>SendSmsResponse</code> object will be returned with <code>messages</code> property of type List&lt;Message&gt; containing <code>Message</code> objects, one object per each single message. You should check the <code>statusCode</code> property of each <code>Message</code> object to make sure which messages were accepted by gateway (queued) and which were rejected. In case of rejection, <code>statusDescription</code> property will include a reason.
 * <br>
 * <br><code>SendSmsResponse</code> will also include <code>headers</code> property with <code>X-Success-Count</code> (a count of messages which were processed successfully), <code>X-Error-Count</code> (count of messages which were rejected) and <code>X-Sandbox</code> (if a request was made in Sandbox or Production system) elements.
     * @param request The request object containing all of the parameters for the API call.
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public SendSmsResponse send(
            SendSmsRequestBody request) throws Exception {
        return send(request, Optional.empty());
    }
    
    /**
     * Send SMS Messages
     * 
 * <br>
 * <br>Send single or multiple SMS messages at the same time. You can pass a single <code>SmsMessage</code> object using <code>SendSmsRequestBody.of(SmsMessage)</code> method (for single message) or <code>List&lt;SmsMessage&gt;</code> using <code>SendSmsRequestBody.of(List.of(SmsMessage,...))</code> method (for multiple messages). Each <code>SmsMessage</code> object has several properties, describing message parameters such recipient phone number, content of the message, type or scheduled sending date, etc. Please use builder style:
 * <br>
     * <pre><code>
     * SendSmsResponse res = sdk.outgoing().sms().send()
     *    .request(req) // here pass GetSmsPriceRequestBody.of(...) object
     *    .call();
     * </code></pre>
     * 
 * <br>This method will accept maximum 100 messages in one call.
 * <br>
 * <br>As a successful result a <code>SendSmsResponse</code> object will be returned with <code>messages</code> property of type List&lt;Message&gt; containing <code>Message</code> objects, one object per each single message. You should check the <code>statusCode</code> property of each <code>Message</code> object to make sure which messages were accepted by gateway (queued) and which were rejected. In case of rejection, <code>statusDescription</code> property will include a reason.
 * <br>
 * <br><code>SendSmsResponse</code> will also include <code>headers</code> property with <code>X-Success-Count</code> (a count of messages which were processed successfully), <code>X-Error-Count</code> (count of messages which were rejected) and <code>X-Sandbox</code> (if a request was made in Sandbox or Production system) elements.
     * @param request The request object containing all of the parameters for the API call.
     * @param options additional options
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public SendSmsResponse send(
            SendSmsRequestBody request,
            Optional<Options> options) throws Exception {

        if (options.isPresent()) {
          options.get().validate(Arrays.asList(Options.Option.RETRY_CONFIG));
        }
        String _baseUrl = this.sdkConfiguration.serverUrl;
        String _url = Utils.generateURL(
                _baseUrl,
                "/messages/sms");
        
        HTTPRequest _req = new HTTPRequest(_url, "POST");
        Object _convertedRequest = Utils.convertToShape(
                request, 
                JsonShape.DEFAULT,
                new TypeReference<SendSmsRequestBody>() {});
        SerializedBody _serializedRequestBody = Utils.serializeRequestBody(
                _convertedRequest, 
                "request",
                "json",
                false);
        if (_serializedRequestBody == null) {
            throw new Exception("Request body is required");
        }
        _req.setBody(Optional.ofNullable(_serializedRequestBody));
        _req.addHeader("Accept", "application/json")
            .addHeader("user-agent", 
                SDKConfiguration.USER_AGENT);
        
        Optional<SecuritySource> _hookSecuritySource = this.sdkConfiguration.securitySource();
        Utils.configureSecurity(_req,  
                this.sdkConfiguration.securitySource.getSecurity());
        HTTPClient _client = this.sdkConfiguration.defaultClient;
        HTTPRequest _finalReq = _req;
        RetryConfig _retryConfig;
        if (options.isPresent() && options.get().retryConfig().isPresent()) {
            _retryConfig = options.get().retryConfig().get();
        } else if (this.sdkConfiguration.retryConfig.isPresent()) {
            _retryConfig = this.sdkConfiguration.retryConfig.get();
        } else {
            _retryConfig = RetryConfig.builder()
                .backoff(BackoffStrategy.builder()
                            .initialInterval(500, TimeUnit.MILLISECONDS)
                            .maxInterval(60000, TimeUnit.MILLISECONDS)
                            .baseFactor((double)(1.5))
                            .maxElapsedTime(3600000, TimeUnit.MILLISECONDS)
                            .retryConnectError(true)
                            .build())
                .build();
        }
        List<String> _statusCodes = new ArrayList<>();
        _statusCodes.add("5XX");
        Retries _retries = Retries.builder()
            .action(() -> {
                HttpRequest _r = null;
                try {
                    _r = sdkConfiguration.hooks()
                        .beforeRequest(
                            new BeforeRequestContextImpl(
                                "sendSms", 
                                Optional.of(List.of()), 
                                _hookSecuritySource),
                            _finalReq.build());
                } catch (Exception _e) {
                    throw new NonRetryableException(_e);
                }
                try {
                    return _client.send(_r);
                } catch (Exception _e) {
                    return sdkConfiguration.hooks()
                        .afterError(
                            new AfterErrorContextImpl(
                                "sendSms",
                                 Optional.of(List.of()),
                                 _hookSecuritySource), 
                            Optional.empty(),
                            Optional.of(_e));
                }
            })
            .retryConfig(_retryConfig)
            .statusCodes(_statusCodes)
            .build();
        HttpResponse<InputStream> _httpRes = sdkConfiguration.hooks()
                 .afterSuccess(
                     new AfterSuccessContextImpl(
                         "sendSms", 
                         Optional.of(List.of()), 
                         _hookSecuritySource),
                     _retries.run());
        String _contentType = _httpRes
            .headers()
            .firstValue("Content-Type")
            .orElse("application/octet-stream");
        SendSmsResponse.Builder _resBuilder = 
            SendSmsResponse
                .builder()
                .contentType(_contentType)
                .statusCode(_httpRes.statusCode())
                .rawResponse(_httpRes);

        SendSmsResponse _res = _resBuilder.build();
        
        if (Utils.statusCodeMatches(_httpRes.statusCode(), "200")) {
            _res.withHeaders(_httpRes.headers().map());
            if (Utils.contentTypeMatches(_contentType, "application/json")) {
                List<Message> _out = Utils.mapper().readValue(
                    Utils.toUtf8AndClose(_httpRes.body()),
                    new TypeReference<List<Message>>() {});
                _res.withMessages(Optional.ofNullable(_out));
                return _res;
            } else {
                throw new SDKError(
                    _httpRes, 
                    _httpRes.statusCode(), 
                    "Unexpected content-type received: " + _contentType, 
                    Utils.extractByteArrayFromBody(_httpRes));
            }
        }
        if (Utils.statusCodeMatches(_httpRes.statusCode(), "400", "401", "403", "4XX")) {
            if (Utils.contentTypeMatches(_contentType, "application/problem+json")) {
                ErrorResponse _out = Utils.mapper().readValue(
                    Utils.toUtf8AndClose(_httpRes.body()),
                    new TypeReference<ErrorResponse>() {});
                throw _out;
            } else {
                throw new SDKError(
                    _httpRes, 
                    _httpRes.statusCode(), 
                    "Unexpected content-type received: " + _contentType, 
                    Utils.extractByteArrayFromBody(_httpRes));
            }
        }
        if (Utils.statusCodeMatches(_httpRes.statusCode(), "5XX")) {
            if (Utils.contentTypeMatches(_contentType, "application/problem+json")) {
                ErrorResponse _out = Utils.mapper().readValue(
                    Utils.toUtf8AndClose(_httpRes.body()),
                    new TypeReference<ErrorResponse>() {});
                throw _out;
            } else {
                throw new SDKError(
                    _httpRes, 
                    _httpRes.statusCode(), 
                    "Unexpected content-type received: " + _contentType, 
                    Utils.extractByteArrayFromBody(_httpRes));
            }
        }
        throw new SDKError(
            _httpRes, 
            _httpRes.statusCode(), 
            "Unexpected status code received: " + _httpRes.statusCode(), 
            Utils.extractByteArrayFromBody(_httpRes));
    }

}
