/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */


package pl.gsmservice.gateway.models.components;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.Boolean;
import java.lang.Float;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Objects;
import java.util.Optional;
import org.openapitools.jackson.nullable.JsonNullable;
import pl.gsmservice.gateway.utils.Utils;
/**
 * AccountResponse - An object containing information about the User's account and balance
 */

public class AccountResponse {

    /**
     * User Login
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("login")
    private Optional<String> login;

    /**
     * Account type
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("account_type")
    private Optional<? extends AccountType> accountType;

    /**
     * Acount limit
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("limit")
    private Optional<Float> limit;

    /**
     * Current account balance
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("credit")
    private Optional<Float> credit;

    /**
     * Subaccount credit balance (null if unlimited)
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("subcredit")
    private JsonNullable<Float> subcredit;

    /**
     * Account currency
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("currency")
    private Optional<String> currency;

    /**
     * User name and surname
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("name")
    private Optional<String> name;

    /**
     * Is main account?
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("is_main")
    private Optional<Boolean> isMain;

    @JsonCreator
    public AccountResponse(
            @JsonProperty("login") Optional<String> login,
            @JsonProperty("account_type") Optional<? extends AccountType> accountType,
            @JsonProperty("limit") Optional<Float> limit,
            @JsonProperty("credit") Optional<Float> credit,
            @JsonProperty("subcredit") JsonNullable<Float> subcredit,
            @JsonProperty("currency") Optional<String> currency,
            @JsonProperty("name") Optional<String> name,
            @JsonProperty("is_main") Optional<Boolean> isMain) {
        Utils.checkNotNull(login, "login");
        Utils.checkNotNull(accountType, "accountType");
        Utils.checkNotNull(limit, "limit");
        Utils.checkNotNull(credit, "credit");
        Utils.checkNotNull(subcredit, "subcredit");
        Utils.checkNotNull(currency, "currency");
        Utils.checkNotNull(name, "name");
        Utils.checkNotNull(isMain, "isMain");
        this.login = login;
        this.accountType = accountType;
        this.limit = limit;
        this.credit = credit;
        this.subcredit = subcredit;
        this.currency = currency;
        this.name = name;
        this.isMain = isMain;
    }
    
    public AccountResponse() {
        this(Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), JsonNullable.undefined(), Optional.empty(), Optional.empty(), Optional.empty());
    }

    /**
     * User Login
     */
    @JsonIgnore
    public Optional<String> login() {
        return login;
    }

    /**
     * Account type
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public Optional<AccountType> accountType() {
        return (Optional<AccountType>) accountType;
    }

    /**
     * Acount limit
     */
    @JsonIgnore
    public Optional<Float> limit() {
        return limit;
    }

    /**
     * Current account balance
     */
    @JsonIgnore
    public Optional<Float> credit() {
        return credit;
    }

    /**
     * Subaccount credit balance (null if unlimited)
     */
    @JsonIgnore
    public JsonNullable<Float> subcredit() {
        return subcredit;
    }

    /**
     * Account currency
     */
    @JsonIgnore
    public Optional<String> currency() {
        return currency;
    }

    /**
     * User name and surname
     */
    @JsonIgnore
    public Optional<String> name() {
        return name;
    }

    /**
     * Is main account?
     */
    @JsonIgnore
    public Optional<Boolean> isMain() {
        return isMain;
    }

    public final static Builder builder() {
        return new Builder();
    }

    /**
     * User Login
     */
    public AccountResponse withLogin(String login) {
        Utils.checkNotNull(login, "login");
        this.login = Optional.ofNullable(login);
        return this;
    }

    /**
     * User Login
     */
    public AccountResponse withLogin(Optional<String> login) {
        Utils.checkNotNull(login, "login");
        this.login = login;
        return this;
    }

    /**
     * Account type
     */
    public AccountResponse withAccountType(AccountType accountType) {
        Utils.checkNotNull(accountType, "accountType");
        this.accountType = Optional.ofNullable(accountType);
        return this;
    }

    /**
     * Account type
     */
    public AccountResponse withAccountType(Optional<? extends AccountType> accountType) {
        Utils.checkNotNull(accountType, "accountType");
        this.accountType = accountType;
        return this;
    }

    /**
     * Acount limit
     */
    public AccountResponse withLimit(float limit) {
        Utils.checkNotNull(limit, "limit");
        this.limit = Optional.ofNullable(limit);
        return this;
    }

    /**
     * Acount limit
     */
    public AccountResponse withLimit(Optional<Float> limit) {
        Utils.checkNotNull(limit, "limit");
        this.limit = limit;
        return this;
    }

    /**
     * Current account balance
     */
    public AccountResponse withCredit(float credit) {
        Utils.checkNotNull(credit, "credit");
        this.credit = Optional.ofNullable(credit);
        return this;
    }

    /**
     * Current account balance
     */
    public AccountResponse withCredit(Optional<Float> credit) {
        Utils.checkNotNull(credit, "credit");
        this.credit = credit;
        return this;
    }

    /**
     * Subaccount credit balance (null if unlimited)
     */
    public AccountResponse withSubcredit(float subcredit) {
        Utils.checkNotNull(subcredit, "subcredit");
        this.subcredit = JsonNullable.of(subcredit);
        return this;
    }

    /**
     * Subaccount credit balance (null if unlimited)
     */
    public AccountResponse withSubcredit(JsonNullable<Float> subcredit) {
        Utils.checkNotNull(subcredit, "subcredit");
        this.subcredit = subcredit;
        return this;
    }

    /**
     * Account currency
     */
    public AccountResponse withCurrency(String currency) {
        Utils.checkNotNull(currency, "currency");
        this.currency = Optional.ofNullable(currency);
        return this;
    }

    /**
     * Account currency
     */
    public AccountResponse withCurrency(Optional<String> currency) {
        Utils.checkNotNull(currency, "currency");
        this.currency = currency;
        return this;
    }

    /**
     * User name and surname
     */
    public AccountResponse withName(String name) {
        Utils.checkNotNull(name, "name");
        this.name = Optional.ofNullable(name);
        return this;
    }

    /**
     * User name and surname
     */
    public AccountResponse withName(Optional<String> name) {
        Utils.checkNotNull(name, "name");
        this.name = name;
        return this;
    }

    /**
     * Is main account?
     */
    public AccountResponse withIsMain(boolean isMain) {
        Utils.checkNotNull(isMain, "isMain");
        this.isMain = Optional.ofNullable(isMain);
        return this;
    }

    /**
     * Is main account?
     */
    public AccountResponse withIsMain(Optional<Boolean> isMain) {
        Utils.checkNotNull(isMain, "isMain");
        this.isMain = isMain;
        return this;
    }
    
    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        AccountResponse other = (AccountResponse) o;
        return 
            Objects.deepEquals(this.login, other.login) &&
            Objects.deepEquals(this.accountType, other.accountType) &&
            Objects.deepEquals(this.limit, other.limit) &&
            Objects.deepEquals(this.credit, other.credit) &&
            Objects.deepEquals(this.subcredit, other.subcredit) &&
            Objects.deepEquals(this.currency, other.currency) &&
            Objects.deepEquals(this.name, other.name) &&
            Objects.deepEquals(this.isMain, other.isMain);
    }
    
    @Override
    public int hashCode() {
        return Objects.hash(
            login,
            accountType,
            limit,
            credit,
            subcredit,
            currency,
            name,
            isMain);
    }
    
    @Override
    public String toString() {
        return Utils.toString(AccountResponse.class,
                "login", login,
                "accountType", accountType,
                "limit", limit,
                "credit", credit,
                "subcredit", subcredit,
                "currency", currency,
                "name", name,
                "isMain", isMain);
    }
    
    public final static class Builder {
 
        private Optional<String> login = Optional.empty();
 
        private Optional<? extends AccountType> accountType = Optional.empty();
 
        private Optional<Float> limit = Optional.empty();
 
        private Optional<Float> credit = Optional.empty();
 
        private JsonNullable<Float> subcredit = JsonNullable.undefined();
 
        private Optional<String> currency = Optional.empty();
 
        private Optional<String> name = Optional.empty();
 
        private Optional<Boolean> isMain = Optional.empty();  
        
        private Builder() {
          // force use of static builder() method
        }

        /**
         * User Login
         */
        public Builder login(String login) {
            Utils.checkNotNull(login, "login");
            this.login = Optional.ofNullable(login);
            return this;
        }

        /**
         * User Login
         */
        public Builder login(Optional<String> login) {
            Utils.checkNotNull(login, "login");
            this.login = login;
            return this;
        }

        /**
         * Account type
         */
        public Builder accountType(AccountType accountType) {
            Utils.checkNotNull(accountType, "accountType");
            this.accountType = Optional.ofNullable(accountType);
            return this;
        }

        /**
         * Account type
         */
        public Builder accountType(Optional<? extends AccountType> accountType) {
            Utils.checkNotNull(accountType, "accountType");
            this.accountType = accountType;
            return this;
        }

        /**
         * Acount limit
         */
        public Builder limit(float limit) {
            Utils.checkNotNull(limit, "limit");
            this.limit = Optional.ofNullable(limit);
            return this;
        }

        /**
         * Acount limit
         */
        public Builder limit(Optional<Float> limit) {
            Utils.checkNotNull(limit, "limit");
            this.limit = limit;
            return this;
        }

        /**
         * Current account balance
         */
        public Builder credit(float credit) {
            Utils.checkNotNull(credit, "credit");
            this.credit = Optional.ofNullable(credit);
            return this;
        }

        /**
         * Current account balance
         */
        public Builder credit(Optional<Float> credit) {
            Utils.checkNotNull(credit, "credit");
            this.credit = credit;
            return this;
        }

        /**
         * Subaccount credit balance (null if unlimited)
         */
        public Builder subcredit(float subcredit) {
            Utils.checkNotNull(subcredit, "subcredit");
            this.subcredit = JsonNullable.of(subcredit);
            return this;
        }

        /**
         * Subaccount credit balance (null if unlimited)
         */
        public Builder subcredit(JsonNullable<Float> subcredit) {
            Utils.checkNotNull(subcredit, "subcredit");
            this.subcredit = subcredit;
            return this;
        }

        /**
         * Account currency
         */
        public Builder currency(String currency) {
            Utils.checkNotNull(currency, "currency");
            this.currency = Optional.ofNullable(currency);
            return this;
        }

        /**
         * Account currency
         */
        public Builder currency(Optional<String> currency) {
            Utils.checkNotNull(currency, "currency");
            this.currency = currency;
            return this;
        }

        /**
         * User name and surname
         */
        public Builder name(String name) {
            Utils.checkNotNull(name, "name");
            this.name = Optional.ofNullable(name);
            return this;
        }

        /**
         * User name and surname
         */
        public Builder name(Optional<String> name) {
            Utils.checkNotNull(name, "name");
            this.name = name;
            return this;
        }

        /**
         * Is main account?
         */
        public Builder isMain(boolean isMain) {
            Utils.checkNotNull(isMain, "isMain");
            this.isMain = Optional.ofNullable(isMain);
            return this;
        }

        /**
         * Is main account?
         */
        public Builder isMain(Optional<Boolean> isMain) {
            Utils.checkNotNull(isMain, "isMain");
            this.isMain = isMain;
            return this;
        }
        
        public AccountResponse build() {
            return new AccountResponse(
                login,
                accountType,
                limit,
                credit,
                subcredit,
                currency,
                name,
                isMain);
        }
    }
}

