/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */


package pl.gsmservice.gateway.models.components;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.Long;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Objects;
import java.util.Optional;
import org.openapitools.jackson.nullable.JsonNullable;
import pl.gsmservice.gateway.utils.Utils;
/**
 * CancelledMessage - An object containing information about results of cancelling single message
 */

public class CancelledMessage {

    /**
     * Message ID
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("id")
    private Optional<Long> id;

    /**
     * Status of cancellation (204 if cancelled successfully or error status code)
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("status")
    private Optional<Long> status;

    /**
     * An object that complies with RFC 9457 containing information about a request error
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("error")
    private JsonNullable<? extends ErrorResponse> error;

    @JsonCreator
    public CancelledMessage(
            @JsonProperty("id") Optional<Long> id,
            @JsonProperty("status") Optional<Long> status,
            @JsonProperty("error") JsonNullable<? extends ErrorResponse> error) {
        Utils.checkNotNull(id, "id");
        Utils.checkNotNull(status, "status");
        Utils.checkNotNull(error, "error");
        this.id = id;
        this.status = status;
        this.error = error;
    }
    
    public CancelledMessage() {
        this(Optional.empty(), Optional.empty(), JsonNullable.undefined());
    }

    /**
     * Message ID
     */
    @JsonIgnore
    public Optional<Long> id() {
        return id;
    }

    /**
     * Status of cancellation (204 if cancelled successfully or error status code)
     */
    @JsonIgnore
    public Optional<Long> status() {
        return status;
    }

    /**
     * An object that complies with RFC 9457 containing information about a request error
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<ErrorResponse> error() {
        return (JsonNullable<ErrorResponse>) error;
    }

    public final static Builder builder() {
        return new Builder();
    }

    /**
     * Message ID
     */
    public CancelledMessage withId(long id) {
        Utils.checkNotNull(id, "id");
        this.id = Optional.ofNullable(id);
        return this;
    }

    /**
     * Message ID
     */
    public CancelledMessage withId(Optional<Long> id) {
        Utils.checkNotNull(id, "id");
        this.id = id;
        return this;
    }

    /**
     * Status of cancellation (204 if cancelled successfully or error status code)
     */
    public CancelledMessage withStatus(long status) {
        Utils.checkNotNull(status, "status");
        this.status = Optional.ofNullable(status);
        return this;
    }

    /**
     * Status of cancellation (204 if cancelled successfully or error status code)
     */
    public CancelledMessage withStatus(Optional<Long> status) {
        Utils.checkNotNull(status, "status");
        this.status = status;
        return this;
    }

    /**
     * An object that complies with RFC 9457 containing information about a request error
     */
    public CancelledMessage withError(ErrorResponse error) {
        Utils.checkNotNull(error, "error");
        this.error = JsonNullable.of(error);
        return this;
    }

    /**
     * An object that complies with RFC 9457 containing information about a request error
     */
    public CancelledMessage withError(JsonNullable<? extends ErrorResponse> error) {
        Utils.checkNotNull(error, "error");
        this.error = error;
        return this;
    }
    
    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        CancelledMessage other = (CancelledMessage) o;
        return 
            Objects.deepEquals(this.id, other.id) &&
            Objects.deepEquals(this.status, other.status) &&
            Objects.deepEquals(this.error, other.error);
    }
    
    @Override
    public int hashCode() {
        return Objects.hash(
            id,
            status,
            error);
    }
    
    @Override
    public String toString() {
        return Utils.toString(CancelledMessage.class,
                "id", id,
                "status", status,
                "error", error);
    }
    
    public final static class Builder {
 
        private Optional<Long> id = Optional.empty();
 
        private Optional<Long> status = Optional.empty();
 
        private JsonNullable<? extends ErrorResponse> error = JsonNullable.undefined();  
        
        private Builder() {
          // force use of static builder() method
        }

        /**
         * Message ID
         */
        public Builder id(long id) {
            Utils.checkNotNull(id, "id");
            this.id = Optional.ofNullable(id);
            return this;
        }

        /**
         * Message ID
         */
        public Builder id(Optional<Long> id) {
            Utils.checkNotNull(id, "id");
            this.id = id;
            return this;
        }

        /**
         * Status of cancellation (204 if cancelled successfully or error status code)
         */
        public Builder status(long status) {
            Utils.checkNotNull(status, "status");
            this.status = Optional.ofNullable(status);
            return this;
        }

        /**
         * Status of cancellation (204 if cancelled successfully or error status code)
         */
        public Builder status(Optional<Long> status) {
            Utils.checkNotNull(status, "status");
            this.status = status;
            return this;
        }

        /**
         * An object that complies with RFC 9457 containing information about a request error
         */
        public Builder error(ErrorResponse error) {
            Utils.checkNotNull(error, "error");
            this.error = JsonNullable.of(error);
            return this;
        }

        /**
         * An object that complies with RFC 9457 containing information about a request error
         */
        public Builder error(JsonNullable<? extends ErrorResponse> error) {
            Utils.checkNotNull(error, "error");
            this.error = error;
            return this;
        }
        
        public CancelledMessage build() {
            return new CancelledMessage(
                id,
                status,
                error);
        }
    }
}

