/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */


package pl.gsmservice.gateway.models.components;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import java.lang.Boolean;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.time.OffsetDateTime;
import java.util.Objects;
import java.util.Optional;
import org.openapitools.jackson.nullable.JsonNullable;
import pl.gsmservice.gateway.utils.LazySingletonValue;
import pl.gsmservice.gateway.utils.Utils;
/**
 * SmsMessage - An object with a new SMS message properties
 */

public class SmsMessage {

    /**
     * The recipient number or multiple recipients numbers of single message. To set one recipient, please use <code>SmsMessageRecipients.of(String)</code> method simply passing to it a <code>string</code> with his phone number. To set multiple recipients, please use <code>SmsMessageRecipients.ofArrayOfStrings(List.of(String,...))</code> method passing to it <code>List&lt;string&gt;</code>. Optionally you can also set custom id (user identifier) for each message - use <code>SmsMessageRecipients.of(PhoneNumberWithCid)</code> method passing <code>PhoneNumberWithCid</code> object (in case of single recipient) or <code>SmsMessageRecipients.ofArrayOfPhoneNumberWithCids(Recipients.of(PhoneNumberWithCid,...))</code> method passing List&lt;PhoneNumberWithCid&gt; (in case of multiple recipients).
     */
    @JsonProperty("recipients")
    private SmsMessageRecipients recipients;

    /**
     * SMS message content
     */
    @JsonProperty("message")
    private String message;

    /**
     * SMS sender name
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("sender")
    private Optional<String> sender;

    /**
     * SMS type (SmsType.SmsPro -&gt; SMS PRO, SmsType.SmsEco -&gt; SMS ECO, SmsType.SmsTwoWay -&gt; SMS 2WAY)
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("type")
    private Optional<? extends SmsType> type;

    /**
     * Should the message be sent with special characters, e.g. Polish diacritics (if any)? If <em>false</em>, those characters will be automatically replaced with their equivalents. If <em>true</em> your message will be sent as <strong>unicode</strong> but the message will be able to consist of fewer characters.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("unicode")
    private Optional<Boolean> unicode;

    /**
     * Should the message to be sent with class 0 (FLASH)?
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("flash")
    private Optional<Boolean> flash;

    /**
     * Scheduled future date and time of sending the message (in ISO 8601 format). If missing or null - message will be sent immediately
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("date")
    private JsonNullable<OffsetDateTime> date;

    @JsonCreator
    public SmsMessage(
            @JsonProperty("recipients") SmsMessageRecipients recipients,
            @JsonProperty("message") String message,
            @JsonProperty("sender") Optional<String> sender,
            @JsonProperty("type") Optional<? extends SmsType> type,
            @JsonProperty("unicode") Optional<Boolean> unicode,
            @JsonProperty("flash") Optional<Boolean> flash,
            @JsonProperty("date") JsonNullable<OffsetDateTime> date) {
        Utils.checkNotNull(recipients, "recipients");
        Utils.checkNotNull(message, "message");
        Utils.checkNotNull(sender, "sender");
        Utils.checkNotNull(type, "type");
        Utils.checkNotNull(unicode, "unicode");
        Utils.checkNotNull(flash, "flash");
        Utils.checkNotNull(date, "date");
        this.recipients = recipients;
        this.message = message;
        this.sender = sender;
        this.type = type;
        this.unicode = unicode;
        this.flash = flash;
        this.date = date;
    }
    
    public SmsMessage(
            SmsMessageRecipients recipients,
            String message) {
        this(recipients, message, Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), JsonNullable.undefined());
    }

    /**
     * The recipient number or multiple recipients numbers of single message. To set one recipient, please use <code>SmsMessageRecipients.of(String)</code> method simply passing to it a <code>string</code> with his phone number. To set multiple recipients, please use <code>SmsMessageRecipients.ofArrayOfStrings(List.of(String,...))</code> method passing to it <code>List&lt;string&gt;</code>. Optionally you can also set custom id (user identifier) for each message - use <code>SmsMessageRecipients.of(PhoneNumberWithCid)</code> method passing <code>PhoneNumberWithCid</code> object (in case of single recipient) or <code>SmsMessageRecipients.ofArrayOfPhoneNumberWithCids(Recipients.of(PhoneNumberWithCid,...))</code> method passing List&lt;PhoneNumberWithCid&gt; (in case of multiple recipients).
     */
    @JsonIgnore
    public SmsMessageRecipients recipients() {
        return recipients;
    }

    /**
     * SMS message content
     */
    @JsonIgnore
    public String message() {
        return message;
    }

    /**
     * SMS sender name
     */
    @JsonIgnore
    public Optional<String> sender() {
        return sender;
    }

    /**
     * SMS type (SmsType.SmsPro -&gt; SMS PRO, SmsType.SmsEco -&gt; SMS ECO, SmsType.SmsTwoWay -&gt; SMS 2WAY)
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public Optional<SmsType> type() {
        return (Optional<SmsType>) type;
    }

    /**
     * Should the message be sent with special characters, e.g. Polish diacritics (if any)? If <em>false</em>, those characters will be automatically replaced with their equivalents. If <em>true</em> your message will be sent as <strong>unicode</strong> but the message will be able to consist of fewer characters.
     */
    @JsonIgnore
    public Optional<Boolean> unicode() {
        return unicode;
    }

    /**
     * Should the message to be sent with class 0 (FLASH)?
     */
    @JsonIgnore
    public Optional<Boolean> flash() {
        return flash;
    }

    /**
     * Scheduled future date and time of sending the message (in ISO 8601 format). If missing or null - message will be sent immediately
     */
    @JsonIgnore
    public JsonNullable<OffsetDateTime> date() {
        return date;
    }

    public final static Builder builder() {
        return new Builder();
    }

    /**
     * The recipient number or multiple recipients numbers of single message. To set one recipient, please use <code>SmsMessageRecipients.of(String)</code> method simply passing to it a <code>string</code> with his phone number. To set multiple recipients, please use <code>SmsMessageRecipients.ofArrayOfStrings(List.of(String,...))</code> method passing to it <code>List&lt;string&gt;</code>. Optionally you can also set custom id (user identifier) for each message - use <code>SmsMessageRecipients.of(PhoneNumberWithCid)</code> method passing <code>PhoneNumberWithCid</code> object (in case of single recipient) or <code>SmsMessageRecipients.ofArrayOfPhoneNumberWithCids(Recipients.of(PhoneNumberWithCid,...))</code> method passing List&lt;PhoneNumberWithCid&gt; (in case of multiple recipients).
     */
    public SmsMessage withRecipients(SmsMessageRecipients recipients) {
        Utils.checkNotNull(recipients, "recipients");
        this.recipients = recipients;
        return this;
    }

    /**
     * SMS message content
     */
    public SmsMessage withMessage(String message) {
        Utils.checkNotNull(message, "message");
        this.message = message;
        return this;
    }

    /**
     * SMS sender name
     */
    public SmsMessage withSender(String sender) {
        Utils.checkNotNull(sender, "sender");
        this.sender = Optional.ofNullable(sender);
        return this;
    }

    /**
     * SMS sender name
     */
    public SmsMessage withSender(Optional<String> sender) {
        Utils.checkNotNull(sender, "sender");
        this.sender = sender;
        return this;
    }

    /**
     * SMS type (SmsType.SmsPro -&gt; SMS PRO, SmsType.SmsEco -&gt; SMS ECO, SmsType.SmsTwoWay -&gt; SMS 2WAY)
     */
    public SmsMessage withType(SmsType type) {
        Utils.checkNotNull(type, "type");
        this.type = Optional.ofNullable(type);
        return this;
    }

    /**
     * SMS type (SmsType.SmsPro -&gt; SMS PRO, SmsType.SmsEco -&gt; SMS ECO, SmsType.SmsTwoWay -&gt; SMS 2WAY)
     */
    public SmsMessage withType(Optional<? extends SmsType> type) {
        Utils.checkNotNull(type, "type");
        this.type = type;
        return this;
    }

    /**
     * Should the message be sent with special characters, e.g. Polish diacritics (if any)? If <em>false</em>, those characters will be automatically replaced with their equivalents. If <em>true</em> your message will be sent as <strong>unicode</strong> but the message will be able to consist of fewer characters.
     */
    public SmsMessage withUnicode(boolean unicode) {
        Utils.checkNotNull(unicode, "unicode");
        this.unicode = Optional.ofNullable(unicode);
        return this;
    }

    /**
     * Should the message be sent with special characters, e.g. Polish diacritics (if any)? If <em>false</em>, those characters will be automatically replaced with their equivalents. If <em>true</em> your message will be sent as <strong>unicode</strong> but the message will be able to consist of fewer characters.
     */
    public SmsMessage withUnicode(Optional<Boolean> unicode) {
        Utils.checkNotNull(unicode, "unicode");
        this.unicode = unicode;
        return this;
    }

    /**
     * Should the message to be sent with class 0 (FLASH)?
     */
    public SmsMessage withFlash(boolean flash) {
        Utils.checkNotNull(flash, "flash");
        this.flash = Optional.ofNullable(flash);
        return this;
    }

    /**
     * Should the message to be sent with class 0 (FLASH)?
     */
    public SmsMessage withFlash(Optional<Boolean> flash) {
        Utils.checkNotNull(flash, "flash");
        this.flash = flash;
        return this;
    }

    /**
     * Scheduled future date and time of sending the message (in ISO 8601 format). If missing or null - message will be sent immediately
     */
    public SmsMessage withDate(OffsetDateTime date) {
        Utils.checkNotNull(date, "date");
        this.date = JsonNullable.of(date);
        return this;
    }

    /**
     * Scheduled future date and time of sending the message (in ISO 8601 format). If missing or null - message will be sent immediately
     */
    public SmsMessage withDate(JsonNullable<OffsetDateTime> date) {
        Utils.checkNotNull(date, "date");
        this.date = date;
        return this;
    }
    
    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        SmsMessage other = (SmsMessage) o;
        return 
            Objects.deepEquals(this.recipients, other.recipients) &&
            Objects.deepEquals(this.message, other.message) &&
            Objects.deepEquals(this.sender, other.sender) &&
            Objects.deepEquals(this.type, other.type) &&
            Objects.deepEquals(this.unicode, other.unicode) &&
            Objects.deepEquals(this.flash, other.flash) &&
            Objects.deepEquals(this.date, other.date);
    }
    
    @Override
    public int hashCode() {
        return Objects.hash(
            recipients,
            message,
            sender,
            type,
            unicode,
            flash,
            date);
    }
    
    @Override
    public String toString() {
        return Utils.toString(SmsMessage.class,
                "recipients", recipients,
                "message", message,
                "sender", sender,
                "type", type,
                "unicode", unicode,
                "flash", flash,
                "date", date);
    }
    
    public final static class Builder {
 
        private SmsMessageRecipients recipients;
 
        private String message;
 
        private Optional<String> sender;
 
        private Optional<? extends SmsType> type;
 
        private Optional<Boolean> unicode;
 
        private Optional<Boolean> flash;
 
        private JsonNullable<OffsetDateTime> date;  
        
        private Builder() {
          // force use of static builder() method
        }

        /**
         * The recipient number or multiple recipients numbers of single message. To set one recipient, please use <code>SmsMessageRecipients.of(String)</code> method simply passing to it a <code>string</code> with his phone number. To set multiple recipients, please use <code>SmsMessageRecipients.ofArrayOfStrings(List.of(String,...))</code> method passing to it <code>List&lt;string&gt;</code>. Optionally you can also set custom id (user identifier) for each message - use <code>SmsMessageRecipients.of(PhoneNumberWithCid)</code> method passing <code>PhoneNumberWithCid</code> object (in case of single recipient) or <code>SmsMessageRecipients.ofArrayOfPhoneNumberWithCids(Recipients.of(PhoneNumberWithCid,...))</code> method passing List&lt;PhoneNumberWithCid&gt; (in case of multiple recipients).
         */
        public Builder recipients(SmsMessageRecipients recipients) {
            Utils.checkNotNull(recipients, "recipients");
            this.recipients = recipients;
            return this;
        }

        /**
         * SMS message content
         */
        public Builder message(String message) {
            Utils.checkNotNull(message, "message");
            this.message = message;
            return this;
        }

        /**
         * SMS sender name
         */
        public Builder sender(String sender) {
            Utils.checkNotNull(sender, "sender");
            this.sender = Optional.ofNullable(sender);
            return this;
        }

        /**
         * SMS sender name
         */
        public Builder sender(Optional<String> sender) {
            Utils.checkNotNull(sender, "sender");
            this.sender = sender;
            return this;
        }

        /**
         * SMS type (SmsType.SmsPro -&gt; SMS PRO, SmsType.SmsEco -&gt; SMS ECO, SmsType.SmsTwoWay -&gt; SMS 2WAY)
         */
        public Builder type(SmsType type) {
            Utils.checkNotNull(type, "type");
            this.type = Optional.ofNullable(type);
            return this;
        }

        /**
         * SMS type (SmsType.SmsPro -&gt; SMS PRO, SmsType.SmsEco -&gt; SMS ECO, SmsType.SmsTwoWay -&gt; SMS 2WAY)
         */
        public Builder type(Optional<? extends SmsType> type) {
            Utils.checkNotNull(type, "type");
            this.type = type;
            return this;
        }

        /**
         * Should the message be sent with special characters, e.g. Polish diacritics (if any)? If <em>false</em>, those characters will be automatically replaced with their equivalents. If <em>true</em> your message will be sent as <strong>unicode</strong> but the message will be able to consist of fewer characters.
         */
        public Builder unicode(boolean unicode) {
            Utils.checkNotNull(unicode, "unicode");
            this.unicode = Optional.ofNullable(unicode);
            return this;
        }

        /**
         * Should the message be sent with special characters, e.g. Polish diacritics (if any)? If <em>false</em>, those characters will be automatically replaced with their equivalents. If <em>true</em> your message will be sent as <strong>unicode</strong> but the message will be able to consist of fewer characters.
         */
        public Builder unicode(Optional<Boolean> unicode) {
            Utils.checkNotNull(unicode, "unicode");
            this.unicode = unicode;
            return this;
        }

        /**
         * Should the message to be sent with class 0 (FLASH)?
         */
        public Builder flash(boolean flash) {
            Utils.checkNotNull(flash, "flash");
            this.flash = Optional.ofNullable(flash);
            return this;
        }

        /**
         * Should the message to be sent with class 0 (FLASH)?
         */
        public Builder flash(Optional<Boolean> flash) {
            Utils.checkNotNull(flash, "flash");
            this.flash = flash;
            return this;
        }

        /**
         * Scheduled future date and time of sending the message (in ISO 8601 format). If missing or null - message will be sent immediately
         */
        public Builder date(OffsetDateTime date) {
            Utils.checkNotNull(date, "date");
            this.date = JsonNullable.of(date);
            return this;
        }

        /**
         * Scheduled future date and time of sending the message (in ISO 8601 format). If missing or null - message will be sent immediately
         */
        public Builder date(JsonNullable<OffsetDateTime> date) {
            Utils.checkNotNull(date, "date");
            this.date = date;
            return this;
        }
        
        public SmsMessage build() {
            if (sender == null) {
                sender = _SINGLETON_VALUE_Sender.value();
            }
            if (type == null) {
                type = _SINGLETON_VALUE_Type.value();
            }
            if (unicode == null) {
                unicode = _SINGLETON_VALUE_Unicode.value();
            }
            if (flash == null) {
                flash = _SINGLETON_VALUE_Flash.value();
            }
            if (date == null) {
                date = _SINGLETON_VALUE_Date.value();
            }            return new SmsMessage(
                recipients,
                message,
                sender,
                type,
                unicode,
                flash,
                date);
        }

        private static final LazySingletonValue<Optional<String>> _SINGLETON_VALUE_Sender =
                new LazySingletonValue<>(
                        "sender",
                        "\"Bramka SMS\"",
                        new TypeReference<Optional<String>>() {});

        private static final LazySingletonValue<Optional<? extends SmsType>> _SINGLETON_VALUE_Type =
                new LazySingletonValue<>(
                        "type",
                        "1",
                        new TypeReference<Optional<? extends SmsType>>() {});

        private static final LazySingletonValue<Optional<Boolean>> _SINGLETON_VALUE_Unicode =
                new LazySingletonValue<>(
                        "unicode",
                        "false",
                        new TypeReference<Optional<Boolean>>() {});

        private static final LazySingletonValue<Optional<Boolean>> _SINGLETON_VALUE_Flash =
                new LazySingletonValue<>(
                        "flash",
                        "false",
                        new TypeReference<Optional<Boolean>>() {});

        private static final LazySingletonValue<JsonNullable<OffsetDateTime>> _SINGLETON_VALUE_Date =
                new LazySingletonValue<>(
                        "date",
                        "null",
                        new TypeReference<JsonNullable<OffsetDateTime>>() {});
    }
}

