/*
 * Decompiled with CFR 0.152.
 */
package pl.gsmservice.gateway.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import java.util.Optional;
import org.openapitools.jackson.nullable.JsonNullable;
import pl.gsmservice.gateway.models.components.ErrorResponse;
import pl.gsmservice.gateway.utils.Utils;

public class CancelledMessage {
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="id")
    private Optional<Long> id;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="status")
    private Optional<Long> status;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="error")
    private JsonNullable<? extends ErrorResponse> error;

    @JsonCreator
    public CancelledMessage(@JsonProperty(value="id") Optional<Long> id, @JsonProperty(value="status") Optional<Long> status, @JsonProperty(value="error") JsonNullable<? extends ErrorResponse> error) {
        Utils.checkNotNull(id, "id");
        Utils.checkNotNull(status, "status");
        Utils.checkNotNull(error, "error");
        this.id = id;
        this.status = status;
        this.error = error;
    }

    public CancelledMessage() {
        this(Optional.empty(), Optional.empty(), (JsonNullable<? extends ErrorResponse>)JsonNullable.undefined());
    }

    @JsonIgnore
    public Optional<Long> id() {
        return this.id;
    }

    @JsonIgnore
    public Optional<Long> status() {
        return this.status;
    }

    @JsonIgnore
    public JsonNullable<ErrorResponse> error() {
        return this.error;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public CancelledMessage withId(long id) {
        Utils.checkNotNull(id, "id");
        this.id = Optional.ofNullable(id);
        return this;
    }

    public CancelledMessage withId(Optional<Long> id) {
        Utils.checkNotNull(id, "id");
        this.id = id;
        return this;
    }

    public CancelledMessage withStatus(long status) {
        Utils.checkNotNull(status, "status");
        this.status = Optional.ofNullable(status);
        return this;
    }

    public CancelledMessage withStatus(Optional<Long> status) {
        Utils.checkNotNull(status, "status");
        this.status = status;
        return this;
    }

    public CancelledMessage withError(ErrorResponse error) {
        Utils.checkNotNull(error, "error");
        this.error = JsonNullable.of((Object)error);
        return this;
    }

    public CancelledMessage withError(JsonNullable<? extends ErrorResponse> error) {
        Utils.checkNotNull(error, "error");
        this.error = error;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CancelledMessage other = (CancelledMessage)o;
        return Objects.deepEquals(this.id, other.id) && Objects.deepEquals(this.status, other.status) && Objects.deepEquals(this.error, other.error);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.status, this.error);
    }

    public String toString() {
        return Utils.toString(CancelledMessage.class, "id", this.id, "status", this.status, "error", this.error);
    }

    public static final class Builder {
        private Optional<Long> id = Optional.empty();
        private Optional<Long> status = Optional.empty();
        private JsonNullable<? extends ErrorResponse> error = JsonNullable.undefined();

        private Builder() {
        }

        public Builder id(long id) {
            Utils.checkNotNull(id, "id");
            this.id = Optional.ofNullable(id);
            return this;
        }

        public Builder id(Optional<Long> id) {
            Utils.checkNotNull(id, "id");
            this.id = id;
            return this;
        }

        public Builder status(long status) {
            Utils.checkNotNull(status, "status");
            this.status = Optional.ofNullable(status);
            return this;
        }

        public Builder status(Optional<Long> status) {
            Utils.checkNotNull(status, "status");
            this.status = status;
            return this;
        }

        public Builder error(ErrorResponse error) {
            Utils.checkNotNull(error, "error");
            this.error = JsonNullable.of((Object)error);
            return this;
        }

        public Builder error(JsonNullable<? extends ErrorResponse> error) {
            Utils.checkNotNull(error, "error");
            this.error = error;
            return this;
        }

        public CancelledMessage build() {
            return new CancelledMessage(this.id, this.status, this.error);
        }
    }
}

