/*
 * Decompiled with CFR 0.152.
 */
package pl.gsmservice.gateway.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;
import java.util.Objects;
import java.util.Optional;
import org.openapitools.jackson.nullable.JsonNullable;
import pl.gsmservice.gateway.utils.Utils;

public class IncomingMessage {
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="id")
    private Optional<Long> id;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="login")
    private Optional<String> login;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="recipient")
    private Optional<String> recipient;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="sender")
    private Optional<String> sender;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="phonebook_sender_name")
    private JsonNullable<String> phonebookSenderName;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="date")
    private Optional<OffsetDateTime> date;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="message")
    private Optional<String> message;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="dedicated_number")
    private JsonNullable<String> dedicatedNumber;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="dedicated_prefix")
    private JsonNullable<String> dedicatedPrefix;

    @JsonCreator
    public IncomingMessage(@JsonProperty(value="id") Optional<Long> id, @JsonProperty(value="login") Optional<String> login, @JsonProperty(value="recipient") Optional<String> recipient, @JsonProperty(value="sender") Optional<String> sender, @JsonProperty(value="phonebook_sender_name") JsonNullable<String> phonebookSenderName, @JsonProperty(value="date") Optional<OffsetDateTime> date, @JsonProperty(value="message") Optional<String> message, @JsonProperty(value="dedicated_number") JsonNullable<String> dedicatedNumber, @JsonProperty(value="dedicated_prefix") JsonNullable<String> dedicatedPrefix) {
        Utils.checkNotNull(id, "id");
        Utils.checkNotNull(login, "login");
        Utils.checkNotNull(recipient, "recipient");
        Utils.checkNotNull(sender, "sender");
        Utils.checkNotNull(phonebookSenderName, "phonebookSenderName");
        Utils.checkNotNull(date, "date");
        Utils.checkNotNull(message, "message");
        Utils.checkNotNull(dedicatedNumber, "dedicatedNumber");
        Utils.checkNotNull(dedicatedPrefix, "dedicatedPrefix");
        this.id = id;
        this.login = login;
        this.recipient = recipient;
        this.sender = sender;
        this.phonebookSenderName = phonebookSenderName;
        this.date = date;
        this.message = message;
        this.dedicatedNumber = dedicatedNumber;
        this.dedicatedPrefix = dedicatedPrefix;
    }

    public IncomingMessage() {
        this(Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), (JsonNullable<String>)JsonNullable.undefined(), Optional.empty(), Optional.empty(), (JsonNullable<String>)JsonNullable.undefined(), (JsonNullable<String>)JsonNullable.undefined());
    }

    @JsonIgnore
    public Optional<Long> id() {
        return this.id;
    }

    @JsonIgnore
    public Optional<String> login() {
        return this.login;
    }

    @JsonIgnore
    public Optional<String> recipient() {
        return this.recipient;
    }

    @JsonIgnore
    public Optional<String> sender() {
        return this.sender;
    }

    @JsonIgnore
    public JsonNullable<String> phonebookSenderName() {
        return this.phonebookSenderName;
    }

    @JsonIgnore
    public Optional<OffsetDateTime> date() {
        return this.date;
    }

    @JsonIgnore
    public Optional<String> message() {
        return this.message;
    }

    @JsonIgnore
    public JsonNullable<String> dedicatedNumber() {
        return this.dedicatedNumber;
    }

    @JsonIgnore
    public JsonNullable<String> dedicatedPrefix() {
        return this.dedicatedPrefix;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public IncomingMessage withId(long id) {
        Utils.checkNotNull(id, "id");
        this.id = Optional.ofNullable(id);
        return this;
    }

    public IncomingMessage withId(Optional<Long> id) {
        Utils.checkNotNull(id, "id");
        this.id = id;
        return this;
    }

    public IncomingMessage withLogin(String login) {
        Utils.checkNotNull(login, "login");
        this.login = Optional.ofNullable(login);
        return this;
    }

    public IncomingMessage withLogin(Optional<String> login) {
        Utils.checkNotNull(login, "login");
        this.login = login;
        return this;
    }

    public IncomingMessage withRecipient(String recipient) {
        Utils.checkNotNull(recipient, "recipient");
        this.recipient = Optional.ofNullable(recipient);
        return this;
    }

    public IncomingMessage withRecipient(Optional<String> recipient) {
        Utils.checkNotNull(recipient, "recipient");
        this.recipient = recipient;
        return this;
    }

    public IncomingMessage withSender(String sender) {
        Utils.checkNotNull(sender, "sender");
        this.sender = Optional.ofNullable(sender);
        return this;
    }

    public IncomingMessage withSender(Optional<String> sender) {
        Utils.checkNotNull(sender, "sender");
        this.sender = sender;
        return this;
    }

    public IncomingMessage withPhonebookSenderName(String phonebookSenderName) {
        Utils.checkNotNull(phonebookSenderName, "phonebookSenderName");
        this.phonebookSenderName = JsonNullable.of((Object)phonebookSenderName);
        return this;
    }

    public IncomingMessage withPhonebookSenderName(JsonNullable<String> phonebookSenderName) {
        Utils.checkNotNull(phonebookSenderName, "phonebookSenderName");
        this.phonebookSenderName = phonebookSenderName;
        return this;
    }

    public IncomingMessage withDate(OffsetDateTime date) {
        Utils.checkNotNull(date, "date");
        this.date = Optional.ofNullable(date);
        return this;
    }

    public IncomingMessage withDate(Optional<OffsetDateTime> date) {
        Utils.checkNotNull(date, "date");
        this.date = date;
        return this;
    }

    public IncomingMessage withMessage(String message) {
        Utils.checkNotNull(message, "message");
        this.message = Optional.ofNullable(message);
        return this;
    }

    public IncomingMessage withMessage(Optional<String> message) {
        Utils.checkNotNull(message, "message");
        this.message = message;
        return this;
    }

    public IncomingMessage withDedicatedNumber(String dedicatedNumber) {
        Utils.checkNotNull(dedicatedNumber, "dedicatedNumber");
        this.dedicatedNumber = JsonNullable.of((Object)dedicatedNumber);
        return this;
    }

    public IncomingMessage withDedicatedNumber(JsonNullable<String> dedicatedNumber) {
        Utils.checkNotNull(dedicatedNumber, "dedicatedNumber");
        this.dedicatedNumber = dedicatedNumber;
        return this;
    }

    public IncomingMessage withDedicatedPrefix(String dedicatedPrefix) {
        Utils.checkNotNull(dedicatedPrefix, "dedicatedPrefix");
        this.dedicatedPrefix = JsonNullable.of((Object)dedicatedPrefix);
        return this;
    }

    public IncomingMessage withDedicatedPrefix(JsonNullable<String> dedicatedPrefix) {
        Utils.checkNotNull(dedicatedPrefix, "dedicatedPrefix");
        this.dedicatedPrefix = dedicatedPrefix;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IncomingMessage other = (IncomingMessage)o;
        return Objects.deepEquals(this.id, other.id) && Objects.deepEquals(this.login, other.login) && Objects.deepEquals(this.recipient, other.recipient) && Objects.deepEquals(this.sender, other.sender) && Objects.deepEquals(this.phonebookSenderName, other.phonebookSenderName) && Objects.deepEquals(this.date, other.date) && Objects.deepEquals(this.message, other.message) && Objects.deepEquals(this.dedicatedNumber, other.dedicatedNumber) && Objects.deepEquals(this.dedicatedPrefix, other.dedicatedPrefix);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.login, this.recipient, this.sender, this.phonebookSenderName, this.date, this.message, this.dedicatedNumber, this.dedicatedPrefix);
    }

    public String toString() {
        return Utils.toString(IncomingMessage.class, "id", this.id, "login", this.login, "recipient", this.recipient, "sender", this.sender, "phonebookSenderName", this.phonebookSenderName, "date", this.date, "message", this.message, "dedicatedNumber", this.dedicatedNumber, "dedicatedPrefix", this.dedicatedPrefix);
    }

    public static final class Builder {
        private Optional<Long> id = Optional.empty();
        private Optional<String> login = Optional.empty();
        private Optional<String> recipient = Optional.empty();
        private Optional<String> sender = Optional.empty();
        private JsonNullable<String> phonebookSenderName = JsonNullable.undefined();
        private Optional<OffsetDateTime> date = Optional.empty();
        private Optional<String> message = Optional.empty();
        private JsonNullable<String> dedicatedNumber = JsonNullable.undefined();
        private JsonNullable<String> dedicatedPrefix = JsonNullable.undefined();

        private Builder() {
        }

        public Builder id(long id) {
            Utils.checkNotNull(id, "id");
            this.id = Optional.ofNullable(id);
            return this;
        }

        public Builder id(Optional<Long> id) {
            Utils.checkNotNull(id, "id");
            this.id = id;
            return this;
        }

        public Builder login(String login) {
            Utils.checkNotNull(login, "login");
            this.login = Optional.ofNullable(login);
            return this;
        }

        public Builder login(Optional<String> login) {
            Utils.checkNotNull(login, "login");
            this.login = login;
            return this;
        }

        public Builder recipient(String recipient) {
            Utils.checkNotNull(recipient, "recipient");
            this.recipient = Optional.ofNullable(recipient);
            return this;
        }

        public Builder recipient(Optional<String> recipient) {
            Utils.checkNotNull(recipient, "recipient");
            this.recipient = recipient;
            return this;
        }

        public Builder sender(String sender) {
            Utils.checkNotNull(sender, "sender");
            this.sender = Optional.ofNullable(sender);
            return this;
        }

        public Builder sender(Optional<String> sender) {
            Utils.checkNotNull(sender, "sender");
            this.sender = sender;
            return this;
        }

        public Builder phonebookSenderName(String phonebookSenderName) {
            Utils.checkNotNull(phonebookSenderName, "phonebookSenderName");
            this.phonebookSenderName = JsonNullable.of((Object)phonebookSenderName);
            return this;
        }

        public Builder phonebookSenderName(JsonNullable<String> phonebookSenderName) {
            Utils.checkNotNull(phonebookSenderName, "phonebookSenderName");
            this.phonebookSenderName = phonebookSenderName;
            return this;
        }

        public Builder date(OffsetDateTime date) {
            Utils.checkNotNull(date, "date");
            this.date = Optional.ofNullable(date);
            return this;
        }

        public Builder date(Optional<OffsetDateTime> date) {
            Utils.checkNotNull(date, "date");
            this.date = date;
            return this;
        }

        public Builder message(String message) {
            Utils.checkNotNull(message, "message");
            this.message = Optional.ofNullable(message);
            return this;
        }

        public Builder message(Optional<String> message) {
            Utils.checkNotNull(message, "message");
            this.message = message;
            return this;
        }

        public Builder dedicatedNumber(String dedicatedNumber) {
            Utils.checkNotNull(dedicatedNumber, "dedicatedNumber");
            this.dedicatedNumber = JsonNullable.of((Object)dedicatedNumber);
            return this;
        }

        public Builder dedicatedNumber(JsonNullable<String> dedicatedNumber) {
            Utils.checkNotNull(dedicatedNumber, "dedicatedNumber");
            this.dedicatedNumber = dedicatedNumber;
            return this;
        }

        public Builder dedicatedPrefix(String dedicatedPrefix) {
            Utils.checkNotNull(dedicatedPrefix, "dedicatedPrefix");
            this.dedicatedPrefix = JsonNullable.of((Object)dedicatedPrefix);
            return this;
        }

        public Builder dedicatedPrefix(JsonNullable<String> dedicatedPrefix) {
            Utils.checkNotNull(dedicatedPrefix, "dedicatedPrefix");
            this.dedicatedPrefix = dedicatedPrefix;
            return this;
        }

        public IncomingMessage build() {
            return new IncomingMessage(this.id, this.login, this.recipient, this.sender, this.phonebookSenderName, this.date, this.message, this.dedicatedNumber, this.dedicatedPrefix);
        }
    }
}

